/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocAlertInfo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAlertInfoBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocDealAlertInfoTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocDealAlertInfoTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocDealAlertInfoRspBO dealAlertInfoAdd(UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBO = UocRu.success(UocDealAlertInfoRspBO.class);
        ArrayList<UocAlertInfoBO> uocAlertInfoBOList = new ArrayList<UocAlertInfoBO>(reqBO.getUocAlertInfoBOList());
        rspBO.setUocAlertInfoBOList(uocAlertInfoBOList);
        UocAlertInfo allUpdateUocAlertInfo = new UocAlertInfo();
        allUpdateUocAlertInfo.setOldAlertState(UocConstant.UocAlertState.TO_DEAL);
        allUpdateUocAlertInfo.setAlertState(UocConstant.UocAlertState.IN_DEAL);
        allUpdateUocAlertInfo.setAlertType(((UocAlertInfoBO)reqBO.getUocAlertInfoBOList().get(0)).getAlertType());
        allUpdateUocAlertInfo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateUocAlertInfo(allUpdateUocAlertInfo);
        ArrayList<UocAlertInfo> newUocAlertInfoList = new ArrayList<UocAlertInfo>();
        for (UocAlertInfoBO bo : reqBO.getUocAlertInfoBOList()) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(bo.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(bo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            UocAlertInfo qryUocAlertInfo = new UocAlertInfo();
            qryUocAlertInfo.setObjId(bo.getObjId());
            qryUocAlertInfo.setObjType(bo.getObjType());
            qryUocAlertInfo.setAlertType(bo.getAlertType());
            qryUocAlertInfo.setAlertState(UocConstant.UocAlertState.IN_DEAL);
            List<UocAlertInfo> result = this.iUocSaleOrderModel.getUocAlertInfoList(qryUocAlertInfo);
            if (CollectionUtils.isEmpty(result)) {
                UocAlertInfo insertUocAlertInfo = new UocAlertInfo();
                insertUocAlertInfo.setId(IdUtil.nextId());
                insertUocAlertInfo.setOrderId(bo.getOrderId());
                insertUocAlertInfo.setObjId(bo.getObjId());
                insertUocAlertInfo.setObjType(bo.getObjType());
                insertUocAlertInfo.setAlertType(bo.getAlertType());
                insertUocAlertInfo.setAlertState(UocConstant.UocAlertState.TO_DEAL);
                insertUocAlertInfo.setCreateTime(new Date());
                insertUocAlertInfo.setCreateUserId(Long.valueOf(uocSaleOrderDo.getCreateOperId()));
                insertUocAlertInfo.setCreateUserName(uocSaleOrderDo.getCreateOperName());
                insertUocAlertInfo.setCreateOrgId(Long.valueOf(uocSaleOrderDo.getStakeholder().getPurOrgId()));
                insertUocAlertInfo.setCreateOrgName(uocSaleOrderDo.getStakeholder().getPurOrgName());
                insertUocAlertInfo.setCreateCompanyId(Long.valueOf(uocSaleOrderDo.getStakeholder().getPurCompanyId()));
                insertUocAlertInfo.setCreateCompanyName(uocSaleOrderDo.getStakeholder().getPurCompanyName());
                insertUocAlertInfo.setCreateOrgPath(uocSaleOrderDo.getStakeholder().getPurOrgPath());
                insertUocAlertInfo.setIsSend(0);
                newUocAlertInfoList.add(insertUocAlertInfo);
                continue;
            }
            UocAlertInfo uocAlertInfo = result.get(0);
            UocAlertInfo updateUocAlertInfo = new UocAlertInfo();
            updateUocAlertInfo.setId(uocAlertInfo.getId());
            updateUocAlertInfo.setObjId(bo.getObjId());
            updateUocAlertInfo.setObjType(bo.getObjType());
            updateUocAlertInfo.setAlertState(UocConstant.UocAlertState.TO_DEAL);
            updateUocAlertInfo.setUpdateTime(new Date());
            this.iUocSaleOrderModel.updateUocAlertInfo(updateUocAlertInfo);
        }
        if (!CollectionUtils.isEmpty(newUocAlertInfoList)) {
            this.iUocSaleOrderModel.insertUocAlertInfoBatch(newUocAlertInfoList);
        }
        UocAlertInfo qryUocAlertInfo = new UocAlertInfo();
        qryUocAlertInfo.setAlertState(UocConstant.UocAlertState.IN_DEAL);
        List<UocAlertInfo> dirtyData = this.iUocSaleOrderModel.getUocAlertInfoList(qryUocAlertInfo);
        if (!CollectionUtils.isEmpty(dirtyData)) {
            uocAlertInfoBOList.addAll(UocRu.jsl(dirtyData, UocAlertInfoBO.class));
        }
        UocAlertInfo finalAllUpdateUocAlertInfo = new UocAlertInfo();
        finalAllUpdateUocAlertInfo.setOldAlertState(UocConstant.UocAlertState.IN_DEAL);
        finalAllUpdateUocAlertInfo.setAlertState(UocConstant.UocAlertState.DEALED);
        finalAllUpdateUocAlertInfo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateUocAlertInfo(finalAllUpdateUocAlertInfo);
        return rspBO;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocDealAlertInfoRspBO dealAlertInfoUpdate(UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBO = UocRu.success(UocDealAlertInfoRspBO.class);
        ArrayList<UocAlertInfoBO> uocAlertInfoBOList = new ArrayList<UocAlertInfoBO>();
        rspBO.setUocAlertInfoBOList(uocAlertInfoBOList);
        UocAlertInfo qryUocAlertInfo = new UocAlertInfo();
        qryUocAlertInfo.setAlertType(reqBO.getAlertType());
        qryUocAlertInfo.setAlertState(UocConstant.UocAlertState.TO_DEAL);
        List<UocAlertInfo> result = this.iUocSaleOrderModel.getUocAlertInfoList(qryUocAlertInfo);
        for (UocAlertInfo uocAlertInfo : result) {
            if (0 == uocAlertInfo.getIsSend()) {
                UocAlertInfo updateUocAlertInfo = new UocAlertInfo();
                updateUocAlertInfo.setId(uocAlertInfo.getId());
                updateUocAlertInfo.setObjId(uocAlertInfo.getObjId());
                updateUocAlertInfo.setObjType(uocAlertInfo.getObjType());
                updateUocAlertInfo.setIsSend(1);
                updateUocAlertInfo.setUpdateTime(new Date());
                this.iUocSaleOrderModel.updateUocAlertInfo(updateUocAlertInfo);
                uocAlertInfoBOList.add(UocRu.js(uocAlertInfo, UocAlertInfoBO.class));
                continue;
            }
            if (reqBO.getNoticeNumCheckFlag().booleanValue()) continue;
            uocAlertInfoBOList.add(UocRu.js(uocAlertInfo, UocAlertInfoBO.class));
        }
        return rspBO;
    }
}

