package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsPageReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsPageRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceRspItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description:销售单明细分页查询
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/7/25 下午5:15
 */
@HTServiceImpl
public class UocGetSaleOrderItemsPageServiceImpl implements UocGetSaleOrderItemsPageService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocGetSaleOrderItemsPageRspBo getSaleOrderItems(UocGetSaleOrderItemsPageReqBo reqBo) {
        // 入参校验
        validateParam(reqBo);
        // 查询销售单明细
        UocGetSaleOrderItemsPageRspBo rspBO = new UocGetSaleOrderItemsPageRspBo();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        BasePageRspBo<UocGetSaleOrderItemsServiceRspItemBo> result = iUocSaleOrderModel.getSaleOrderItemListPage(uocSaleOrderItemQryBo);
        rspBO.setRows(result.getRows());
        rspBO.setPageNo(result.getPageNo());
        rspBO.setTotal(result.getTotal());
        rspBO.setRecordsTotal(result.getRecordsTotal());
        return rspBO;
    }
    /**
     * 入参校验
     */
    private void validateParam(UocGetSaleOrderItemsPageReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}
