package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocAlertInfo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAlertInfoBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealAlertInfoRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Slf4j
@Component
public class UocDealAlertInfoTransaction {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocDealAlertInfoRspBO dealAlertInfoAdd(UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBO = UocRu.success(UocDealAlertInfoRspBO.class);
        List<UocAlertInfoBO> uocAlertInfoBOList = new ArrayList<>(reqBO.getUocAlertInfoBOList());
        rspBO.setUocAlertInfoBOList(uocAlertInfoBOList);
        //先全部更新为处理中
        UocAlertInfo allUpdateUocAlertInfo = new UocAlertInfo();
        allUpdateUocAlertInfo.setOldAlertState(UocConstant.UocAlertState.TO_DEAL);
        allUpdateUocAlertInfo.setAlertState(UocConstant.UocAlertState.IN_DEAL);
        allUpdateUocAlertInfo.setAlertType(reqBO.getUocAlertInfoBOList().get(0).getAlertType());
        allUpdateUocAlertInfo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateUocAlertInfo(allUpdateUocAlertInfo);
        List<UocAlertInfo> newUocAlertInfoList = new ArrayList<>();
        for (UocAlertInfoBO bo : reqBO.getUocAlertInfoBOList()) {
            //查询销售单信息
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(bo.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(bo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo =  iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            //先查询
            UocAlertInfo qryUocAlertInfo = new UocAlertInfo();
            qryUocAlertInfo.setObjId(bo.getObjId());
            qryUocAlertInfo.setObjType(bo.getObjType());
            qryUocAlertInfo.setAlertType(bo.getAlertType());
            qryUocAlertInfo.setAlertState(UocConstant.UocAlertState.IN_DEAL);
            List<UocAlertInfo> result = this.iUocSaleOrderModel.getUocAlertInfoList(qryUocAlertInfo);
            if (CollectionUtils.isEmpty(result)) {
                //新增
                UocAlertInfo insertUocAlertInfo = new UocAlertInfo();
                insertUocAlertInfo.setId(IdUtil.nextId());
                insertUocAlertInfo.setOrderId(bo.getOrderId());
                insertUocAlertInfo.setObjId(bo.getObjId());
                insertUocAlertInfo.setObjType(bo.getObjType());
                insertUocAlertInfo.setAlertType(bo.getAlertType());
                insertUocAlertInfo.setAlertState(UocConstant.UocAlertState.TO_DEAL);
                insertUocAlertInfo.setCreateTime(new Date());
                insertUocAlertInfo.setCreateUserId(Long.valueOf(uocSaleOrderDo.getCreateOperId()));
                insertUocAlertInfo.setCreateUserName(uocSaleOrderDo.getCreateOperName());
                insertUocAlertInfo.setCreateOrgId(Long.valueOf(uocSaleOrderDo.getStakeholder().getPurOrgId()));
                insertUocAlertInfo.setCreateOrgName(uocSaleOrderDo.getStakeholder().getPurOrgName());
                insertUocAlertInfo.setCreateCompanyId(Long.valueOf(uocSaleOrderDo.getStakeholder().getPurCompanyId()));
                insertUocAlertInfo.setCreateCompanyName(uocSaleOrderDo.getStakeholder().getPurCompanyName());
                insertUocAlertInfo.setCreateOrgPath(uocSaleOrderDo.getStakeholder().getPurOrgPath());
                insertUocAlertInfo.setIsSend(0);
                newUocAlertInfoList.add(insertUocAlertInfo);
            }else {
                UocAlertInfo uocAlertInfo = result.get(0);
                //更新
                UocAlertInfo updateUocAlertInfo = new UocAlertInfo();
                updateUocAlertInfo.setId(uocAlertInfo.getId());
                updateUocAlertInfo.setObjId(bo.getObjId());
                updateUocAlertInfo.setObjType(bo.getObjType());
                updateUocAlertInfo.setAlertState(UocConstant.UocAlertState.TO_DEAL);
                updateUocAlertInfo.setUpdateTime(new Date());
                this.iUocSaleOrderModel.updateUocAlertInfo(updateUocAlertInfo);
            }
        }
        if (!CollectionUtils.isEmpty(newUocAlertInfoList)) {
            this.iUocSaleOrderModel.insertUocAlertInfoBatch(newUocAlertInfoList);
        }
        //先查出哪些是处理中的，这些数据后面也要同步es
        UocAlertInfo qryUocAlertInfo = new UocAlertInfo();
        qryUocAlertInfo.setAlertState(UocConstant.UocAlertState.IN_DEAL);
        List<UocAlertInfo> dirtyData = this.iUocSaleOrderModel.getUocAlertInfoList(qryUocAlertInfo);
        if (!CollectionUtils.isEmpty(dirtyData)) {
            uocAlertInfoBOList.addAll(UocRu.jsl(dirtyData, UocAlertInfoBO.class));
        }
        //先全部更新为处理中
        UocAlertInfo finalAllUpdateUocAlertInfo = new UocAlertInfo();
        finalAllUpdateUocAlertInfo.setOldAlertState(UocConstant.UocAlertState.IN_DEAL);
        finalAllUpdateUocAlertInfo.setAlertState(UocConstant.UocAlertState.DEALED);
        finalAllUpdateUocAlertInfo.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateUocAlertInfo(finalAllUpdateUocAlertInfo);
        return rspBO;
    }

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocDealAlertInfoRspBO dealAlertInfoUpdate(UocDealAlertInfoReqBO reqBO) {
        UocDealAlertInfoRspBO rspBO = UocRu.success(UocDealAlertInfoRspBO.class);
        List<UocAlertInfoBO> uocAlertInfoBOList = new ArrayList<>();
        rspBO.setUocAlertInfoBOList(uocAlertInfoBOList);
        //先查询
        UocAlertInfo qryUocAlertInfo = new UocAlertInfo();
        qryUocAlertInfo.setAlertType(reqBO.getAlertType());
        qryUocAlertInfo.setAlertState(UocConstant.UocAlertState.TO_DEAL);
        List<UocAlertInfo> result = this.iUocSaleOrderModel.getUocAlertInfoList(qryUocAlertInfo);
        //更新短信发送标识
        for (UocAlertInfo uocAlertInfo : result) {
            if (0 == uocAlertInfo.getIsSend()) {
                UocAlertInfo updateUocAlertInfo = new UocAlertInfo();
                updateUocAlertInfo.setId(uocAlertInfo.getId());
                updateUocAlertInfo.setObjId(uocAlertInfo.getObjId());
                updateUocAlertInfo.setObjType(uocAlertInfo.getObjType());
                updateUocAlertInfo.setIsSend(1);
                updateUocAlertInfo.setUpdateTime(new Date());
                this.iUocSaleOrderModel.updateUocAlertInfo(updateUocAlertInfo);
                uocAlertInfoBOList.add(UocRu.js(uocAlertInfo, UocAlertInfoBO.class));
            } else {
                if (!reqBO.getNoticeNumCheckFlag()) {
                    uocAlertInfoBOList.add(UocRu.js(uocAlertInfo, UocAlertInfoBO.class));
                }
            }
        }
        return rspBO;
    }
}
