/*
package com.tydic.dyc.oc.config.mq.consumer;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.dyc.base.events.Event;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.EventConsumerManger;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.constants.UocConstant;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

*/
/**
 * 描述：订单中心数据同步事件消费者（数据同步组件会发送mq消息，由订单中心进行消费，通过消费者进行数据同步）
 *
 * @author liao xing jun
 * @date 2019/11/11
 **//*


@Slf4j
public class UocSaleOrderSyncConsumer extends DefaultProxyMessageConfig implements ProxyMessageConsumer {
    private Logger logger = LoggerFactory.getLogger(UocSaleOrderSyncConsumer.class);

    @Autowired
    private UocEsSyncManager SyncManager;

    @Autowired
    private EventConsumerManger eventConsumerManger;

    @Override
    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        String messageId  =  proxyMessage.getMessageId();
        log.info("es消费者收到，消息id如下:{}", messageId);
    
        log.info("es消费者收到，数据内容如下:{}", JSON.toJSONString(content));

        if (ObjectUtil.isNotEmpty(content)) {
            ChannelEvent eventList = JSON.parseObject(content, ChannelEvent.class);
            List<Event> events = eventList.getTraceEventList();
            if (ObjectUtil.isNotEmpty(events)) {
                for (Event event : events) {
                    String eventCode = event.getCode();
                    Map<String, Object> paramMap = event.getParamMap();
                    EventConsumer eventConsumer;
                    try {
                        eventConsumer = eventConsumerManger.getEventConsumer(eventCode);
                    } catch (Exception e) {
                        log.error("Es同步消费根据事件编码获取事件失败：{}", e.getMessage());
                        return ProxyConsumerStatus.RECONSUME_LATER;
                    }
                    List<IUocEsSyncQryEventReqBo> eventReqBos = eventConsumer.parseMap(paramMap);
                    eventReqBos = validateArg(eventReqBos);
                    log.info("ES消费者检验通过数据信息：{}", JSON.toJSONString(eventReqBos));
                    if (null != eventReqBos && ObjectUtil.isNotEmpty(eventReqBos)) {
                        for (IUocEsSyncQryEventReqBo eventReqBo : eventReqBos) {
                            if (ObjectUtil.isNotEmpty(eventReqBo.getIndexName())) {
                                String indexName = eventReqBo.getIndexName();
                                List<IUocEsSyncQryReqBo> dataList = eventReqBo.getDataList();
                                if (!CollectionUtils.isEmpty(dataList)) {
                                    ConcurrentMap<Integer, List<IUocEsSyncQryReqBo>> dataMap =
                                            dataList.stream().collect(Collectors.groupingByConcurrent(IUocEsSyncQryReqBo::getOpFlag));
                                    List<IUocEsSyncQryReqBo> delDataList =
                                            dataMap.get(UocConstant.ES_SYNC_OP_FLAG.DELETE);
                                    if (!CollectionUtils.isEmpty(delDataList)) {
                                        delDataList.forEach(syncQryReqBo -> {
                                            UocEsSyncManagerSaveDataReqBo delDataReqBo =
                                                    new UocEsSyncManagerSaveDataReqBo();
                                            delDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                                            delDataReqBo.setObjId(syncQryReqBo.getObjId());
                                            delDataReqBo.setIndexName(indexName);
                                            delDataReqBo.setObjType(syncQryReqBo.getObjType());
                                            delDataReqBo.setJsonObj(syncQryReqBo.getJsonObj());
                                            log.info("同步数据删除参数入参:" + JSON.toJSONString(delDataReqBo));
                                            try {
                                                SyncManager.deleteData(delDataReqBo);
                                            } catch (Exception e) {
                                                log.error("Es同步数据删除参数失败：{}", e.getMessage());
                                            }
                                        });
                                    }
                                    List<IUocEsSyncQryReqBo> updateDataList =
                                            dataMap.get(UocConstant.ES_SYNC_OP_FLAG.UPDATE);
                                    if (!CollectionUtils.isEmpty(updateDataList)) {
                                        updateDataList.forEach(syncQryReqBo -> {
                                            UocEsSyncManagerSaveDataReqBo updateDataReqBo =
                                                    new UocEsSyncManagerSaveDataReqBo();
                                            updateDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                                            updateDataReqBo.setObjId(syncQryReqBo.getObjId());
                                            updateDataReqBo.setObjType(syncQryReqBo.getObjType());
                                            updateDataReqBo.setJsonObj(syncQryReqBo.getJsonObj());
                                            updateDataReqBo.setIndexName(indexName);
                                            log.info("同步数据更新参数入参:" + JSON.toJSONString(updateDataReqBo));
                                            try {
                                                SyncManager.updateData(updateDataReqBo);
                                            } catch (Exception e) {
                                                log.error("Es同步数据更新参数失败：{}", e.getMessage());
                                            }
                                        });
                                    }
                                    List<IUocEsSyncQryReqBo> saveDataList =
                                            dataMap.get(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                                    if (!CollectionUtils.isEmpty(saveDataList)) {
                                        saveDataList.forEach(syncQryReqBo -> {
                                            UocEsSyncManagerSaveDataReqBo saveDataReqBo =
                                                    new UocEsSyncManagerSaveDataReqBo();
                                            saveDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                                            saveDataReqBo.setObjId(syncQryReqBo.getObjId());
                                            saveDataReqBo.setObjType(syncQryReqBo.getObjType());
                                            saveDataReqBo.setJsonObj(syncQryReqBo.getJsonObj());
                                            saveDataReqBo.setIndexName(indexName);
                                            log.info("同步数据保存参数入参:" + JSON.toJSONString(saveDataReqBo));
                                            try {
                                                SyncManager.saveData(saveDataReqBo);
                                            } catch (Exception e) {
                                                log.error("Es同步数据保存参数失败：{}", e.getMessage());
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        log.info("订单数据同步消费完成，消息内容为:{}", JSON.toJSONString(content));
        return ProxyConsumerStatus.CONSUME_SUCCESS;

    }

    */
/**
     * 是否通过检验数据
     *
     * @param reqBo 入参
     * @return 通过检验数据
     *//*

    private List<IUocEsSyncQryEventReqBo> validateArg(List<IUocEsSyncQryEventReqBo> reqBo) {
        if (ObjectUtil.isNotEmpty(reqBo)) {
            if (reqBo == null) {
                return null;
            }
        }
        ArrayList<IUocEsSyncQryEventReqBo> iUocEsSyncQryEventReqBos =
                new ArrayList<>(reqBo.stream().collect(Collectors.toMap(IUocEsSyncQryEventReqBo::getIndexName, a -> a
                        , (o1, o2) -> {
                            if (ObjectUtil.isNotEmpty(o1.getIndexName())) {
                                if (!CollectionUtils.isEmpty(o1.getDataList()) || !CollectionUtils.isEmpty(o2.getDataList())) {
                                    List<IUocEsSyncQryReqBo> dataList = new ArrayList<>();
                                    if (!CollectionUtils.isEmpty(o1.getDataList())) {
                                        for (IUocEsSyncQryReqBo iUocEsSyncQryReqBo : o1.getDataList()) {
                                            if (ObjectUtil.isNotEmpty(iUocEsSyncQryReqBo.getOrderId()) && ObjectUtil.isNotEmpty(iUocEsSyncQryReqBo.getObjId())) {
                                                dataList.add(iUocEsSyncQryReqBo);
                                            }
                                        }
                                    }
                                    if (!CollectionUtils.isEmpty(o2.getDataList())) {
                                        for (IUocEsSyncQryReqBo iUocEsSyncQryReqBo : o2.getDataList()) {
                                            if (ObjectUtil.isNotEmpty(iUocEsSyncQryReqBo.getOrderId()) && ObjectUtil.isNotEmpty(iUocEsSyncQryReqBo.getObjId())) {
                                                dataList.add(iUocEsSyncQryReqBo);
                                            }
                                        }
                                    }
                                    o1.setDataList(dataList);
                                    return o1;
                                } else {
                                    return null;
                                }
                            } else {
                                return null;
                            }
                        })).values());

        for (IUocEsSyncQryEventReqBo iUocEsSyncQryEventReqBo : iUocEsSyncQryEventReqBos) {
            iUocEsSyncQryEventReqBo.setDataList(iUocEsSyncQryEventReqBo.getDataList().stream().distinct().collect(Collectors.toList()));
        }
        return iUocEsSyncQryEventReqBos;
    }
}
*/
