package com.tydic.dyc.oc.service.common;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.common.bo.UocQrySaleOrderListByApprovalReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQrySaleOrderListByApprovalRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;


@Slf4j
@HTServiceImpl
public class UocQrySaleOrderListByApprovalServiceImpl implements UocQrySaleOrderListByApprovalService{
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Override
    public UocQrySaleOrderListByApprovalRspBo qrySaleOrderList(UocQrySaleOrderListByApprovalReqBo reqBo) {
    
        UocQrySaleOrderListByApprovalRspBo rspBo = UocRu.success(UocQrySaleOrderListByApprovalRspBo.class);
        //查询审批单，订单id+审批单id+审批对象类型（2：销售单）
        log.info("查询审批单下得销售单列表入参为：{}", JSON.toJSONString(reqBo));
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        if (StringUtils.isNotBlank(reqBo.getAuditOrderId())){
            uocApprovalObjQryBo.setAuditOrderId(Long.parseLong(reqBo.getAuditOrderId()));
        }
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        List<Long> objIdList = uocApprovalObjs.stream().map(e->{
            return Long.valueOf(e.getObjId());
        }).collect(Collectors.toList());
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderIdList(objIdList);
        List<UocSaleOrderDo> uocSaleOrderDoList =  iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
    
        rspBo.setUocSaleOrderList(UocRu.jsl(uocSaleOrderDoList, UocSaleOrderBO.class));
        return rspBo;
    }

}
