/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.common;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.common.UocUnifyTodoQryService;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryBO;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryReqBO;
import com.tydic.dyc.oc.service.common.bo.UocUnifyTodoQryRspBO;
import java.text.SimpleDateFormat;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.common.UocUnifyTodoQryService"})
public class UocUnifyTodoQryServiceImpl
implements UocUnifyTodoQryService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @PostMapping(value={"qryTodoInfo"})
    public UocUnifyTodoQryRspBO qryTodoInfo(@RequestBody UocUnifyTodoQryReqBO reqBO) {
        UocUnifyTodoQryRspBO rspBO = this.judge(reqBO);
        UocUnifyTodoQryBO todoParamJson = new UocUnifyTodoQryBO();
        switch (reqBO.getObjType()) {
            case 1: {
                break;
            }
            case 2: {
                this.qrySale(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.qryShip(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.qryAfter(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.qryInsp(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            }
            case 9: {
                this.qryAudit(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            }
            case 10: {
                this.qryChng(reqBO.getShareId(), reqBO.getObjId(), rspBO, todoParamJson);
                break;
            }
        }
        rspBO.setParamJson(JSON.toJSONString((Object)todoParamJson));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void qrySale(Long orderId, Long saleOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(qryBo);
        todoParamJson.setOrderId(saleOrderDo.getOrderId());
        todoParamJson.setSaleOrderId(saleOrderDo.getSaleOrderId());
        todoParamJson.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        todoParamJson.setTotalSaleFee(saleOrderDo.getTotalSaleFee());
        todoParamJson.setProDeliveryName(saleOrderDo.getProDeliveryName());
        todoParamJson.setSaleOrderState(saleOrderDo.getSaleOrderState());
        todoParamJson.setModelSettle(saleOrderDo.getModelSettle());
        todoParamJson.setOrderSource(saleOrderDo.getOrderSource());
        todoParamJson.setPayType(saleOrderDo.getPayType());
        todoParamJson.setSaleOrderCreateUserId(Long.valueOf(Long.parseLong(saleOrderDo.getCreateOperId())));
        todoParamJson.setIsAgrIgnoreArrive(saleOrderDo.getIsAgrIgnoreArrive());
        todoParamJson.setAreaType(saleOrderDo.getAreaType());
        todoParamJson.setPurchaseMode(saleOrderDo.getPurchaseMode());
        todoParamJson.setJdCz(saleOrderDo.getJdCz());
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource()) && !StringUtils.isEmpty((Object)saleOrderDo.getAgreementId())) {
            UocOrderAgreementQryBo orderAgreementQryBo = new UocOrderAgreementQryBo();
            orderAgreementQryBo.setOrderId(saleOrderDo.getOrderId());
            orderAgreementQryBo.setAgreementId(saleOrderDo.getAgreementId());
            UocOrderAgreement agreementOrderBy = this.iUocSaleOrderModel.getAgreementOrderBy(orderAgreementQryBo);
            if (agreementOrderBy != null) {
                todoParamJson.setAgreementCode(agreementOrderBy.getAgreementCode());
            }
        }
        if (null != saleOrderDo.getIsAgrIgnoreArrive() && 1 == saleOrderDo.getIsAgrIgnoreArrive()) {
            UocShipOrderQryBo shipOrderQryBo = new UocShipOrderQryBo();
            shipOrderQryBo.setOrderId(saleOrderDo.getOrderId());
            shipOrderQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
            List<UocShipOrderDo> shipOrderDoList = this.iUocShipOrderModel.getListShipOrder(shipOrderQryBo);
            if (!CollectionUtils.isEmpty(shipOrderDoList)) {
                todoParamJson.setShipOrderId(shipOrderDoList.get(0).getShipOrderId());
                todoParamJson.setShipOrderNo(shipOrderDoList.get(0).getShipOrderNo());
                String estimateArrivalTime = new SimpleDateFormat("yyyy-MM-dd").format(shipOrderDoList.get(0).getEstimateArrivalTime());
                todoParamJson.setEstimateArrivalTime(estimateArrivalTime);
            }
        }
        rspBO.setProOrgId(Long.valueOf(Long.parseLong(saleOrderDo.getStakeholder().getProId())));
        rspBO.setPurOrgId(Long.valueOf(Long.parseLong(saleOrderDo.getStakeholder().getPurOrgId())));
        todoParamJson.setPurOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        rspBO.setSupOrgId(Long.valueOf(Long.parseLong(saleOrderDo.getStakeholder().getSupId())));
        rspBO.setObjCreateUserId(Long.valueOf(Long.parseLong(saleOrderDo.getCreateOperId())));
    }

    private void qryShip(Long orderId, Long shipOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setShipOrderId(shipOrderId);
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(qryBo);
        todoParamJson.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
        if (uocShipOrderDo.getEstimateArrivalTime() != null) {
            String estimateArrivalTime = new SimpleDateFormat("yyyy-MM-dd").format(uocShipOrderDo.getEstimateArrivalTime());
            todoParamJson.setEstimateArrivalTime(estimateArrivalTime);
        }
        this.qrySale(orderId, uocShipOrderDo.getSaleOrderId(), rspBO, todoParamJson);
        if (!StringUtils.isEmpty((Object)uocShipOrderDo.getCreateOperId())) {
            rspBO.setObjCreateUserId(Long.valueOf(Long.parseLong(uocShipOrderDo.getCreateOperId())));
        } else {
            rspBO.setObjCreateUserId(Long.valueOf(1L));
        }
    }

    private void qryAfter(Long orderId, Long afOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocAfOrderQryBo qryBo = new UocAfOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setAfOrderId(afOrderId);
        UocAfOrder uocAfOrder = this.iUocAfOrderModel.getAfOrderById(qryBo);
        todoParamJson.setAfServCode(uocAfOrder.getAfServCode());
        todoParamJson.setServState(uocAfOrder.getServState());
        this.qrySale(orderId, uocAfOrder.getSaleOrderId(), rspBO, todoParamJson);
        rspBO.setObjCreateUserId(Long.valueOf(Long.parseLong(uocAfOrder.getCreateOperId())));
    }

    private void qryInsp(Long orderId, Long inspOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocInspOrderQryBo qryBo = new UocInspOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setInspOrderId(inspOrderId);
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getInspOrderMain(qryBo);
        this.qrySale(orderId, uocInspOrderDo.getSaleOrderId(), rspBO, todoParamJson);
        rspBO.setObjCreateUserId(Long.valueOf(Long.parseLong(uocInspOrderDo.getCreateOperId())));
    }

    private void qryAudit(Long orderId, Long auditOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocAuditOrderQryBo qryBo = new UocAuditOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setAuditOrderId(auditOrderId);
        UocAuditOrderDo uocAuditOrderDo = this.iUocAuditOrderModel.qryAuditOrder(qryBo);
        todoParamJson.setAuditOrderCode(uocAuditOrderDo.getAuditOrderCode());
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(orderId);
        uocApprovalObjQryBo.setAuditOrderId(auditOrderId);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            throw new BaseBusinessException("102001", "\u5ba1\u6279\u5bf9\u8c61\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        todoParamJson.setObjBusiType(uocApprovalObjs.get(0).getObjBusiType());
        if (UocDicConstant.OBJ_TYPE.SALE.equals(uocApprovalObjs.get(0).getObjType())) {
            this.qrySale(orderId, Long.parseLong(uocApprovalObjs.get(0).getObjId()), rspBO, todoParamJson);
        }
        rspBO.setObjCreateUserId(Long.valueOf(Long.parseLong(uocAuditOrderDo.getCreateOperId())));
    }

    private void qryChng(Long orderId, Long chngOrderId, UocUnifyTodoQryRspBO rspBO, UocUnifyTodoQryBO todoParamJson) {
        UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
        qryBo.setOrderId(orderId);
        qryBo.setChngOrderId(chngOrderId);
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrder(qryBo);
        todoParamJson.setChngOrderNo(uocChngOrderDo.getChngOrderNo());
        todoParamJson.setChngBusiType(uocChngOrderDo.getBusiType());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(orderId);
        uocChngOrderObjQryBo.setChngOrderId(chngOrderId);
        List<UocChngOrderObj> listChngOrderObj = this.iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
        if (CollectionUtils.isEmpty(listChngOrderObj)) {
            throw new BaseBusinessException("102001", "\u53d8\u66f4\u5bf9\u8c61\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        this.qrySale(orderId, listChngOrderObj.get(0).getSaleOrderId(), rspBO, todoParamJson);
        rspBO.setObjCreateUserId(Long.valueOf(Long.parseLong(uocChngOrderDo.getCreateOperId())));
    }

    private UocUnifyTodoQryRspBO judge(UocUnifyTodoQryReqBO reqBO) {
        if (reqBO.getShareId() == null) {
            throw new BaseBusinessException("102001", "\u5165\u53c2shareId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getObjId() == null) {
            throw new BaseBusinessException("102001", "\u5165\u53c2objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getObjType() == null) {
            throw new BaseBusinessException("102001", "\u5165\u53c2objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new UocUnifyTodoQryRspBO();
    }
}

