/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderAndStopProcessService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceRspBO;
import com.tydic.dyc.oc.transactionservice.UocCancelSaleOrderAndStopProcessTransaction;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderAndStopProcessService"})
public class UocCancelSaleOrderAndStopProcessServiceImpl
implements UocCancelSaleOrderAndStopProcessService {
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocCancelSaleOrderAndStopProcessTransaction uocCancelSaleOrderAndStopProcessTransaction;

    @PostMapping(value={"cancelSaleOrderAndStopProcess"})
    public UocCancelSaleOrderAndStopProcessServiceRspBO cancelSaleOrderAndStopProcess(@RequestBody UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        UocCancelSaleOrderAndStopProcessServiceRspBO rspBO = this.uocCancelSaleOrderAndStopProcessTransaction.cancelSaleOrderAndStopProcess(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            this.syncEs(reqBO, rspBO);
        }
        return rspBO;
    }

    private void syncEs(UocCancelSaleOrderAndStopProcessServiceReqBO reqBo, UocCancelSaleOrderAndStopProcessServiceRspBO rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        orderBo.setOrderId(reqBo.getOrderId());
        orderBo.setObjId(reqBo.getSaleOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        if (ObjectUtil.isNotEmpty((Object)rspBo.getAuditOrderIdList())) {
            for (Long auditOrderId : rspBo.getAuditOrderIdList()) {
                SyncEsRunnableBo auditOrderBo = new SyncEsRunnableBo();
                auditOrderBo.setIndexName(this.uocIndexConfig.getApprovalOrderPlusIndex());
                auditOrderBo.setOrderId(reqBo.getOrderId());
                auditOrderBo.setObjId(auditOrderId);
                auditOrderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(auditOrderBo);
            }
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

    private void verifyParam(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

