/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.SapArrivalInspInfo;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderItemTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocInspOrderTemporarily;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapArrivalInspInfo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapInspResult;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapInspTask;
import com.tydic.dyc.oc.service.saleorder.UocDealSapInspInfoService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealSapInspInfoRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapInspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapInspResultBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSapInspTaskBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealSapInspInfoService"})
public class UocDealSapInspInfoServiceImpl
implements UocDealSapInspInfoService {
    private static final Logger log = LoggerFactory.getLogger(UocDealSapInspInfoServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private RedissonClient redissonClient;

    @PostMapping(value={"dealSapInspInfo"})
    public UocDealSapInspInfoRspBO dealSapInspInfo(@RequestBody UocDealSapInspInfoReqBO reqBO) {
        UocDealSapInspInfoRspBO rspBO = UocRu.success(UocDealSapInspInfoRspBO.class);
        List<String> sapOrderItemNoList = reqBO.getRows().stream().map(UocSapInspBO::getEbeln).collect(Collectors.toList());
        RLock lock = this.redissonClient.getLock((String)sapOrderItemNoList.get(0));
        log.info("\u83b7\u53d6\u9501:{}", sapOrderItemNoList.get(0));
        try {
            boolean b = lock.tryLock(3L, 3L, TimeUnit.SECONDS);
            log.info("\u83b7\u53d6\u9501\u7ed3\u679c:{}", (Object)b);
            if (b) {
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setSapOrderNoList(sapOrderItemNoList);
                List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                if (!CollectionUtils.isEmpty(saleOrderItemList)) {
                    Long orderId = saleOrderItemList.get(0).getOrderId();
                    UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
                    uocSaleOrderQryBo.setOrderId(orderId);
                    List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
                    if (CollectionUtils.isEmpty(saleOrderList)) {
                        throw new RuntimeException("\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    List collect = saleOrderList.stream().filter(saleOrderDo -> !"XS_SPLIT".equals(saleOrderDo.getSaleOrderState())).map(UocSaleOrderDo::getSaleOrderId).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(collect)) {
                        throw new RuntimeException("\u9500\u552e\u8ba2\u5355\u72b6\u6001\u4e0d\u6b63\u786e");
                    }
                    saleOrderItemList = saleOrderItemList.stream().filter(saleOrderItem -> collect.contains(saleOrderItem.getSaleOrderId())).collect(Collectors.toList());
                    Map saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSapOrderItemNo, Function.identity()));
                    for (UocSapInspBO bo : reqBO.getRows()) {
                        bo.setSynstatus("S");
                        bo.setSynstatus("\u6210\u529f");
                        UocSaleOrderItem saleOrderItem2 = (UocSaleOrderItem)((Object)saleOrderItemMap.get(bo.getEbelp()));
                        if (this.checkSapArrivalInsp(bo)) {
                            log.info("sap\u9a8c\u6536\u4fe1\u606f\u5df2\u5b58\u5728,\u4e0d\u518d\u5904\u7406");
                            continue;
                        }
                        UocSapArrivalInspInfo uocSapArrivalInspInfo = this.setSapArrivalInsp(bo, reqBO, saleOrderItem2);
                        this.iUocSaleOrderModel.insertSapArrivalInsp(uocSapArrivalInspInfo);
                        this.dealTempInsp(saleOrderItem2, uocSapArrivalInspInfo);
                    }
                    rspBO.setOrderId(saleOrderItemList.get(0).getOrderId());
                    rspBO.setSaleOrderId(saleOrderItemList.get(0).getSaleOrderId());
                    rspBO.setRows(reqBO.getRows());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (lock != null && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
        return rspBO;
    }

    private boolean checkSapArrivalInsp(UocSapInspBO bo) {
        UocSapArrivalInspInfo qryInsp = new UocSapArrivalInspInfo();
        qryInsp.setSapOrderNo(bo.getEbeln());
        qryInsp.setSapOrderItemNo(bo.getEbelp());
        qryInsp.setSapVoucherNo(bo.getMblnr());
        List<SapArrivalInspInfo> sapArrivalInspInfos = this.iUocSaleOrderModel.qrySapArrivalInspInfoList(qryInsp);
        return !CollectionUtils.isEmpty(sapArrivalInspInfos);
    }

    private void dealTempInsp(UocSaleOrderItem saleOrderItem, UocSapArrivalInspInfo uocSapArrivalInspInfo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(saleOrderItem.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(saleOrderItem.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (!"XS_DH_DH".equals(uocSaleOrderDo.getSaleOrderState())) {
            return;
        }
        UocInspOrderTemporarily qryInspTemp = new UocInspOrderTemporarily();
        qryInspTemp.setOrderId(saleOrderItem.getOrderId());
        qryInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
        List<UocInspOrderTemporarily> resultInspTemp = this.iUocSaleOrderModel.selectTempInspOrderList(qryInspTemp);
        Long inspOrderTempId = null;
        if (CollectionUtils.isEmpty(resultInspTemp)) {
            UocInspOrderTemporarily insertInspTemp = new UocInspOrderTemporarily();
            insertInspTemp.setTempInspOrderId(IdUtil.nextId());
            inspOrderTempId = insertInspTemp.getTempInspOrderId();
            insertInspTemp.setTempInspOrderNo("");
            insertInspTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspTemp.setOrderId(saleOrderItem.getOrderId());
            insertInspTemp.setStatus(UocConstant.TempInspOrderStatus.ERROR);
            insertInspTemp.setCreateTime(new Date());
            insertInspTemp.setRemark(uocSapArrivalInspInfo.getInspRemark());
            this.iUocSaleOrderModel.insertTempInspOrder(insertInspTemp);
        } else {
            inspOrderTempId = resultInspTemp.get(0).getTempInspOrderId();
        }
        UocInspOrderItemTemporarily qryInspItemTepm = new UocInspOrderItemTemporarily();
        qryInspItemTepm.setOrderId(saleOrderItem.getOrderId());
        qryInspItemTepm.setSaleOrderId(saleOrderItem.getSaleOrderId());
        qryInspItemTepm.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
        List<UocInspOrderItemTemporarily> resultInspItemTemp = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryInspItemTepm);
        if (CollectionUtils.isEmpty(resultInspItemTemp)) {
            UocInspOrderItemTemporarily insertInspItemTemp = new UocInspOrderItemTemporarily();
            insertInspItemTemp.setTempInspOrderItemId(IdUtil.nextId());
            insertInspItemTemp.setTempInspOrderId(inspOrderTempId);
            insertInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            insertInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            insertInspItemTemp.setOrderId(saleOrderItem.getOrderId());
            insertInspItemTemp.setSapOrderNo(saleOrderItem.getSapOrderNo());
            insertInspItemTemp.setSapOrderItemNo(saleOrderItem.getSapOrderItemNo());
            insertInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            insertInspItemTemp.setInspCount(uocSapArrivalInspInfo.getInspCount());
            insertInspItemTemp.setPlanConversionRate(saleOrderItem.getPlanConversionRate());
            insertInspItemTemp.setPlanInspCount(uocSapArrivalInspInfo.getPlanInspCount());
            insertInspItemTemp.setReturnCount(BigDecimal.ZERO);
            insertInspItemTemp.setStatus(1);
            insertInspItemTemp.setCreateTime(new Date());
            this.iUocSaleOrderModel.insertTempInspOrderItem(insertInspItemTemp);
        } else {
            UocInspOrderItemTemporarily updateInspItemTemp = new UocInspOrderItemTemporarily();
            updateInspItemTemp.setOrderId(saleOrderItem.getOrderId());
            updateInspItemTemp.setSaleOrderId(saleOrderItem.getSaleOrderId());
            updateInspItemTemp.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            updateInspItemTemp.setSendCount(saleOrderItem.getSendCount());
            updateInspItemTemp.setInspCount(resultInspItemTemp.get(0).getInspCount().add(uocSapArrivalInspInfo.getInspCount()));
            updateInspItemTemp.setPlanInspCount(resultInspItemTemp.get(0).getPlanInspCount().add(uocSapArrivalInspInfo.getPlanInspCount()));
            updateInspItemTemp.setUpdateTime(new Date());
            this.iUocSaleOrderModel.updateTempInspOrderItem(updateInspItemTemp);
        }
    }

    private UocSapArrivalInspInfo setSapArrivalInsp(UocSapInspBO bo, UocDealSapInspInfoReqBO reqBO, UocSaleOrderItem saleOrderItem) {
        UocSapArrivalInspInfo uocSapArrivalInspInfo = new UocSapArrivalInspInfo();
        uocSapArrivalInspInfo.setInspInfoId(IdUtil.nextId());
        uocSapArrivalInspInfo.setSapOrderNo(bo.getEbeln());
        uocSapArrivalInspInfo.setSapOrderItemNo(bo.getEbelp());
        uocSapArrivalInspInfo.setPlanInspCount(new BigDecimal(bo.getMenge().trim()));
        BigDecimal inspCount = uocSapArrivalInspInfo.getPlanInspCount().divide(saleOrderItem.getPlanConversionRate(), 3, RoundingMode.HALF_UP);
        uocSapArrivalInspInfo.setInspCount(inspCount);
        uocSapArrivalInspInfo.setInspOperName(bo.getUsnam_mkpf());
        uocSapArrivalInspInfo.setStatus(1);
        uocSapArrivalInspInfo.setSapVoucherNo(bo.getMblnr());
        uocSapArrivalInspInfo.setSapVoucherItemNo(bo.getZeile());
        uocSapArrivalInspInfo.setMaterialCode(bo.getMatnr());
        uocSapArrivalInspInfo.setInspTime(bo.getCpudt_mkfp());
        uocSapArrivalInspInfo.setInspRemark(bo.getXblnr_mkpf());
        uocSapArrivalInspInfo.setPlatformName(reqBO.getPlatformName());
        uocSapArrivalInspInfo.setPlatformNo(reqBO.getPlatformNo());
        uocSapArrivalInspInfo.setCreateTime(new Date());
        return uocSapArrivalInspInfo;
    }

    @PostMapping(value={"dealSapInspTask"})
    public List<UocSapInspTaskBO> dealSapInspTask(@RequestBody List<UocSapInspTaskBO> uocSapInspTaskBOS) {
        for (UocSapInspTaskBO uocSapInspTaskBO : uocSapInspTaskBOS) {
            UocSapInspTask uocSapInspTask = new UocSapInspTask();
            BeanUtils.copyProperties((Object)uocSapInspTaskBO, (Object)uocSapInspTask);
            uocSapInspTask.setId(IdUtil.nextId());
            uocSapInspTask.setCreatedDate(new Date());
            this.iUocSaleOrderModel.insertSapInspTask(uocSapInspTask);
            uocSapInspTaskBO.setSynresult("\u6210\u529f");
            uocSapInspTaskBO.setSynstatus("S");
        }
        return uocSapInspTaskBOS;
    }

    @PostMapping(value={"dealSapInspResult"})
    public List<UocSapInspResultBO> dealSapInspResult(@RequestBody List<UocSapInspResultBO> uocSapInspResultBOS) {
        for (UocSapInspResultBO uocSapInspResultBO : uocSapInspResultBOS) {
            UocSapInspResult uocSapInspResult = new UocSapInspResult();
            BeanUtils.copyProperties((Object)uocSapInspResultBO, (Object)uocSapInspResult);
            uocSapInspResult.setId(IdUtil.nextId());
            uocSapInspResult.setCreatedDate(new Date());
            this.iUocSaleOrderModel.insertSapInspResult(uocSapInspResult);
            uocSapInspResultBO.setSynresult("\u6210\u529f");
            uocSapInspResultBO.setSynstatus("S");
        }
        return uocSapInspResultBOS;
    }
}

