/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapOrderSendInfo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocBackSapOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class UocDealBackSapOrderTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocDealBackSapOrderTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    public UocDealBackSapOrderRspBO dealBackSapOrder(UocDealBackSapOrderReqBO reqBO) {
        UocDealBackSapOrderRspBO rspBO = UocRu.success(UocDealBackSapOrderRspBO.class);
        rspBO.setErrorFlag(Boolean.valueOf(false));
        if (UocConstant.SapPushType.TYPE_1.equals(reqBO.getPushType())) {
            this.doTypeOne(reqBO, rspBO);
        } else if (UocConstant.SapPushType.TYPE_2.equals(reqBO.getPushType())) {
            this.doTypeTwo(reqBO, rspBO);
        } else if (UocConstant.SapPushType.TYPE_3.equals(reqBO.getPushType())) {
            this.doTypeSth(reqBO, rspBO);
        }
        return rspBO;
    }

    private void doTypeSth(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        String failValue = null;
        Integer status = UocConstant.SapSendInfoStatus.STATUS_4;
        rspBO.setFlowFlag(Boolean.valueOf(true));
        String result = reqBO.getRESULT();
        if ("E".equals(result)) {
            failValue = reqBO.getDESC();
            status = UocConstant.SapSendInfoStatus.STATUS_3;
            rspBO.setFlowFlag(Boolean.valueOf(false));
            rspBO.setErrorFlag(Boolean.valueOf(true));
        }
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderNo(((UocBackSapOrderBO)reqBO.getRows().get(0)).getZddh());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        rspBO.setOrderId(saleOrderMain.getOrderId());
        rspBO.setSaleOrderId(saleOrderMain.getSaleOrderId());
        rspBO.setIsAgrIgnoreArrive(saleOrderMain.getIsAgrIgnoreArrive());
        rspBO.setOrderSource(saleOrderMain.getOrderSource());
        if (!("XS_QR_EDQR".equals(saleOrderMain.getSaleOrderState()) || "XS_XS_SAP".equals(saleOrderMain.getSaleOrderState()) || "XS_QR_PDQR".equals(saleOrderMain.getSaleOrderState()))) {
            rspBO.setErrorFlag(Boolean.valueOf(true));
            rspBO.setFlowFlag(Boolean.valueOf(false));
            for (UocBackSapOrderBO row : reqBO.getRows()) {
                row.setSynstatus("E");
                row.setSynresult("\u91cd\u590d\u63a8\u9001");
            }
            rspBO.setRows(reqBO.getRows());
            return;
        }
        String sapOrderNo = "";
        if (UocConstant.SapSendInfoStatus.STATUS_4.equals(status)) {
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(saleOrderMain.getOrderId());
            qryInst.setObjId(saleOrderMain.getSaleOrderId());
            qryInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
            rspBO.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBO.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            this.iUocCommonModel.dealTask(uocCommonDo);
            Map saleOrderItemMap = reqBO.getRows().stream().collect(Collectors.toMap(UocBackSapOrderBO::getZddi, Function.identity()));
            log.info("\u540c\u6b65sap\u8ba2\u5355\u7f16\u53f7\u548csap\u8ba2\u5355\u660e\u7ec6\u7f16\u53f7{}", (Object)JSON.toJSONString(saleOrderItemMap));
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderId(saleOrderMain.getSaleOrderId());
            uocSaleOrderItemQryBo.setOrderId(saleOrderMain.getOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
                UocBackSapOrderBO sapItem = (UocBackSapOrderBO)saleOrderItemMap.get(saleOrderItem.getSaleOrderItemIndex());
                log.info("\u9500\u552e\u5355\u5e8f\u53f7{}", (Object)JSON.toJSONString((Object)saleOrderItem.getSaleOrderItemIndex()));
                log.info("sap \u4fe1\u606f\u660e\u7ec6{}", (Object)JSON.toJSONString((Object)sapItem));
                UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
                updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
                updateSaleOrderItem.setSapOrderNo(sapItem.getEbeln());
                updateSaleOrderItem.setSapOrderItemNo(sapItem.getEbelp());
                this.iUocSaleOrderModel.modifyItemPlan(updateSaleOrderItem);
                String planItemNo = saleOrderItem.getPlanItemNo();
                sapItem.setBanfn(saleOrderItem.getPlanItemNo());
                String[] split = planItemNo.split("-");
                sapItem.setBnfpo(split[1]);
                sapItem.setSynresult("\u6210\u529f");
                sapItem.setSynstatus("S");
                sapOrderNo = updateSaleOrderItem.getSapOrderNo();
            }
            rspBO.setRows(reqBO.getRows());
        }
        UocSapOrderSendInfo qryUocSapOrderSendInfo = new UocSapOrderSendInfo();
        qryUocSapOrderSendInfo.setOrderId(saleOrderMain.getOrderId());
        qryUocSapOrderSendInfo.setSaleOrderId(saleOrderMain.getSaleOrderId());
        qryUocSapOrderSendInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_1);
        qryUocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
        List<UocSapOrderSendInfo> sapSendInfoList = this.iUocSaleOrderModel.getSapSendInfoList(qryUocSapOrderSendInfo);
        UocSapOrderSendInfo updateUocSapOrderSendInfo = new UocSapOrderSendInfo();
        updateUocSapOrderSendInfo.setSendInfoId(sapSendInfoList.get(0).getSendInfoId());
        updateUocSapOrderSendInfo.setOrderId(sapSendInfoList.get(0).getOrderId());
        updateUocSapOrderSendInfo.setSaleOrderId(sapSendInfoList.get(0).getSaleOrderId());
        updateUocSapOrderSendInfo.setStatus(status);
        updateUocSapOrderSendInfo.setSapRspParam(JSON.toJSONString((Object)reqBO.getRows()));
        updateUocSapOrderSendInfo.setReason(failValue);
        updateUocSapOrderSendInfo.setSapOrderNo(sapOrderNo);
        this.iUocSaleOrderModel.updateSapSendInfo(updateUocSapOrderSendInfo);
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderMain.getOrderSource()) && 1 == saleOrderMain.getIsAgrIgnoreArrive() && UocDicConstant.PURCHASE_MODE.PLAN.equals(saleOrderMain.getPurchaseMode())) {
            this.createShipOrder(saleOrderMain, rspBO);
            UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
            updateSaleOrderDo.setSaleOrderState("XS_DH_DH");
            updateSaleOrderDo.setOrderId(saleOrderMain.getOrderId());
            updateSaleOrderDo.setSaleOrderId(saleOrderMain.getSaleOrderId());
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        }
    }

    private void createShipOrder(UocSaleOrderDo saleOrderDo, UocDealBackSapOrderRspBO rspBO) {
        Long shipOrderId = IdUtil.nextId();
        UocShipOrderDo createShipOrderDo = new UocShipOrderDo();
        createShipOrderDo.setShipOrderState("FH_FH_YDH");
        createShipOrderDo.setShipOperId(saleOrderDo.getCreateOperId());
        createShipOrderDo.setOrderId(saleOrderDo.getOrderId());
        createShipOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        createShipOrderDo.setCreateOperId(saleOrderDo.getCreateOperId());
        createShipOrderDo.setCreateTime(new Date());
        createShipOrderDo.setShipOrderId(shipOrderId);
        createShipOrderDo.setShipOrderNo(this.getShipOrderNo());
        createShipOrderDo.setArriveTime(new Date());
        createShipOrderDo.setReceiverTime(new Date());
        createShipOrderDo.setShipTime(new Date());
        createShipOrderDo.setEstimateArrivalTime(new Date());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(saleOrderDo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(saleOrderDo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        updateSaleOrderDo.setSaleOrderItems(saleOrderItems);
        ArrayList<UocShipOrderItem> shipOrderItemBoList = new ArrayList<UocShipOrderItem>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setShipOrderId(shipOrderId);
            uocShipOrderItem.setOrderId(saleOrderDo.getOrderId());
            uocShipOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            uocShipOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            uocShipOrderItem.setUnitName(saleOrderItem.getUnitName());
            uocShipOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            uocShipOrderItem.setCreateTime(new Date());
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
            uocShipOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            uocShipOrderItem.setArriveCount(saleOrderItem.getPurchaseCount());
            shipOrderItemBoList.add(uocShipOrderItem);
            saleOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            saleOrderItem.setArriveCount(saleOrderItem.getPurchaseCount());
            this.iUocSaleOrderModel.modifySaleOrderItemAfterServingCount(saleOrderItem);
        }
        createShipOrderDo.setShipOrderItemBoList(shipOrderItemBoList);
        createShipOrderDo.setSupNo(saleOrderItems.get(0).getSupplierId());
        this.iUocShipOrderModel.createShipOrder(createShipOrderDo);
        this.iUocSaleOrderModel.modifyBatchItemSendCount(updateSaleOrderDo);
        rspBO.setShipOrderId(shipOrderId);
    }

    private String getShipOrderNo() {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(UocDicConstant.ORDER_SOURCE.AGR_GENERATE);
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        if (null != uocShipOrderDo) {
            return uocShipOrderDo.getShipOrderNo();
        }
        throw new BaseBusinessException("101002", "\u751f\u6210\u53d1\u8d27\u5355\u7f16\u53f7\u5931\u8d25");
    }

    private void doTypeTwo(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        UocSapOrderSendInfo updateInfo = new UocSapOrderSendInfo();
        updateInfo.setOrderId(reqBO.getOrderId());
        updateInfo.setSaleOrderId(reqBO.getSaleOrderId());
        updateInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_5);
        this.iUocSaleOrderModel.updateSapSendInfo(updateInfo);
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        rspBO.setOrderId(saleOrderDo.getOrderId());
        rspBO.setSaleOrderId(saleOrderDo.getSaleOrderId());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
        Long upperOrderId = saleOrderDo.getUpperOrderId();
        if (null == upperOrderId) {
            selectuocApprovalObjQryBo.setObjId(reqBO.getSaleOrderId().toString());
        } else {
            selectuocApprovalObjQryBo.setObjId(upperOrderId.toString());
        }
        selectuocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBO.getOrderId());
        qryInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
        qryInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        List<UocOrderTaskInst> auditOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_2);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(saleOrderDo.getCreateTime());
        uocSapOrderSendInfo.setUpdateTime(new Date());
        uocSapOrderSendInfo.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        uocSapOrderSendInfo.setSaleOrderName(saleOrderDo.getSaleOrderName());
        uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(auditOrderTaskInsts.get(0).getDealOperId()));
        uocSapOrderSendInfo.setPurchaseUserName(auditOrderTaskInsts.get(0).getDealOperName());
        uocSapOrderSendInfo.setPurchaseOrgId(Long.valueOf(saleOrderDo.getStakeholder().getPurOrgId()));
        uocSapOrderSendInfo.setPurchaseOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        uocSapOrderSendInfo.setPurUserName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setPurUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
        uocSapOrderSendInfo.setSupplierId(Long.valueOf(saleOrderDo.getStakeholder().getSupId()));
        uocSapOrderSendInfo.setSupplierName(saleOrderDo.getStakeholder().getSupName());
        uocSapOrderSendInfo.setPurCompanyId(saleOrderDo.getStakeholder().getPurCompanyId());
        uocSapOrderSendInfo.setPurCompanyName(saleOrderDo.getStakeholder().getPurCompanyName());
        uocSapOrderSendInfo.setCreateOrderName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setOrderSource(saleOrderDo.getOrderSource());
        uocSapOrderSendInfo.setSapOrderNo(saleOrderItemList.get(0).getSapOrderNo());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }

    private void doTypeOne(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        UocSapOrderSendInfo updateInfo = new UocSapOrderSendInfo();
        updateInfo.setOrderId(reqBO.getOrderId());
        updateInfo.setSaleOrderId(reqBO.getSaleOrderId());
        updateInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_5);
        this.iUocSaleOrderModel.updateSapSendInfo(updateInfo);
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        rspBO.setOrderId(saleOrderDo.getOrderId());
        rspBO.setSaleOrderId(saleOrderDo.getSaleOrderId());
        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
        selectuocApprovalObjQryBo.setObjId(reqBO.getSaleOrderId().toString());
        selectuocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBO.getOrderId());
        qryInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
        qryInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        List<UocOrderTaskInst> auditOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
            rspBO.setErrorFlag(Boolean.valueOf(true));
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(saleOrderDo.getCreateTime());
        uocSapOrderSendInfo.setUpdateTime(new Date());
        uocSapOrderSendInfo.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        uocSapOrderSendInfo.setOrderSource(saleOrderDo.getOrderSource());
        uocSapOrderSendInfo.setSaleOrderName(saleOrderDo.getSaleOrderName());
        uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(auditOrderTaskInsts.get(0).getDealOperId()));
        uocSapOrderSendInfo.setPurchaseUserName(auditOrderTaskInsts.get(0).getDealOperName());
        uocSapOrderSendInfo.setPurchaseOrgId(Long.valueOf(saleOrderDo.getStakeholder().getPurOrgId()));
        uocSapOrderSendInfo.setPurchaseOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        uocSapOrderSendInfo.setPurUserName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setPurUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
        uocSapOrderSendInfo.setSupplierId(Long.valueOf(saleOrderDo.getStakeholder().getSupId()));
        uocSapOrderSendInfo.setSupplierName(saleOrderDo.getStakeholder().getSupName());
        uocSapOrderSendInfo.setPurCompanyId(saleOrderDo.getStakeholder().getPurCompanyId());
        uocSapOrderSendInfo.setPurCompanyName(saleOrderDo.getStakeholder().getPurCompanyName());
        uocSapOrderSendInfo.setCreateOrderName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setOrderSource(saleOrderDo.getOrderSource());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }
}

