package com.tydic.dyc.oc.model.order.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 标题:UocOrderRel
 * 说明:订单外部关联领域对象
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderRel implements Serializable {
	private static final long serialVersionUID =  4437569806904269684L;

	//ID//
	private Long id;

	//订单ID//
	private Long orderId;

	//关联对象id//
	private Long objId;

	//关联对象类型 1.订单 2.销售单 3.执行单 4.发货单 5.收货单 6.售后服务单 7.支付单 99.其他//
	private Integer objType;

	//关联ID//
	private String relId;

	//关联类型 0普通开票 1上游开票 2服务费//
	private Integer relType;

	//关联类型 0普通开票 1上游开票 2服务费//
	private String relTypeStr;

	//关联状态 0未提交 1已提交 2挂起 //
	private Integer relStatus;

	//关联状态 0未提交 1已提交 2挂起 //
	private String relStatusStr;

	//订单来源系统//
	private String orderSystem;

	//删除标志1已删除//
	private Integer delTag;

	private Long saleOrderId;
}
