package com.tydic.dyc.oc.model.order.sub;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 描述：问题商品记录表
 **/
@Data
public class UocProblemSaleItem implements Serializable {
	private static final long serialVersionUID =  -121873444598644432L;

	/**
	 * 问题商品记录ID
	 */
	private Long problemSaleItemId;
	/**
	 * 销售明细ID
	 */
	private Long saleOrderItemId;
	/**
	 * 销售单ID
	 */
	private Long saleOrderId;
	/**
	 * 订单ID
	 */
	private Long orderId;
	/**
	 * 反馈单ID
	 */
	private String feedbackId;
	/**
	 * 问题类型  1.价格不合理 2.商品无前台销售记录 3.非供应商自营商品
	 */
	private Integer problemSaleItemType;
	/**
	 * 核查人ID
	 */
	private String checkUserId;
	/**
	 * 核查人名称
	 */
	private String checkName;
	/**
	 * 核查人联系电话
	 */
	private String checkMoblePhone;
	/**
	 * 价格异常商品标识 1.异常商品 0.未异常商品 2.已提交反馈单
	 */
	private Integer priceAbnormalFlag;
	/**
	 * 商品核查价
	 */
	private BigDecimal goodCheckPrice;
	/**
	 * 参考价格链接地址
	 */
	private String referPriceUrl;
	/**
	 * 问题描述
	 */
	private String problemDesc;
	/**
	 * 上传证据
	 */
	private String evidenceAccessory;
	/**
	 * 创建人ID
	 */
	private String createUserId;
	/**
	 * 创建人名称
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 更新人ID
	 */
	private String updateUserId;
	/**
	 * 更新人名称
	 */
	private String updateUserName;
	/**
	 * 更新时间
	 */
	private Date updateTime;
	private Date updateTimeStart;
	private Date updateTimeEnd;
	/**
	 * 排序
	 */
	private String orderBy;

}
