package com.tydic.dyc.oc.model.saleorder.qrybo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：UocSaleOrderItemForCpaQryListBo
 * 描述：商品管控商品列表查询BO
 */
@Data
public class UocSaleOrderItemForCpaQryListBo implements Serializable {

    private static final long serialVersionUID = -1443805504598519156L;

    /**
     * 订单编号
     */
    private String saleOrderNo;

    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 专区类型
     */
    private Integer areaType;

    /**
     * 订单状态
     */
    private String saleOrderState;

    /**
     * 订单金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 下单人
     */
    private String createOperName;

    /**
     * 下单时间
     */
    private Date createTime;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 采购方公司名称
     */
    private String purCompanyName;

    /**
     * 销售单明细ID
     */
    private Long saleOrderItemId;

    /**
     * 商品ID
     */
    private String skuId;

    /**
     * 商品编码
     */
    private String skuCode;

    /**
     * 商品69码
     */
    private String agreementNo;

    /**
     * 商品名称
     */
    private String skuName;

    /**
     * 店铺ID
     */
    private String supplierShopId;

    /**
     * 计量单位
     */
    private String unitName;

    /**
     * 商品主图url
     */
    private String skuMainPicUrl;

    /**
     * 商品类目
     */
    private String l3catalogName;

    /**
     * sku外部单品ID
     */
    private String skuExtSkuId;

    /**
     * 协议价
     */
    private BigDecimal salePrice;

    /**
     * 推送价
     */
    private BigDecimal otherDisFee;

    /**
     * 数量
     */
    private BigDecimal purchaseCount;

    /**
     * 商品金额
     */
    private BigDecimal saleFee;

    /**
     * 核查人名称
     */
    private String checkName;

    /**
     * 核查结果
     */
    private Integer checkFlag;

    /**
     * 商品核查价
     */
    private BigDecimal goodCheckPrice;

    /**
     * 罚款系数
     */
    private BigDecimal penaltyCoefficient;

    /**
     * 追加罚款
     */
    private BigDecimal penaltyFee;

    /**
     * 是否追加罚款
     */
    private Integer isPenaltyFlag;

    /**
     * 是否追加罚款说明
     */
    private String isPenaltyDesc;

    /**
     * 反馈单ID
     */
    private String feedbackId;

    /**
     * 审批时间
     */
    private Date approvalTime;

    /**
     * 分配人名称
     */
    private String allocationName;

    /**
     * 反馈单编号
     */
    private String feedbackNo;

    /**
     * 反馈单状态值
     */
    private String feedbackStateCode;

    /**
     * 反馈单状态名称
     */
    private String feedbackStateName;

    /**
     * 付款状态
     */
    private Integer payState;

    /**
     * 问题类型
     */
    private Integer problemSaleItemType;

    /**
     * 指导价
     */
    private String guidePrice;

    /**
     * 官网价
     */
    private String internetPrice;

    /**
     * 分配时间
     */
    private Date allocationTime;

    /**
     * 参考价格链接地址
     */
    private String referPriceUrl;

}
