package com.tydic.dyc.oc.repository;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListReqBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.*;

import java.math.BigDecimal;
import java.security.PrivateKey;
import java.util.List;
import java.util.PrimitiveIterator;


/**
 * 标题:UocSaleOrderRepository
 * 说明:销售订单
 * 时间:2022-02-21 14:26
 * 作者:罗有
 **/
public interface UocSaleOrderRepository {

    /**
     * 描述:创建销售单
     * @param saleOrderDo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tgy
     * @date 2022/2/24 18:31
     */
    UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo);

    /**
     * 描述:销售单主体查询
     * @param uocSaleOrderQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tgy
     * @date 2022/2/25 10:36
     */
    UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo);

    /**
     * 描述:查询销售单附件
     *
     * @param uocOrderAccessoryQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tkl
     * @date 2022/2/25 10:35
     */
    UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo);

    /**
     * 描述:查询销售单支付配置
     *
     * @param uocSaleOrderPayConfQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo);

    /**
     * 描述:销售单扩展查询
     * @param uocSaleOrderMapQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tgy
     * @date 2022/2/25 10:36
     */
    List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo);

    /**
     * 描述:销售单明细查询
     * @param uocSaleOrderItemQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem
     * @author tkl
     * @date 2022/2/25 10:36
     */
    List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);

    /**
     * 描述:根据销售单明细id集合查询销售单明细
     * @param itemIds 销售单明细id集合
     * @return 销售单明细
     */
    List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds);

    /**
     * 描述:销售单明细扩展查询
     * @param uocSaleItemMapQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap
     * @author tkl
     * @date 2022/2/25 10:36
     */
    List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo);

    /**
     * 销售明细查询
     * @param uocSaleOrderItemQryBo
     * @return
     */
    UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);

    /**
     * 查询销售单三方信息（多条）
     * @param qryBo
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder></>
     */
    List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo);

    /**
     * 查询销售单三方信息（单条）
     * @param qryBo
     * @return
     */
    UocSaleStakeholder getSaleOrderStakeholder(UocSaleStakeholderQryBo qryBo);
    /**
     * 销售单主体数据更新
     * @param uocSaleOrderDo
     */
    void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 描述:更新销售单状态，以及环节编码（如果有）
     * @param saleOrderDo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     * @author tgy
     * @date 2022/2/27 9:09
     */
    UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo saleOrderDo);


    /**
     * 描述:查询销售单列表
     * @param qryDo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo>
     * @author tgy
     * @date 2022/2/27 15:04
     */
    List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo);

    /**
     * 查询销售的主体
     *
     * @param uocSaleOrderDo
     * @return
     */
    UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 增加扩展字段
     *
     * @param uocSaleOrderDo
     */
    void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 更新扩展字段
     *
     * @param uocSaleOrderDo
     */
    void updateBatchValue(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 更新扩展字段
     *
     * @param uocSaleOrderDo
     */
    void updateInvalid(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 查询销售单总金额总数量
     * @author wenle
     * @date 2022-04-02 09:32:07
     * @param uocSaleOrderQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo);
    /**
         * 描述：更新销售单明细验收数量
         *
         * @author: daiyuanyuan
         * @date:   2022-04-02 15:54
         */
    void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo);



    /**
     * 查询销售单明细
     * @author wenle
     * @date 2022-04-02 14:18:30
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo qryBo);

    /**
     * 更新发货明细
     * @author wenle
     * @date 2022-04-02 14:41:19
     * @param convertSaleOrderDo 入参
     */
    void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo);

    void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo);

    /**
     * 查询明细各种数量汇总
     * @author wenle
     * @date 2022-04-02 15:16:05
     * @param uocSaleOrderItemQryBo 入参
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    UocSaleOrderDo getCollectCount(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);

    /**
     * 软删除
     * @param uocSaleOrderDo
     */
    void deleteSaleOrder(UocSaleOrderDo uocSaleOrderDo);
    /**
         * 描述：更新订单三方信息
         *
         * @author: daiyuanyuan
         * @date:   2022-04-06 14:08
         */
    void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo);

    void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem);

    void modifyBatchItemChngingCount(UocSaleOrderDo saleOrderDo);
    /**
     * 描述：修改销售单明细金额
     *
     * @author: daiyuanyuan
     * @date:   2022-04-06 14:08
     */
    void modifyBatchItemSalePrice(UocSaleOrderDo uocSaleOrderDo);
    /**
     * 描述：统计销售单明细销售金额
     *
     * @author: daiyuanyuan
     * @date:   2022-04-06 14:08
     */
    UocSaleOrderDo getSaleItemTotalPrice(UocSaleOrderDo uocSaleOrderDo);
    /**
     * 描述：更新销售单明细验收数量=到货数量
     *
     * @author: daiyuanyuan
     * @date:   2022-04-06 14:08
     */
    void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 描述：批量更新销售单明细验收数量=到货数量
     *
     * @author: daiyuanyuan
     * @date:   2022-04-06 14:08
     */
    void batchModifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo);

    void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo);

    void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo);

    void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem);
    /**
         * 描述：修改超验标识
         *
         * @author: daiyuanyuan
         * @date:   2022-04-11 16:22
         */
    void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo);

    void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo);

    void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo);

    int updateItem(UocSaleOrderDo uocSaleOrderDo);
    
    void updateItemArriveAccount(UocSaleOrderDo uocSaleOrderDo);

    /**
     * 描述：修改销售单明细金额
     *
     * @author: daiyuanyuan
     * @date:   2022-04-06 14:08
     */
    void modifyBatchItemPurchasePrice(UocSaleOrderDo uocSaleOrderDo);


    void modifyItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo);

    void modifyItemChngCountConfirm(UocSaleOrderDo convertSaleOrderDo);

    void modifyItemChngCountConfirmAdd(UocSaleOrderDo convertSaleOrderDo);

    void modifyItemChngCountConfirmReduce(UocSaleOrderDo convertSaleOrderDo);

    List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo);
    
    List<UocSaleOrderDo> getSaleOrders(UocSaleOrderQryBo uocSaleOrderQryBo);

    List<UocSaleOrderDo> cancelEsOrderList(UocSaleOrderDo convertSaleOrderDo);

    /**
     * 描述:查询销售单支付配置
     *
     * @param uocSaleOrderPayConf 入参
     * @author tkl
     * @date 2022/2/25 10:35
     */
    int updateSaleOrderPayConfMoney(UocSaleOrderPayConf uocSaleOrderPayConf);
    
    int qrySaleOrderCounts(UocSaleOrderDo uocSaleOrderDo);
    
    int insertCommityAfterTakeType(UocSaleGoodsAfterTakeTypeBo afterTakeTypeBo);
    
    List<UocSaleGoodsAfterTakeTypeBo> qryCommityTakeTypes(UocSaleGoodsAfterTakeTypeBo takeTypeBo);
    
    List<UocSaleOrderItemPlan> selectSaleOrderItemPlan(UocSaleOrderItemPlanBo record);

    List<UocSaleOrderDo> getSaleOrderListByBar(UocSaleOrderQryBo uocSaleOrderQryBo);

    void batchSyncSale();

    void modifyItemPlan(UocSaleOrderItem saleOrderItem);
    void modifyItemPlanNull(UocSaleOrderItem saleOrderItem);

    void insertSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo);

    void updateSapSendInfo(UocSapOrderSendInfo uocSapOrderSendInfo);

    List<UocSapOrderSendInfo> getSapSendInfoList(UocSapOrderSendInfo uocSapOrderSendInfo);

    BasePageRspBo<UocSapSendOrderLog> getSapSendInfoListPage(UocQrySapSendOrderLogReqBO uocQrySapSendOrderLogReqBO);

    int insertSapArrivalInspBatch(List<UocSapArrivalInspInfo> list);

    int insertSapArrivalInsp(UocSapArrivalInspInfo info);

    List<UocInspOrderTemporarily> selectTempInspOrderList(UocInspOrderTemporarily uocInspOrderTemporarily);

    BasePageRspBo<UocInspOrderTemporarily> selectTempInspOrderListPage(UocQryTempInspListReqBO uocQryTempInspListReqBO);

    void updateTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily);

    void insertTempInspOrder(UocInspOrderTemporarily uocInspOrderTemporarily);

    List<UocInspOrderItemTemporarily> selectTempInspOrderItemList(UocInspOrderItemTemporarily uocInspOrderItemTemporarily);

    void updateTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily);

    void insertTempInspOrderItem(UocInspOrderItemTemporarily uocInspOrderItemTemporarily);

    List<SapArrivalInspInfo> qrySapArrivalInspInfoList(UocSapArrivalInspInfo sapArrivalInspInfo);

    List<String> getMaterialBySkuId(UocSaleOrderQryBo uocSaleOrderQryBo);

    /**
     * 修改发票信息
     */
    void updateDealInvoiceInfo(UocSaleOrderDo uocSaleOrderDo);

    List<UocTransactionPrice> qryTransactionPrice(UocTransactionPrice reqBO);

    BasePageRspBo<UocGetSaleOrderItemsServiceRspItemBo> getSaleOrderItemListPage(UocSaleOrderItemQryBo uocSaleOrderItemQryBo);

    /**
     * 修改销售单支付信息
     */
    void updatePayOrderInfo(UocSaleOrderDo uocSaleOrderDo);

    void insertSapInspTask(UocSapInspTask uocSapInspTask);

    void insertSapInspResult(UocSapInspResult uocSapInspResult);
    List<UocAlertInfo> getUocAlertInfoList(UocAlertInfo uocAlertInfo);

    void insertUocAlertInfoBatch(List<UocAlertInfo> list);

    void updateUocAlertInfo(UocAlertInfo uocAlertInfo);

    List<UocSapInspTask> getSapTaskList(List<UocSapInspTask> uocSapInspTasks);

    List<UocSapInspResult> getSapResultList(List<UocSapInspResult> uocSapInspResults);
    List<UocOrderRel> getArchSaleOrderList(UocOrderRelQryBo uocOrderRelQryBo);

    void updateSaleOrderItem(UocSaleOrderItem uocSaleOrderItem);

    /**
     * 商品管控商品列表查询
     */
    UocSaleOrderItemForCpaQryListRspBo qryItemForCpaList(UocSaleOrderItemForCpaQryListReqBo reqBo);

    /**
     * 编辑商品管控核查任务
     */
    void dealCheckItemTimeTask(UocSaleOrderDo uocSaleOrderDo);
}
