package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderMapQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderWaybillQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderWaybill;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocGetAfOrderDetailServiceImpl
 * 说明:售后服务单详情查询
 * 时间:2022/2/25 10:29
 * 作者:田坤林
 */
@HTServiceImpl
@Slf4j
public class UocGetAfOrderDetailServiceImpl implements UocGetAfOrderDetailService {

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    private final static String TO_PAY_P_CODE = "TO_PAY";

    @Value("${uoc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;

    @Override
    public UocGetAfOrderDetailServiceRspBo qryAfOrderDetails(UocGetAfOrderDetailServiceReqBo reqBo) {
        UocGetAfOrderDetailServiceRspBo rspBo = UocRu.success(UocGetAfOrderDetailServiceRspBo.class);
        int source = UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT;
        //入参校验
        validateParam(reqBo);
        //查询售后服务单主体
        UocAfOrder uocAfOrder = getAfOrderMain(reqBo,null);
        String dataAchiveTabSuffix = null;
        if(dataAchiveFlag){
            if (Objects.isNull(uocAfOrder)) {
                dataAchiveTabSuffix = "_"+new SimpleDateFormat("yyyy").format((reqBo.getOrderId() >> 22) + 1420041600000L);
                uocAfOrder = getAfOrderMain(reqBo,dataAchiveTabSuffix);
            }
        }
        if (ObjectUtil.isNull(uocAfOrder)) {
            return rspBo;
        }
        //查询三方信息
        List<UocSaleStakeholder> stakeHolderList = getStakeHolderList(new UocSaleOrderItem(), reqBo, false, dataAchiveTabSuffix, uocAfOrder.getSaleOrderId());
        //查询售后服务单明细
        List<UocAfOrderItem> afOrderItemList = getAfOrderItemList(reqBo,dataAchiveTabSuffix);
        //查询运单信息
        List<UocAfOrderWaybill> afOrderWayBillList = getAfOrderWayBillList(reqBo,dataAchiveTabSuffix);
        //封装商品信息
        source = encapCommodityInfo(afOrderItemList, rspBo, reqBo, uocAfOrder,dataAchiveTabSuffix);
        //封装服务单信息
        encapServInfo(stakeHolderList, uocAfOrder, rspBo, reqBo, source,dataAchiveTabSuffix);
        //封装退款明细信息
        encapRefundInfo(stakeHolderList, uocAfOrder, reqBo, rspBo,dataAchiveTabSuffix);
        //封装运单信息
        encapShipInfo(rspBo, afOrderWayBillList);

        UocAfOrderMapQryBo qryAfMap = new UocAfOrderMapQryBo();
        qryAfMap.setOrderId(reqBo.getOrderId());
        qryAfMap.setAfOrderId(reqBo.getAfOrderId());
        qryAfMap.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocAfOrderMap> afOrderMapList = iUocAfOrderModel.getAfOrderMapList(qryAfMap);
        if (ObjectUtil.isNotEmpty(afOrderMapList)) {
            rspBo.setExtFields(new ArrayList<>());
            for (UocAfOrderMap uocAfOrderMap : afOrderMapList) {
                BaseExtendFieldBo extRspBo = JUtil.js(uocAfOrderMap, BaseExtendFieldBo.class);
                rspBo.getExtFields().add(extRspBo);
            }
        }

        return rspBo;
    }

    /**
     * 封装运单信息
     *
     * @param rspBo
     * @param afOrderWayBillList
     */
    private void encapShipInfo(UocGetAfOrderDetailServiceRspBo rspBo, List<UocAfOrderWaybill> afOrderWayBillList) {
        UocAfOrderShipInfoBo shipInfo = new UocAfOrderShipInfoBo();
        if (ObjectUtil.isNotEmpty(afOrderWayBillList)) {
            UocAfOrderWaybill waybill = afOrderWayBillList.get(0);
            shipInfo = UocRu.js(waybill, UocAfOrderShipInfoBo.class);
            shipInfo.setFreightMoney(new BigDecimal(waybill.getFreight()));
            UocSysDictionaryQryBo qryCodeBo = new UocSysDictionaryQryBo();
            qryCodeBo.setPCode(TO_PAY_P_CODE);
            qryCodeBo.setCode(shipInfo.getToPay().toString());
            //字典查询
            UocSysDictionaryDo dic = iUocSysDictionaryModel.getModelBy(qryCodeBo);
            shipInfo.setToPayStr(dic.getDescrip());
            //转换运费
//            if (null != waybill.getFreight()) {
//                try {
//                    shipInfo.setFreightMoney(MoneyUtils.Long2BigDecimal(waybill.getFreight()));
//                } catch (Exception e) {
//                    log.error("金额转换异常:{}", e.getMessage());
//                }
//            }
        }
        rspBo.setShipInfo(shipInfo);
    }

    /**
     * 查询运单信息
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderWaybill></>
     */
    private List<UocAfOrderWaybill> getAfOrderWayBillList(UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo = new UocAfOrderWaybillQryBo();
        uocAfOrderWaybillQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderWaybillQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocAfOrderModel.getAfOrderWayBillList(uocAfOrderWaybillQryBo);
    }

    /**
     * 封装退款明细信息
     *
     * @param stakeHolderList
     * @param reqBo
     * @param rspBo
     */
    private void encapRefundInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceReqBo reqBo, UocGetAfOrderDetailServiceRspBo rspBo, String dataAchiveTabSuffix) {
        UocAfOrderRefundDetailBo refundDetailBo = new UocAfOrderRefundDetailBo();
        //查询支付单信息
        List<UocPayOrder> listPayOrder = getUocPayOrderDoList(reqBo,dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            refundDetailBo = UocRu.js(listPayOrder.get(0), UocAfOrderRefundDetailBo.class);
            if (ObjectUtil.isNotEmpty(stakeHolderList)) {
                refundDetailBo.setPurAccount(stakeHolderList.get(0).getPurAccount());
                refundDetailBo.setPurAccountName(stakeHolderList.get(0).getPurAccountName());
            }
            rspBo.getServInfo().setIsPayFlag(true);
        }
        refundDetailBo.setRealReturnFee(uocAfOrder.getRealReturnFee());
        refundDetailBo.setPayFee(uocAfOrder.getRetTotalSaleFee());
        //退款信息翻译
        translateRefundInfo(refundDetailBo);
        rspBo.setRefundInfo(refundDetailBo);
    }

    /**
     * 退款信息翻译
     *
     * @param refundDetailBo
     */
    private void translateRefundInfo(UocAfOrderRefundDetailBo refundDetailBo) {
        if (null != refundDetailBo.getInterType()) {
            refundDetailBo.setInterTypeStr(getDic().get(UocDicConstant.ORDER_SOURCE.P_CODE).get(refundDetailBo.getInterType().toString()));
        }
        //退款状态翻译
        Optional.ofNullable(refundDetailBo.getPayState()).ifPresent(x -> refundDetailBo.setPayStateStr(getDic().get(UocDicConstant.PAY_AFTER_STATE.P_CODE).get(x)));
//        refundDetailBo.setPayStateStr(getDic().get(UocDicConstant.PAY_STATE.P_CODE).get(refundDetailBo.getPayState()));
        //支付方式翻译
        if (null != refundDetailBo.getPayType()) {
            refundDetailBo.setPayTypeStr(getDic().get(UocDicConstant.PAY_TYPE.P_CODE).get(refundDetailBo.getPayType().toString()));
        }
    }

    /**
     * 查询支付单信息
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.payorder.UocPayOrderDo></>
     */
    private List<UocPayOrder> getUocPayOrderDoList(UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        UocPayOrderQryBo uocPayOrderQryBo = new UocPayOrderQryBo();
        uocPayOrderQryBo.setOrderId(reqBo.getOrderId());
        uocPayOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocPayOrder> listPayOrder = iUocPayOrderModel.getListPayOrder(uocPayOrderQryBo);
        return listPayOrder;
    }

    /**
     * 封装服务单信息
     *
     * @param stakeHolderList
     * @param reqBo
     * @param uocAfOrder
     * @param rspBo
     * @param source
     */
    private void encapServInfo(List<UocSaleStakeholder> stakeHolderList, UocAfOrder uocAfOrder, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo, Integer source,String dataAchiveTabSuffix){
        UocAfOrderServiceInfoBo servInfoBo = UocRu.js(uocAfOrder, UocAfOrderServiceInfoBo.class);
        servInfoBo.setClientName(uocAfOrder.getExtField2());
        servInfoBo.setClientPhone(uocAfOrder.getExtField3());
        servInfoBo.setSubContactName(uocAfOrder.getSubContactName());
        servInfoBo.setSubContactMobile(uocAfOrder.getSubContactMobile());
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder stakeholder = stakeHolderList.get(0);
            servInfoBo.setSupplierId(stakeholder.getSupId());
            servInfoBo.setSupplierName(stakeholder.getSupName());
            servInfoBo.setPurName(stakeholder.getPurName());
            servInfoBo.setPurUserId(stakeholder.getPurUserId());
            servInfoBo.setPurOrgId(stakeholder.getPurOrgId());
        }
        //封装收获取件地址信息
        encapReceiverAddressInfo(uocAfOrder, servInfoBo,dataAchiveTabSuffix);
        //封装外部订单信息
        encapOutOrderInfo(uocAfOrder, servInfoBo, source,dataAchiveTabSuffix);
        //封装附件信息
        encapAccessoryInfo(reqBo, servInfoBo,dataAchiveTabSuffix);


        //封装环节任务信息
        buildTaskInfo(servInfoBo, uocAfOrder,dataAchiveTabSuffix);

        //查询销售单信息
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(uocAfOrder.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        uocSaleOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        servInfoBo.setSaleOrderId(saleOrderMainInfo.getSaleOrderId());
        servInfoBo.setSaleOrderNo(saleOrderMainInfo.getSaleOrderNo());
        // 外部订单编号
        servInfoBo.setOutOrderNo(saleOrderMainInfo.getSaleOrderNoExt());
        servInfoBo.setOrderCreateTime(saleOrderMainInfo.getCreateTime());
        servInfoBo.setOrderType(saleOrderMainInfo.getJdCz());

        //设置订单来源
        servInfoBo.setOrderSource(saleOrderMainInfo.getOrderSource());

        // 外部售后单ID
        servInfoBo.setAfsServiceId(uocAfOrder.getExtAfId());

        //服务单字段翻译
        translateServInfo(servInfoBo);

        rspBo.setServInfo(servInfoBo);
    }

    private void buildTaskInfo(UocAfOrderServiceInfoBo servInfoBo, UocAfOrder uocAfOrder, String dataAchiveTabSuffix) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(uocAfOrder.getOrderId());
        uocOrderTaskInst.setObjId(uocAfOrder.getAfOrderId());
        uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderTaskInst.setFinishTag(0);
        uocOrderTaskInst.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (CollectionUtil.isNotEmpty(uocOrderTaskInsts)) {
            UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
            servInfoBo.setTaskId(uocOrderTaskInst1.getTaskInstId());
            servInfoBo.setStepId(uocOrderTaskInst1.getProcState());
        }
    }

    /**
     * 封装外部订单信息
     *
     * @param uocAfOrder
     * @param servInfoBo
     * @param source
     */
    private void encapOutOrderInfo(UocAfOrder uocAfOrder, UocAfOrderServiceInfoBo servInfoBo, Integer source, String dataAchiveTabSuffix) {
        if (null != source && UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(source)) {
            List<UocOrderQueryIndex> orderQueryIndexList = getOrderQueryIndexList(uocAfOrder,dataAchiveTabSuffix);
            List<UocDMsgPoolQryBo> dMsgList = getDMsgList(uocAfOrder,dataAchiveTabSuffix);
            if (ObjectUtil.isNotEmpty(orderQueryIndexList)) {
                servInfoBo.setOutOrderId(orderQueryIndexList.get(0).getOutObjId());
            }
            if (ObjectUtil.isNotEmpty(dMsgList)) {
                servInfoBo.setOrderType(dMsgList.get(0).getOrderType());
            }
        }
    }

    /**
     * 服务单字段翻译
     *
     * @param servInfoBo
     */
    private void translateServInfo(UocAfOrderServiceInfoBo servInfoBo) {
        //服务单类型翻译
        if (null != servInfoBo.getServType()) {
            servInfoBo.setServTypeStr(getDic().get(UocDicConstant.SERVICE_TYPE.P_CODE).get(servInfoBo.getServType().toString()));
        }
        //服务单状态翻译
        if (null != servInfoBo.getServState()) {
            servInfoBo.setServStateStr(getDic().get(UocDicConstant.SERVICE_STATE.P_CODE).get(servInfoBo.getServState().toString()));
        }
        //付款方式翻译
        servInfoBo.setPayTypeStr(getDic().get(UocDicConstant.PAY_TYPE.P_CODE).get(servInfoBo.getPayType()));
        //售后原因翻译
        if (null != servInfoBo.getAfsReason()) {
            servInfoBo.setAfsReasonStr(getDic().get(UocDicConstant.AFS_REASON.P_CODE).get(servInfoBo.getAfsReason().toString()));
        }
        //订单类型翻译
        if (null != servInfoBo.getOrderType()) {
            servInfoBo.setOrderTypeStr(getDic().get(UocDicConstant.VENDOR_ORD_TYPE.P_CODE).get(servInfoBo.getOrderType().toString()));
        }
        //取货服务类型翻译
        if (null != servInfoBo.getPickwareType()) {
            servInfoBo.setPickwareTypeStr(getDic().get(UocDicConstant.PICKWARE_SERVE_TYPE.P_CODE).get(servInfoBo.getPickwareType().toString()));
        }
        //设置协议取货服务类型翻译
        if (ObjectUtil.isNotEmpty(servInfoBo.getPickwareType()) && UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(servInfoBo.getOrderSource())) {
            servInfoBo.setPickwareTypeStr(getDic().get(UocDicConstant.PICKWARE_SERVE_TYPE.AGR_P_CODE).get(servInfoBo.getPickwareType().toString()));
        }
    }

    /**
     * 封装附件信息
     *
     * @param reqBo
     * @param servInfoBo
     */
    private void encapAccessoryInfo(UocGetAfOrderDetailServiceReqBo reqBo, UocAfOrderServiceInfoBo servInfoBo,String dataAchiveTabSuffix) {
        //查询附件
        List<UocBaseOrderAccessoryTypeDetailBo> accessoryInfo = new ArrayList<>();
        UocOrderAccessoryQryBo qryBo = new UocOrderAccessoryQryBo();
        qryBo.setObjId(reqBo.getAfOrderId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(qryBo);
        if (ObjectUtil.isNotEmpty(orderAccessoryList)) {
            ConcurrentMap<Integer, List<UocOrderAccessory>> uocOrderAccessoryMap =
                    orderAccessoryList.stream().collect(Collectors.groupingByConcurrent(UocOrderAccessory::getAttachmentType));
            Iterator<Integer> iterator = uocOrderAccessoryMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer key = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(key);
                accessoryTypeDetailBo.setAttchList(UocRu.jsl(uocOrderAccessoryMap.get(key), UocBaseOrderAccessoryDetailBo.class));
                accessoryInfo.add(accessoryTypeDetailBo);
            }
        }
        servInfoBo.setAccessoryInfo(accessoryInfo);
    }

    /**
     * 封装收获地址信息
     *
     * @param uocAfOrder
     * @param servInfoBo
     */
    private void encapReceiverAddressInfo(UocAfOrder uocAfOrder, UocAfOrderServiceInfoBo servInfoBo, String dataAchiveTabSuffix) {
        //查询取件地址
        UocOrdLogisticsRelaQryBo qryBo = new UocOrdLogisticsRelaQryBo();
        qryBo.setOrderId(uocAfOrder.getOrderId());
        qryBo.setContactId(uocAfOrder.getTpContactId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(qryBo);
        if (ObjectUtil.isNotNull(uocOrdLogisticsRela)) {
            servInfoBo.setOrderTakeDeliveryInfo(UocRu.js(uocOrdLogisticsRela, UocAfOrderReceiverAddressBo.class));
        }

        //查询收获地址
        UocOrdLogisticsRelaQryBo qryBo1 = new UocOrdLogisticsRelaQryBo();
        qryBo1.setOrderId(uocAfOrder.getOrderId());
        qryBo1.setContactId(uocAfOrder.getContactId());
        qryBo1.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela getAddress = iUocOrderModel.qryOrderLogisticsRela(qryBo1);

        if (ObjectUtil.isNotNull(getAddress)) {
            servInfoBo.setOrderTakeReceiveInfo(UocRu.js(getAddress, UocAfOrderReceiverAddressBo.class));
        }

        //查询电商收货地址信息
        UocOrdLogisticsRelaQryBo qryBo2 = new UocOrdLogisticsRelaQryBo();
        qryBo2.setOrderId(uocAfOrder.getOrderId());
        qryBo2.setContactId(uocAfOrder.getJhContactId());
        qryBo2.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        UocOrdLogisticsRela getAddress2 = iUocOrderModel.qryOrderLogisticsRela(qryBo2);

        if (ObjectUtil.isNotNull(getAddress2)) {
            servInfoBo.setEsReceiveInfo(UocRu.js(getAddress2, UocAfOrderReceiverAddressBo.class));
        }

    }

    /**
     * 封装商品信息
     *
     * @param reqBo
     * @param afOrderItemList
     * @param rspBo
     */
    private Integer encapCommodityInfo(List<UocAfOrderItem> afOrderItemList, UocGetAfOrderDetailServiceRspBo rspBo, UocGetAfOrderDetailServiceReqBo reqBo, UocAfOrder uocAfOrder,String dataAchiveTabSuffix){
        List<UocAfOrderCommodityItemBo> commodityInfo = new ArrayList<>();

        //查询销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItem(uocAfOrder,dataAchiveTabSuffix);
        Map<Long, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSaleOrderItemId));

        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            for (int i = 0; i < afOrderItemList.size(); i++) {
                UocAfOrderItem each = afOrderItemList.get(i);
                BigDecimal returnCount = each.getReturnCount();

                UocAfOrderCommodityItemBo commodityItemBo = new UocAfOrderCommodityItemBo();
                //封装订单明细信息
//                encapOrderItemInfo(each, commodityItemBo);
                //封装售后单明细信息
                BeanUtils.copyProperties(each, commodityItemBo);
                //封装销售单明细信息
                encapSaleOrderItemInfo(each, commodityItemBo, reqBo, i,dataAchiveTabSuffix);
                //封装发货单明细信息
                encapShipOrderItemInfo(each, commodityItemBo,dataAchiveTabSuffix);

                //封装验收单明细信息
//                encapInspOrderItemInfo(each, commodityItemBo);
                //商品数据处理
                dealCommodityData(commodityItemBo);
                //商品信息字段翻译
                translateCommodityInfo(commodityItemBo);

                //明细计量单位
                List<UocSaleOrderItem> uocSaleOrderItems = saleOrderItemMap.get(each.getSaleItemId());
                UocSaleOrderItem saleOrderItem = uocSaleOrderItems.get(0);
                if (saleOrderItem != null) {
                    commodityItemBo.setUnitDigit(saleOrderItem.getUnitDigit());
                    commodityItemBo.setFigure(saleOrderItem.getFigure());
                }

                commodityItemBo.setReturnCount(returnCount);

                //封装退款金额
                this.packagingRefundFee(commodityItemBo, uocAfOrder);

                commodityInfo.add(commodityItemBo);
            }
            log.info("commodityInfo：" + JSON.toJSONString(commodityInfo));
        }
        rspBo.setCommodityInfo(commodityInfo);
        return reqBo.getOrderSource();
    }

    private void dealCommodityData(UocAfOrderCommodityItemBo commodityItemBo) {
        if (null != commodityItemBo.getSendCount() && null != commodityItemBo.getAfterServingCount() && null != commodityItemBo.getAlreadyReturnCount()) {
            commodityItemBo.setAvailableAfterServCount(
                    commodityItemBo.getSendCount().subtract(commodityItemBo.getAfterServingCount()).subtract(commodityItemBo.getAlreadyReturnCount()).abs());
        }
        if (null == commodityItemBo.getRetSaleFee()) {
            commodityItemBo.setRetSaleFee(BigDecimal.ZERO);
        }
        if (null == commodityItemBo.getRetPurchaseFee()) {
            commodityItemBo.setRetPurchaseFee(BigDecimal.ZERO);
        }
    }

    /**
     * 商品信息字段翻译
     *
     * @param commodityItemBo
     */
    private void translateCommodityInfo(UocAfOrderCommodityItemBo commodityItemBo) {
        //发货单状态翻译
        commodityItemBo.setShipOrderStateStr(getDic().get(UocStateConstants.ShipOrder.P_CODE).get(commodityItemBo.getShipOrderState()));
        //sku来源翻译
        if (null != commodityItemBo.getSkuSource()) {
            commodityItemBo.setSkuSourceStr(getDic().get(UocDicConstant.ORDER_SOURCE.P_CODE).get(commodityItemBo.getSkuSource().toString()));
        }
    }

    /**
     * 封装退款金额
     */
    private void packagingRefundFee(UocAfOrderCommodityItemBo uocAfOrderCommodityItemBo, UocAfOrder uocAfOrder) {
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(uocAfOrder.getServType())) {
            //设置退款金额
            uocAfOrderCommodityItemBo.setRefundFee(uocAfOrderCommodityItemBo.getRetSaleFee());
        }
    }

    /**
     * 封装验收单明细信息
     *
     * @param item
     * @param commodityItemBo
     */
    private void encapInspOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo,String dataAchiveTabSuffix) {
        List<UocInspOrderItem> inspOrderItemList = getInspOrderItemList(item,dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(inspOrderItemList)) {
            UocInspOrderItem uocInspOrderItem = inspOrderItemList.get(0);
            BeanUtils.copyProperties(uocInspOrderItem, commodityItemBo);
        } else {
            commodityItemBo.setAlreadyReturnCount(BigDecimal.ZERO);
        }
    }

    /**
     * 查询销售单明细
     */
    private List<UocSaleOrderItem> getSaleOrderItem(UocAfOrder afOrderMain, String dataAchiveTabSuffix) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(afOrderMain.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(afOrderMain.getOrderId());
        uocSaleOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }


    /**
     * 查询验收单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem></>
     */
    private List<UocInspOrderItem> getInspOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        //查询验收单明细
        UocInspOrderItemQryBo qryBo = new UocInspOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setInspOrderItemId(reqBo.getInspItemId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocInspOrderModel.getListInspOrderItem(qryBo).getUocInspOrderItemList();
    }

    /**
     * 查询外部消息池
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo></>
     */
    private List<UocDMsgPoolQryBo> getDMsgList(UocAfOrder reqBo, String dataAchiveTabSuffix) {
        UocDMsgPoolQryBo dMsgPoolQryBo = new UocDMsgPoolQryBo();
        dMsgPoolQryBo.setOrderId(reqBo.getOrderId());
        dMsgPoolQryBo.setObjId(reqBo.getAfOrderId());
        dMsgPoolQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        dMsgPoolQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocOrderModel.getMsgList(dMsgPoolQryBo);
    }

    private List<UocSaleItemMap> getSaleOrderItemMapList(UocAfOrder uocAfOrder, String dataAchiveTabSuffix) {
        UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
        uocSaleItemMapQryBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        uocSaleItemMapQryBo.setOrderId(uocAfOrder.getOrderId());
        uocSaleItemMapQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    /**
     * 查询外部关联信息
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex></>
     */
    private List<UocOrderQueryIndex> getOrderQueryIndexList(UocAfOrder reqBo, String dataAchiveTabSuffix) {
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjId(reqBo.getAfOrderId());
        queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        queryIndexQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
    }

    /**
     * 封装发货单明细信息
     *
     * @param item
     * @param commodityItemBo
     */
    private void encapShipOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, String dataAchiveTabSuffix) {
        //查询发货单明细
        List<UocShipOrderItem> shipOrderItemList = getShipOrderItemList(item,dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemList.get(0);
            BeanUtils.copyProperties(uocShipOrderItem, commodityItemBo);
            commodityItemBo.setAlreadyReturnCount(uocShipOrderItem.getReturnCount());
            //封装发货单主体信息
            UocShipOrderDo uocShipOrderDo = encapShipOrderMainInfo(commodityItemBo, uocShipOrderItem,dataAchiveTabSuffix);
            //配送单号
            commodityItemBo.setShipCompanyNo(uocShipOrderDo.getShipCompanyNo());

//            //若发货单状态为已到货时，可售后数量=本次发货数量-已退货数量-售后中数量
//            if (UocStateConstants.ShipOrder.FH_FH_YSH.equals(uocShipOrderDo.getShipOrderState())) {
//                if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
//                    BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
//                    commodityItemBo.setAvailableAfterServCount(afterCountEnable);
//                }
//            }
//            //若发货单状态为已验收时，可售后数量=实际验收数量-已退货数量-售后中数量
//            if (UocStateConstants.ShipOrder.FH_FH_YS.equals(uocShipOrderDo.getShipOrderState())) {
//                if (uocShipOrderItem.getInspCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
//                    BigDecimal afterCountEnable = uocShipOrderItem.getInspCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
//                    commodityItemBo.setAvailableAfterServCount(afterCountEnable);
//                }
//            }
            if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
                BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
                commodityItemBo.setAvailableAfterServCount(afterCountEnable);
            }
        }
    }

    /**
     * 封装发货单主体信息
     *
     * @param commodityItemBo
     * @param uocShipOrderItem
     */
    private UocShipOrderDo encapShipOrderMainInfo(UocAfOrderCommodityItemBo commodityItemBo, UocShipOrderItem uocShipOrderItem, String dataAchiveTabSuffix) {
        //查询发货单主体
        UocShipOrderDo shipOrderDo = getShipOrderDo(uocShipOrderItem,dataAchiveTabSuffix);
        if (ObjectUtil.isNotNull(shipOrderDo)) {
            BeanUtils.copyProperties(shipOrderDo, commodityItemBo);
        }
        return shipOrderDo;
    }

    /**
     * 封装销售单明细信息
     *
     * @param reqBo
     * @param item
     * @param commodityItemBo
     * @param index
     */
    private void encapSaleOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, UocGetAfOrderDetailServiceReqBo reqBo, int index,String dataAchiveTabSuffix) {
        //查询销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItemList(item,dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            UocSaleOrderItem saleOrderItem = saleOrderItemList.get(0);
            if (index == 0) {
                reqBo.setOrderSource(saleOrderItem.getSkuSource());
            }
            BeanUtils.copyProperties(saleOrderItem, commodityItemBo);
            //封装三方信息
            encapStakeHolderInfo(commodityItemBo, saleOrderItem, reqBo,dataAchiveTabSuffix);
        }
    }

    /**
     * 封装订单明细信息
     *
     * @param item
     * @param commodityItemBo
     */
    private void encapOrderItemInfo(UocAfOrderItem item, UocAfOrderCommodityItemBo commodityItemBo, String dataAchiveTabSuffix) {
        //查询订单明细信息
        List<UocOrderItem> orderItemList = getOrderItemList(item,dataAchiveTabSuffix);
        if (ObjectUtil.isNotEmpty(orderItemList)) {
            UocOrderItem uocOrderItem = orderItemList.get(0);
            BeanUtils.copyProperties(uocOrderItem, commodityItemBo);
        }
    }

    /**
     * 查询订单明细信息
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderItem></>
     */
    private List<UocOrderItem> getOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        UocOrderItemQryBo qryBo = new UocOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
//        qryBo.setOrderItemId(reqBo.getSaleItemId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocOrderModel.qryOrderItemList(qryBo);
    }

    /**
     * 封装三方信息
     *
     * @param reqBo
     * @param commodityItemBo
     * @param saleOrderItem
     */
    private void encapStakeHolderInfo(UocAfOrderCommodityItemBo commodityItemBo, UocSaleOrderItem saleOrderItem, UocGetAfOrderDetailServiceReqBo reqBo, String dataAchiveTabSuffix) {
        List<UocSaleStakeholder> stakeHolderList = getStakeHolderList(saleOrderItem, reqBo, true,dataAchiveTabSuffix, saleOrderItem.getSaleOrderId());
        if (ObjectUtil.isNotEmpty(stakeHolderList)) {
            UocSaleStakeholder uocSaleStakeholder = stakeHolderList.get(0);
            BeanUtils.copyProperties(uocSaleStakeholder, commodityItemBo);
        }
    }

    /**
     * 查询三方信息
     *
     * @param item
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder></>
     */
    private List<UocSaleStakeholder> getStakeHolderList(UocSaleOrderItem item, UocGetAfOrderDetailServiceReqBo reqBo, Boolean isSaleItem,String dataAchiveTabSuffix, Long saleOrderId) {
        //定义销售单查询参数
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        //设置销售单ID
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        //调用查询销售的主体
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);

        UocSaleStakeholderQryBo qryBo = new UocSaleStakeholderQryBo();
        if (isSaleItem) {
            qryBo.setOrderId(item.getOrderId());
        } else {
            qryBo.setOrderId(reqBo.getOrderId());
        }

        //设置三方信息ID
        qryBo.setStakeholderId(saleOrderMain.getStakeholderId());

        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocSaleOrderModel.qrySaleOrderStakeholder(qryBo);
    }

    /**
     * 查询发货单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.shiporder.UocShipOrderDo
     */
    private UocShipOrderDo getShipOrderDo(UocShipOrderItem reqBo, String dataAchiveTabSuffix) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        uocShipOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    /**
     * 查询发货单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem></>
     */
    private List<UocShipOrderItem> getShipOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(reqBo.getShipItemId());
        uocShipOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo).getShipOrderItemBoList();
    }


    /**
     * 查询销售订单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem></>
     */
    private List<UocSaleOrderItem> getSaleOrderItemList(UocAfOrderItem reqBo, String dataAchiveTabSuffix) {
        UocSaleOrderItemQryBo qryBo = new UocSaleOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderItemId(reqBo.getSaleItemId());
        qryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocSaleOrderModel.getSaleOrderItemList(qryBo);
    }

    /**
     * 查询售后服务单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.aforder.sub.UocAfOrder
     */
    private UocAfOrder getAfOrderMain(UocGetAfOrderDetailServiceReqBo reqBo,String dataAchiveTabSuffix) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    /**
     * 查询售后服务单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem></>
     */
    private List<UocAfOrderItem> getAfOrderItemList(UocGetAfOrderDetailServiceReqBo reqBo,String dataAchiveTabSuffix) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderItemQryBo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        return iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    private void validateParam(UocGetAfOrderDetailServiceReqBo reqBo) {
        if (ObjectUtil.isNull(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getAfOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后服务单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_STATE.P_CODE);
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.AFS_REASON.P_CODE);
        pCodes.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        pCodes.add(UocDicConstant.VENDOR_ORD_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PICKWARE_SERVE_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PICKWARE_SERVE_TYPE.AGR_P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}
