package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.domainservice.bo.UocTaskInfoListQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTaskInfoListQryServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTaskInfoListQryServiceRspTaskInfoBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocTaskInfoListQryServiceImpl
 * 说明:根据传入task_inst_id列表，查询任务实例列表
 * 时间:2023/11/2 9:44
 * 作者:田桂银
 */
@HTServiceImpl
public class UocTaskInfoListQryServiceImpl implements UocTaskInfoListQryService {


    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocTaskInfoListQryServiceRspBo qryTaskInfoList(UocTaskInfoListQryServiceReqBo reqBo) {
        validateArg(reqBo);
        UocOrderTaskInst qryTask = new UocOrderTaskInst();
        BeanUtils.copyProperties(reqBo, qryTask);
        qryTask.setTaskInstList(reqBo.getTaskInstList());
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocCommonModel.qryTaskInst(qryTask);
        UocTaskInfoListQryServiceRspBo rspBo = UocRu.success(UocTaskInfoListQryServiceRspBo.class);
        if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
            rspBo.setTaskInfoList(UocRu.jsl(uocOrderTaskInsts, UocTaskInfoListQryServiceRspTaskInfoBo.class));
        }
        return rspBo;
    }

    private void validateArg(UocTaskInfoListQryServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }

        if (ObjectUtil.isEmpty(reqBo.getTaskInstList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[taskInstList]不能为空");
        }
    }
}


