package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocCheckItemTimeTaskServiceImpl
 * 描述：编辑商品管控核查任务接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocCheckItemTimeTaskServiceImpl implements UocCheckItemTimeTaskService {

    /**
     * 销售单领域方法服务
     */
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    /**
     * 编辑商品管控核查任务
     */
    @Override
    public UocCheckItemTimeTaskRspBo dealCheckItemTimeTask(UocCheckItemTimeTaskReqBo reqBo) {
        //定义出参对象
        UocCheckItemTimeTaskRspBo rspBo = new UocCheckItemTimeTaskRspBo();

        //定义编辑商品管控核查任务参数
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        //设置销售单商品ID集合
        uocSaleOrderDo.setSaleOrderItemIdList(reqBo.getSaleOrderItemIdList());

        //调用销售单领域方法服务，编辑商品管控核查任务
        this.iUocSaleOrderModel.dealCheckItemTimeTask(uocSaleOrderDo);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        return rspBo;
    }

}
