package com.tydic.dyc.oc.service.saleorder;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.sub.UocProblemSaleItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocGoodsPriceAbnormalBackReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocGoodsPriceAbnormalBackRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @description 价格异常商品确认回调接口
 * @author Luokan
 * @date 2024/12/04
 **/
@HTServiceImpl
public class UocGoodsPriceAbnormalBackServiceImpl implements UocGoodsPriceAbnormalBackService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocGoodsPriceAbnormalBackRspBO dealGoodsPriceAbnormalBack(UocGoodsPriceAbnormalBackReqBO reqBO) {
        //入参校验
        validateParam(reqBO);
        UocGoodsPriceAbnormalBackRspBO rsp = new UocGoodsPriceAbnormalBackRspBO();
        //先查询问题商品记录表
        UocProblemSaleItem uocProblemSaleItem = new UocProblemSaleItem();
        uocProblemSaleItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocProblemSaleItem.setOrderId(reqBO.getOrderId());
        uocProblemSaleItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocProblemSaleItem.setFeedbackId(reqBO.getFeedbackId());
        UocProblemSaleItem result = this.iUocSaleOrderModel.qryProblemSaleItem(uocProblemSaleItem);
        if (null == result) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询问题商品记录表为空");
        }
        //更新问题商品记录表
        UocProblemSaleItem updateUocProblemSaleItem = new UocProblemSaleItem();
        updateUocProblemSaleItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        updateUocProblemSaleItem.setOrderId(reqBO.getOrderId());
        updateUocProblemSaleItem.setSaleOrderId(reqBO.getSaleOrderId());
        updateUocProblemSaleItem.setFeedbackId(reqBO.getFeedbackId());
        updateUocProblemSaleItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
        updateUocProblemSaleItem.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateUocProblemSaleItem(updateUocProblemSaleItem);
        //更新销售明细表
        //先查明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo nowSaleOrderItem = this.iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(nowSaleOrderItem.getSaleOrderItems()) || nowSaleOrderItem.getSaleOrderItems().size() != 1) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细信息为空");
        }
        UocSaleOrderItem nowSaleItem = nowSaleOrderItem.getSaleOrderItems().get(0);
        UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
        uocSaleOrderItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItem.setOrderId(reqBO.getOrderId());
        uocSaleOrderItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderItem.setFeedbackId(reqBO.getFeedbackId());
        uocSaleOrderItem.setProblemSaleItemId(result.getProblemSaleItemId());
        uocSaleOrderItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
        this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        //如果是确认为异常商品还要找出同款商品并且也更新为异常商品
        if (UocConstant.PriceAbnormalFlag.ERROR_GOODS.equals(reqBO.getPriceAbnormalFlag())) {
            Date date = result.getCreateTime(); // 获取当前时间（瞬时）
            ZoneId zoneId = ZoneId.systemDefault(); // 获取系统默认时区
            // 将 Date 转换为 Instant
            Instant instant = date.toInstant();
            // 将 Instant 和时区转换为 LocalDateTime
            LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
            System.out.println("Date: " + date);
            System.out.println("LocalDateTime: " + localDateTime);
            //下单开始时间
            Date createTimeStart = this.getPreviousWorkdayMidnight(localDateTime);
            Date createTimeEnd = this.getAfterdayMidnight();
            UocSaleOrderItemQryBo qryUocSaleOrderItem = new UocSaleOrderItemQryBo();
            qryUocSaleOrderItem.setCreateTimeStart(createTimeStart);
            qryUocSaleOrderItem.setCreateTimeEnd(createTimeEnd);
            qryUocSaleOrderItem.setSkuId(nowSaleItem.getSkuId());
            UocSaleOrderDo saleOrderItem = this.iUocSaleOrderModel.getListSaleOrderItem(qryUocSaleOrderItem);
            if (CollectionUtils.isEmpty(saleOrderItem.getSaleOrderItems())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细信息为空");
            }
            for (UocSaleOrderItem saleItem : saleOrderItem.getSaleOrderItems()) {
                //当前数据跳过
                if (saleItem.getSaleOrderItemId().equals(reqBO.getSaleOrderItemId())) {
                    continue;
                }
                //已经核查的数据跳过
                if (UocConstant.CheckFlag.PROBLEM_GOODS.equals(saleItem.getCheckFlag())) {
                    continue;
                }
                //未核查或者超时未核查的设置为问题商品
                if (UocConstant.CheckFlag.NO_CHECK.equals(saleItem.getCheckFlag()) || UocConstant.CheckFlag.TIME_OUT_CHECK.equals(saleItem.getCheckFlag())) {
                    //更新销售明细表
                    UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                    updateSaleOrderItem.setSaleOrderItemId(saleItem.getSaleOrderItemId());
                    updateSaleOrderItem.setOrderId(saleItem.getOrderId());
                    updateSaleOrderItem.setSaleOrderId(saleItem.getSaleOrderId());
                    updateSaleOrderItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
                    updateSaleOrderItem.setCheckFlag(UocConstant.CheckFlag.SAME_PROBLEM_GOODS);
                    updateSaleOrderItem.setGoodCheckPrice(nowSaleItem.getGoodCheckPrice());
                    updateSaleOrderItem.setPenaltyCoefficient(nowSaleItem.getPenaltyCoefficient());
                    updateSaleOrderItem.setPenaltyFee(nowSaleItem.getPenaltyFee());
                    this.iUocSaleOrderModel.updateSaleOrderItem(updateSaleOrderItem);
                }
                //未分配的数据设置为问题商品，
                if (null == saleItem.getAllocationFlag()) {
                    //更新销售明细表
                    UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                    updateSaleOrderItem.setSaleOrderItemId(saleItem.getSaleOrderItemId());
                    updateSaleOrderItem.setOrderId(saleItem.getOrderId());
                    updateSaleOrderItem.setSaleOrderId(saleItem.getSaleOrderId());
                    updateSaleOrderItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
                    updateSaleOrderItem.setAllocationFlag(UocConstant.AllocationFlag.SAME_PROBLEM_GOODS);
                    updateSaleOrderItem.setGoodCheckPrice(nowSaleItem.getGoodCheckPrice());
                    updateSaleOrderItem.setPenaltyCoefficient(nowSaleItem.getPenaltyCoefficient());
                    updateSaleOrderItem.setPenaltyFee(nowSaleItem.getPenaltyFee());
                    this.iUocSaleOrderModel.updateSaleOrderItem(updateSaleOrderItem);
                }
            }
        }
        return rsp;
    }

    private Date getAfterdayMidnight() {
        // 获取当前时间
        LocalDateTime now = LocalDateTime.now();
        // 转换为下一天的0点
        LocalDateTime nextDayMidnight = now.plusDays(1).with(LocalTime.MIDNIGHT);
        // 将LocalDateTime转换为ZonedDateTime（添加时区信息）
        ZonedDateTime zonedDateTime = nextDayMidnight.atZone(ZoneId.systemDefault());
        // 将ZonedDateTime转换为Date
        return Date.from(zonedDateTime.toInstant());
    }

    public Date getPreviousWorkdayMidnight(LocalDateTime dateTime) {
        LocalDate previousDate = dateTime.toLocalDate();

        // 不断向前寻找工作日
        //找到前一个工作日
        do {
            previousDate = previousDate.minusDays(1);
        } while (!this.isWeekend(previousDate));
        /*while (true) {
            previousDate = previousDate.minusDays(1);
            DayOfWeek dayOfWeek = previousDate.getDayOfWeek();
            if (dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY) {
                break;
            }
        }*/

        // 设置为0点
        LocalDateTime previousWorkdayMidnight = previousDate.atTime(LocalTime.MIDNIGHT);
        ZoneId zoneId = ZoneId.systemDefault(); // 获取系统默认时区
        // 将 LocalDateTime 转换为 ZonedDateTime（添加时区信息）
        ZonedDateTime zonedDateTime = previousWorkdayMidnight.atZone(zoneId);
        // 将 ZonedDateTime 转换为 Date
        Date date = Date.from(zonedDateTime.toInstant());
        System.out.println("previousWorkdayMidnight: " + previousWorkdayMidnight);
        System.out.println("Date: " + date);
        return date;
    }

    private boolean isWeekend(LocalDate previousDate) {
        return this.iUocSaleOrderModel.isWeekend(previousDate);
    }

    private void validateParam(UocGoodsPriceAbnormalBackReqBO reqBO) {
        if (null == reqBO.getSaleOrderItemId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "价格异常商品确认回调接口入参【saleOrderItemId】不能为空");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "价格异常商品确认回调接口入参【saleOrderId】不能为空");
        }
        if (null == reqBO.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "价格异常商品确认回调接口入参【orderId】不能为空");
        }
        if (StringUtils.isBlank(reqBO.getFeedbackId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "价格异常商品确认回调接口入参【feedbackId】不能为空");
        }
        if (null == reqBO.getPriceAbnormalFlag()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "价格异常商品确认回调接口入参【priceAbnormalFlag】不能为空");
        }
    }
}
