package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocPenaltyFeeReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocPenaltyFeeRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * @description 追加罚款接口
 * @author Luokan
 * @date 2024/12/04
 **/
@HTServiceImpl
public class UocPenaltyFeeServiceImpl implements UocPenaltyFeeService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocPenaltyFeeRspBO dealPenaltyFee(UocPenaltyFeeReqBO reqBO) {
        UocPenaltyFeeRspBO rsp = new UocPenaltyFeeRspBO();
        for (Long saleOrderItemId : reqBO.getSaleOrderItemIds()) {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(saleOrderItemId);
            uocSaleOrderItem.setIsPenaltyFlag(reqBO.getIsPenaltyFlag());
            uocSaleOrderItem.setIsPenaltyDesc(reqBO.getIsPenaltyDesc());
            this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        }
        return rsp;
    }
}
