package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocInspOrderItemTemporarilyBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocInspOrderTemporarilyBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQryTempInspListRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @description sap零时验收信息查询接口
 * @author Luokan
 * @date 2024/07/08
 **/
@HTServiceImpl
public class UocQryTempInspListServiceImpl implements UocQryTempInspListService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQryTempInspListRspBO qryTempInspList(UocQryTempInspListReqBO reqBO) {
        UocQryTempInspListRspBO rspBO = UocRu.success(UocQryTempInspListRspBO.class);
        BasePageRspBo<UocInspOrderTemporarily> result = this.iUocSaleOrderModel.selectTempInspOrderListPage(reqBO);
        //获取销售单信息
        UocSaleOrderDo saleOrder = getSaleOrder(reqBO);

        UocSaleStakeholder uocSaleStakeholder = saleOrder.getStakeholder();
        rspBO.setRows(UocRu.jsl(result.getRows(), UocInspOrderTemporarilyBO.class));
        if (!CollectionUtils.isEmpty(rspBO.getRows())) {
            UocInspOrderTemporarilyBO uocInspOrderTemporarilyBO = rspBO.getRows().get(0);
            uocInspOrderTemporarilyBO.setSaleOrderNo(saleOrder.getSaleOrderNo());
            if (null != uocSaleStakeholder) {
                uocInspOrderTemporarilyBO.setSupplierId(uocSaleStakeholder.getSupId());
                uocInspOrderTemporarilyBO.setSupplierNo(uocSaleStakeholder.getSupNo());
                uocInspOrderTemporarilyBO.setSupplierName(uocSaleStakeholder.getSupName());
            }
            //补全验收明细
            UocInspOrderItemTemporarily qryTempItem = new UocInspOrderItemTemporarily();
            qryTempItem.setTempInspOrderIds(rspBO.getRows().stream().map(UocInspOrderTemporarilyBO::getTempInspOrderId).collect(Collectors.toList()));
            List<UocInspOrderItemTemporarily> resultTempItemList = this.iUocSaleOrderModel.selectTempInspOrderItemList(qryTempItem);
            //查询销售明细，补全税率，含税单价，销售单位
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderItemIdList(resultTempItemList.stream().map(UocInspOrderItemTemporarily::getSaleOrderItemId).collect(Collectors.toList()));
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, Function.identity()));
            Map<Long, List<UocInspOrderItemTemporarily>> tempItemMap = resultTempItemList.stream().collect(Collectors.groupingBy(UocInspOrderItemTemporarily::getTempInspOrderId));
            for (UocInspOrderTemporarilyBO bo : rspBO.getRows()) {
                bo.setIsMatOrder(saleOrder.getIsMatOrder());
                bo.setInspOrderItemTemporarilyBOList(UocRu.jsl(tempItemMap.get(bo.getTempInspOrderId()), UocInspOrderItemTemporarilyBO.class));
                for (UocInspOrderItemTemporarilyBO inspItemTemp : bo.getInspOrderItemTemporarilyBOList()) {
                    UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(inspItemTemp.getSaleOrderItemId());
                    inspItemTemp.setTax(saleOrderItem.getTax());
                    inspItemTemp.setSalePrice(saleOrderItem.getSalePrice());
                    inspItemTemp.setUnitName(saleOrderItem.getUnitName());
                    inspItemTemp.setCommodityName(saleOrderItem.getCommodityName());
                    inspItemTemp.setSkuName(saleOrderItem.getSkuName());
                    inspItemTemp.setSkuId(saleOrderItem.getSkuId());
                    inspItemTemp.setSkuCode(saleOrderItem.getSkuCode());
                    inspItemTemp.setPurchaseCount(saleOrderItem.getPurchaseCount());
                    inspItemTemp.setSkuExtSkuId(saleOrderItem.getSkuExtSkuId());
                    inspItemTemp.setMaterialTypeId(saleOrderItem.getSkuMaterialTypeId());
                    inspItemTemp.setSkuMainPic(saleOrderItem.getSkuMainPicUrl());
                    inspItemTemp.setMaterialTypeName(saleOrderItem.getSkuMaterialTypeName());
                    inspItemTemp.setMaterialCode(saleOrderItem.getSkuMaterialCode());
                    inspItemTemp.setMaterialName(saleOrderItem.getSkuMaterialName());
                    inspItemTemp.setPlanConversionRate(saleOrderItem.getPlanConversionRate());
                    inspItemTemp.setAgrItemActiveTime(saleOrderItem.getAgrItemActiveTime());
                    inspItemTemp.setAgrItemCreateTime(saleOrderItem.getAgrItemCreateTime());
                    inspItemTemp.setAgrItemNoTaxPrice(saleOrderItem.getAgrItemNoTaxPrice());
                    inspItemTemp.setPlanItemNo(saleOrderItem.getPlanItemNo());
                    inspItemTemp.setSupplierId(saleOrderItem.getSupplierId());
                    inspItemTemp.setSupplierShopId(saleOrderItem.getSupplierShopId());
                    inspItemTemp.setFigure(saleOrderItem.getFigure());
                }
            }
            //获取sap收货消息
            List<SapArrivalInspInfo> sapArrivalInspInfoList = getSapArrivalInspInfoList(resultTempItemList.get(0).getSapOrderNo());
            //根据创建时间倒序排列
            if (!sapArrivalInspInfoList.isEmpty()){
                sapArrivalInspInfoList.sort((o1, o2) -> o2.getCreateTime().compareTo(o1.getCreateTime()));
                SapArrivalInspInfo sapArrivalInspInfo = sapArrivalInspInfoList.get(0);
                uocInspOrderTemporarilyBO.setAcceptUserName(sapArrivalInspInfo.getInspOperName());
                String inspTime = sapArrivalInspInfo.getInspTime();
                //转为日期格式 yyyy-MM-dd HH:mm:ss
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                try {
                    uocInspOrderTemporarilyBO.setAcceptTime(sdf.parse(inspTime));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        rspBO.setPageNo(result.getPageNo());
        rspBO.setTotal(result.getTotal());
        rspBO.setRecordsTotal(result.getRecordsTotal());
        return rspBO;
    }



    /**
     * 查询销售单主体
     */
    private UocSaleOrderDo getSaleOrder(UocQryTempInspListReqBO reqBO) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    /**
     * 查询收货主体
     */
    private List<SapArrivalInspInfo> getSapArrivalInspInfoList(String SapOrderNo) {
        UocSapArrivalInspInfo uocSapArrivalInspInfo = new UocSapArrivalInspInfo();
        uocSapArrivalInspInfo.setSapOrderNo(SapOrderNo);
        return iUocSaleOrderModel.qrySapArrivalInspInfoList(uocSapArrivalInspInfo);
    }
}
