package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemForCpaQryListReqBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemForCpaQryListRspBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemForCpaListQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemForCpaListQryReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderItemForCpaListQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：UocSaleOrderItemForCpaServiceImpl
 * 描述：商品管控商品列表查询接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocSaleOrderItemForCpaServiceImpl implements UocSaleOrderItemForCpaService {

    /**
     * 销售单领域方法服务
     */
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    /**
     * 字典领域方法服务
     */
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    /**
     * 商品管控商品列表查询
     */
    @Override
    public UocSaleOrderItemForCpaListQryRspBo qryItemForCpaList(UocSaleOrderItemForCpaListQryReqBo reqBo) {
        //入参转换
        UocSaleOrderItemForCpaQryListReqBo uocSaleOrderItemForCpaQryListReqBo = UocRu.js(reqBo, UocSaleOrderItemForCpaQryListReqBo.class);

        //调用销售单领域方法服务，商品管控商品列表查询
        UocSaleOrderItemForCpaQryListRspBo uocSaleOrderItemForCpaQryListRspBo = this.iUocSaleOrderModel.qryItemForCpaList(uocSaleOrderItemForCpaQryListReqBo);

        //出参转换
        UocSaleOrderItemForCpaListQryRspBo rspBo = UocRu.js(uocSaleOrderItemForCpaQryListRspBo, UocSaleOrderItemForCpaListQryRspBo.class);

        //数据转义
        this.qryItemForCpaListDataTranslation(rspBo);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        return rspBo;
    }

    /**
     * 数据转义
     */
    private void qryItemForCpaListDataTranslation(UocSaleOrderItemForCpaListQryRspBo rspBo) {
        //判断订单快照列表为空，直接返回
        if (CollectionUtils.isEmpty(rspBo.getRows())) {
            return;
        }

        //定义字典列表查询入参，字典编码集合
        List<String> pCodeList = new ArrayList<>(1);
        //设置专区类型字典编码
        pCodeList.add(UocDicConstant.COMMODITY_CONTROL.AREA_TYPE);
        //设置核查结果字典编码
        pCodeList.add(UocDicConstant.COMMODITY_CONTROL.CHECK_FLAG);
        //设置是否追加罚款字典编码
        pCodeList.add(UocDicConstant.COMMODITY_CONTROL.IS_PENALTY_FLAG);
        //设置销售单状态字典编码
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        //设置付款状态字典编码
        pCodeList.add(UocDicConstant.COMMODITY_CONTROL.PAY_STATE);
        //设置问题类型字典编码
        pCodeList.add(UocDicConstant.COMMODITY_CONTROL.PROBLEM_SALE_ITEM_TYPE);

        //调用字典领域方法服务，查询字典列表
        Map<String, Map<String, String>> uocSysDictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);

        //获取专区类型字典Map
        Map<String, String> areaTypeDictionaryMap = uocSysDictionaryMap.get(UocDicConstant.COMMODITY_CONTROL.AREA_TYPE);
        //获取核查结果字典Map
        Map<String, String> checkFlagDictionaryMap = uocSysDictionaryMap.get(UocDicConstant.COMMODITY_CONTROL.CHECK_FLAG);
        //获取是否追加罚款字典Map
        Map<String, String> isPenaltyFlagDictionaryMap = uocSysDictionaryMap.get(UocDicConstant.COMMODITY_CONTROL.IS_PENALTY_FLAG);
        //获取销售单状态字典Map
        Map<String, String> saleOrdStateDictionaryMap = uocSysDictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
        //获取付款状态字典Map
        Map<String, String> payStateDictionaryMap = uocSysDictionaryMap.get(UocDicConstant.COMMODITY_CONTROL.PAY_STATE);
        //获取问题类型字典Map
        Map<String, String> problemSaleItemTypeDictionaryMap = uocSysDictionaryMap.get(UocDicConstant.COMMODITY_CONTROL.PROBLEM_SALE_ITEM_TYPE);

        //遍历订单快照列表，封装数据
        for (UocSaleOrderItemForCpaListQryBo row : rspBo.getRows()) {
            if (ObjectUtil.isNotEmpty(row.getAreaType())) {
                //设置专区类型转义
                row.setAreaTypeStr(areaTypeDictionaryMap.get(String.valueOf(row.getAreaType())));
            }
            if (ObjectUtil.isNotEmpty(row.getCheckFlag())) {
                //设置核查结果转义
                row.setCheckFlagStr(checkFlagDictionaryMap.get(String.valueOf(row.getCheckFlag())));
            }
            if (ObjectUtil.isNotEmpty(row.getIsPenaltyFlag())) {
                //设置是否追加罚款转义
                row.setIsPenaltyFlagStr(isPenaltyFlagDictionaryMap.get(String.valueOf(row.getIsPenaltyFlag())));
            }
            if (ObjectUtil.isNotEmpty(row.getSaleOrderState())) {
                //设置销售单状态转义
                row.setSaleOrderStateStr(saleOrdStateDictionaryMap.get(String.valueOf(row.getSaleOrderState())));
            }
            if (ObjectUtil.isNotEmpty(row.getPayState())) {
                //设置付款状态转义
                row.setPayStateStr(payStateDictionaryMap.get(String.valueOf(row.getPayState())));
            }
            if (ObjectUtil.isNotEmpty(row.getProblemSaleItemType())) {
                //设置问题类型转义
                row.setProblemSaleItemTypeStr(problemSaleItemTypeDictionaryMap.get(String.valueOf(row.getProblemSaleItemType())));
            }
        }
    }

}
