package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRelateContractServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRelateContractServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述: 〈领域服务-销售单关联合同ID服务 实现〉
 * @author : 王钟游
 * @date : 2022-09-08 11:20
 */
@HTServiceImpl
public class UocSaleOrderRelateContractServiceImpl implements UocSaleOrderRelateContractService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocSaleOrderRelateContractServiceRspBo relateContract(UocSaleOrderRelateContractServiceReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (saleOrderMain == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"未根据单据id查找到销售单信息");
        }
        if (!UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(saleOrderMain.getOrderSource())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单类型错误，只能关联到无协议订单");
        }
        if (StringUtils.isNotBlank(saleOrderMain.getContractNo())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "操作失败，该订单已关联到一个合同");
        }
        saleOrderMain.setContractNo(reqBo.getContractId());
        iUocSaleOrderModel.modifySaleOrderMain(saleOrderMain);

        UocSaleOrderRelateContractServiceRspBo rspBo = new UocSaleOrderRelateContractServiceRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    private void verifyParam(UocSaleOrderRelateContractServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == (reqBo.getOrderId()) || 0L == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[orderId]属性不能为空");
        }
        if (null == (reqBo.getSaleOrderId()) || 0L == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[saleVoucherId]属性不能为空");
        }
        if (StringUtils.isBlank(reqBo.getContractId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[contractId]属性不能为空");
        }
    }

}
