package com.tydic.dyc.oc.service.snaporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.snaporder.IUocSnapOrderModel;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderItemSameQryListReqBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderItemSameQryListRspBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.snaporder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：UocSnapshotOrderItemSameListQryServiceImpl
 * 描述：订单快照同款商品列表分页查询接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocSnapshotOrderItemSameListQryServiceImpl implements UocSnapshotOrderItemSameListQryService {

    /**
     * 快照订单领域方法服务
     */
    @Autowired
    private IUocSnapOrderModel iUocSnapOrderModel;

    /**
     * 字典领域方法服务
     */
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    /**
     * 订单快照同款商品列表分页查询
     */
    @Override
    public UocSnapshotOrderItemSameListQryRspBo qryUocSnapshotOrderItemSameList(UocSnapshotOrderItemSameListQryReqBo reqBo) {
        //入参转换
        UocSnapshotOrderItemSameQryListReqBo uocSnapshotOrderItemSameQryListReqBo = UocRu.js(reqBo, UocSnapshotOrderItemSameQryListReqBo.class);

        //调用快照订单领域方法服务，订单快照同款商品列表分页查询
        UocSnapshotOrderItemSameQryListRspBo uocSnapshotOrderItemSameQryListRspBo = this.iUocSnapOrderModel.qryUocSnapshotOrderItemSameList(uocSnapshotOrderItemSameQryListReqBo);

        //出参转换
        UocSnapshotOrderItemSameListQryRspBo rspBo = UocRu.js(uocSnapshotOrderItemSameQryListRspBo, UocSnapshotOrderItemSameListQryRspBo.class);

        //数据转义
        this.qryUocSnapOrderItemSameListDataTranslation(rspBo);

        //出参
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        return rspBo;
    }

    /**
     * 数据转义
     */
    private void qryUocSnapOrderItemSameListDataTranslation(UocSnapshotOrderItemSameListQryRspBo rspBo) {
        //判断订单快照同款商品列表为空，直接返回
        if (CollectionUtils.isEmpty(rspBo.getRows())) {
            return;
        }

        //定义字典列表查询入参，字典编码集合
        List<String> pCodeList = new ArrayList<>(1);
        //设置是否低价字典编码
        pCodeList.add(UocConstant.SNAP_ORDER_DICTIONARY_P_CODE.IS_LOW_PRICE);
        //调用字典领域方法服务，查询字典列表
        Map<String, Map<String, String>> uocSysDictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);

        //获取是否同款最低价字典Map
        Map<String, String> isLowPriceDictionaryMap = uocSysDictionaryMap.get(UocConstant.SNAP_ORDER_DICTIONARY_P_CODE.IS_LOW_PRICE);

        //遍历订单快照同款商品列表，封装数据
        for (UocSnapshotOrderItemSameListQryBo row : rspBo.getRows()) {
            if (ObjectUtil.isNotEmpty(row.getIsLowPrice())) {
                //设置是否低价转义
                row.setIsLowPriceStr(isLowPriceDictionaryMap.get(String.valueOf(row.getIsLowPrice())));
            }
        }
    }
}
