package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealUploadInvoiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealUploadInvoiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * 标题：UocDealUploadInvoiceTransaction
 * 说明：上传发票处理
 */
@Slf4j
@Component
public class UocDealUploadInvoiceTransaction {

    /**
     * 销售单模型层
     */
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocDealUploadInvoiceRspBo dealUploadInvoice(UocDealUploadInvoiceReqBo reqBo) {
        //定义出参对象
        UocDealUploadInvoiceRspBo rspBo = new UocDealUploadInvoiceRspBo();

        //定义销售单DO，参数转换
        UocSaleOrderDo invoiceUocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        //设置销售单发票状态
        invoiceUocSaleOrderDo.setInvoiceState(UocConstant.INVOICE_STATE.INVOICE_SUCCESS);
        //设置销售单发票地址
        invoiceUocSaleOrderDo.setInvoiceUrl(reqBo.getInvoiceUrl());

        //调用销售单模型层，上传发票处理，修改销售单数据
        this.iUocSaleOrderModel.dealUploadInvoice(invoiceUocSaleOrderDo);


        //定义销售单主体查询BO
        UocSaleOrderQryBo qryUocSaleOrderQryBo = new UocSaleOrderQryBo();
        //设置销售单ID
        qryUocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());

        //调用销售单模型，查询销售单主体
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(qryUocSaleOrderQryBo);

        //出参
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());
        rspBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

}


