/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.thread;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.components.thread.runnable.LogTraceIdRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.MDC;

public class DycThreadPoolExecutor
extends ThreadPoolExecutor {
    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, @NotNull ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, @NotNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public DycThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit unit, @NotNull BlockingQueue<Runnable> workQueue, @NotNull ThreadFactory threadFactory, @NotNull RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        super.execute(DycThreadPoolExecutor.wrapWithLogTraceIdRunnable(command));
    }

    public static Runnable wrapWithLogTraceIdRunnable(Runnable runnable) {
        String logTraceId = MDC.get((String)"X-B3-TraceId");
        if (ObjectUtil.isNotEmpty((Object)logTraceId)) {
            return new LogTraceIdRunnable(runnable, logTraceId);
        }
        return runnable;
    }
}

