/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.cmporder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.cmporder.UocCopyCmpOrderService;
import com.tydic.dyc.oc.service.cmporder.bo.SkuCmpOrderRelBO;
import com.tydic.dyc.oc.service.cmporder.bo.UocCopyCmpOrderServiceReqBo;
import com.tydic.dyc.oc.service.cmporder.bo.UocCopyCmpOrderServiceRspBo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.cmporder.UocCopyCmpOrderService"})
public class UocCopyCmpOrderServiceImpl
implements UocCopyCmpOrderService {
    @Autowired
    private IUocCmpOrderModel uocCmpOrderModel;
    @Autowired
    private IUocSaleOrderModel uocSaleOrderModel;

    @PostMapping(value={"dealCopyCmpOrder"})
    public UocCopyCmpOrderServiceRspBo dealCopyCmpOrder(@RequestBody UocCopyCmpOrderServiceReqBo reqBo) {
        UocCopyCmpOrderServiceRspBo rsp = new UocCopyCmpOrderServiceRspBo();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderItem> qrtSaleItemResult = this.uocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(qrtSaleItemResult)) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
        List skuCmpOrderRelBOList = qrtSaleItemResult.stream().filter(bo -> null != bo.getCmpOrderNo()).map(bo -> {
            SkuCmpOrderRelBO skuCmpOrderRelBO = new SkuCmpOrderRelBO();
            skuCmpOrderRelBO.setSkuId(bo.getSkuId());
            skuCmpOrderRelBO.setCmpOrderNo(bo.getCmpOrderNo());
            return skuCmpOrderRelBO;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(skuCmpOrderRelBOList)) {
            for (SkuCmpOrderRelBO bo2 : skuCmpOrderRelBOList) {
                UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
                uocCmpOrderQryBo.setCmpOrderNo(bo2.getCmpOrderNo());
                UocCmpOrderQryBo qryCmpResult = this.uocCmpOrderModel.qryCmpOrder(uocCmpOrderQryBo);
                if (null == qryCmpResult) {
                    throw new BaseBusinessException("100001", "\u5fc5\u9009\u5355\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a\uff01");
                }
                UocCmpOrderDo uocCmpOrderDo = (UocCmpOrderDo)JSON.parseObject((String)JSON.toJSONString((Object)qryCmpResult), UocCmpOrderDo.class);
                uocCmpOrderDo.setCreateTime(new Date());
                uocCmpOrderDo.setCreateOperName(reqBo.getName());
                uocCmpOrderDo.setCreateOperId(reqBo.getUserId().toString());
                uocCmpOrderDo.setCreateOrgId(String.valueOf(reqBo.getOrgId()));
                uocCmpOrderDo.setCreateOrgName(reqBo.getOrgName());
                uocCmpOrderDo.setUpdateTime(null);
                uocCmpOrderDo.setUpdateOperId(null);
                this.uocCmpOrderModel.createCmpOrder(uocCmpOrderDo);
                bo2.setCmpOrderNo(uocCmpOrderDo.getCmpOrderNo());
            }
            rsp.setSkuCmpOrderRelBOList(skuCmpOrderRelBOList);
        }
        return rsp;
    }
}

