/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderConfirmOrRefuseTransaction;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderConfirmOrRefuseService"})
public class UocAfterOrderConfirmOrRefuseServiceImpl
implements UocAfterOrderConfirmOrRefuseService {
    private static final Logger log = LoggerFactory.getLogger(UocAfterOrderConfirmOrRefuseServiceImpl.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocAfterOrderConfirmOrRefuseTransaction uocAfterOrderConfirmOrRefuseTransaction;

    @PostMapping(value={"dealAfterOrder"})
    public UocAfterOrderConfirmOrRefuseRspBo dealAfterOrder(@RequestBody UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        UocAfterOrderConfirmOrRefuseRspBo rspBo = this.uocAfterOrderConfirmOrRefuseTransaction.dealAfterOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocAfterOrderConfirmOrRefuseReqBo reqBo, UocAfterOrderConfirmOrRefuseRspBo rspBo) {
        long orderId;
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        if (!CollectionUtils.isEmpty((Collection)rspBo.getSaleOrderIdList())) {
            for (String saleOrderIdVsOrderIdStr : rspBo.getSaleOrderIdList()) {
                String[] saleOrderIdVsOrderIdArr = saleOrderIdVsOrderIdStr.split("-");
                long saleOrderId = Long.parseLong(saleOrderIdVsOrderIdArr[0]);
                orderId = Long.parseLong(saleOrderIdVsOrderIdArr[1]);
                SyncEsRunnableBo syncBatchSaleEsRunnableBo = new SyncEsRunnableBo();
                syncBatchSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
                syncBatchSaleEsRunnableBo.setOrderId(orderId);
                syncBatchSaleEsRunnableBo.setObjId(saleOrderId);
                syncBatchSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                syncEsRunnableBoList.add(syncBatchSaleEsRunnableBo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBo.getShipOrderIdList())) {
            for (String shipOrderIdVsOrderIdStr : rspBo.getShipOrderIdList()) {
                String[] shipOrderIdVsOrderIdArr = shipOrderIdVsOrderIdStr.split("-");
                long shipOrderId = Long.parseLong(shipOrderIdVsOrderIdArr[0]);
                orderId = Long.parseLong(shipOrderIdVsOrderIdArr[1]);
                SyncEsRunnableBo syncBatchShipEsRunnableBo = new SyncEsRunnableBo();
                syncBatchShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
                syncBatchShipEsRunnableBo.setOrderId(orderId);
                syncBatchShipEsRunnableBo.setObjId(shipOrderId);
                syncBatchShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                syncEsRunnableBoList.add(syncBatchShipEsRunnableBo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBo.getAfOrderIdList())) {
            for (String afOrderIdVsOrderIdStr : rspBo.getAfOrderIdList()) {
                String[] afOrderIdVsOrderIdArr = afOrderIdVsOrderIdStr.split("-");
                long afOrderId = Long.parseLong(afOrderIdVsOrderIdArr[0]);
                orderId = Long.parseLong(afOrderIdVsOrderIdArr[1]);
                SyncEsRunnableBo syncBatchAfEsRunnableBo = new SyncEsRunnableBo();
                syncBatchAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
                syncBatchAfEsRunnableBo.setOrderId(orderId);
                syncBatchAfEsRunnableBo.setObjId(afOrderId);
                syncBatchAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                syncEsRunnableBoList.add(syncBatchAfEsRunnableBo);
            }
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

