/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.oc.transactionservice.UocSaleShipOrderTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService"})
public class UocSaleShipOrderServiceImpl
implements UocSaleShipOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocSaleShipOrderServiceImpl.class);
    @Autowired
    private UocSaleShipOrderTransaction uocSaleShipOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealImplShipOrder"})
    public UocSaleShipOrderRspBo dealImplShipOrder(@RequestBody UocSaleShipOrderReqBo reqBo) {
        UocSaleShipOrderRspBo rspBo = this.uocSaleShipOrderTransaction.dealImplShipOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocSaleShipOrderReqBo reqBo, UocSaleShipOrderRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
        shipBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        shipBo.setOrderId(reqBo.getOrderId());
        shipBo.setObjId(rspBo.getShipOrderId());
        shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(shipBo);
        log.debug("\u53d1\u8d27\u5355es\u540c\u6b65\uff1a" + JSON.toJSONString(list));
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

