/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocShipOrderConfirmReceiptService;
import com.tydic.dyc.oc.service.domainservice.bo.UocConfirmReceiptShipOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderConfirmReceiptRspBo;
import com.tydic.dyc.oc.transactionservice.UocShipOrderConfirmReceiptTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocShipOrderConfirmReceiptService"})
public class UocShipOrderConfirmReceiptServiceImpl
implements UocShipOrderConfirmReceiptService {
    private static final Logger log = LoggerFactory.getLogger(UocShipOrderConfirmReceiptServiceImpl.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocShipOrderConfirmReceiptTransaction uocShipOrderConfirmReceiptTransaction;

    @PostMapping(value={"dealConfirmReceipt"})
    public UocShipOrderConfirmReceiptRspBo dealConfirmReceipt(@RequestBody UocShipOrderConfirmReceiptReqBo reqBo) {
        UocShipOrderConfirmReceiptRspBo rspBo = this.uocShipOrderConfirmReceiptTransaction.dealConfirmReceipt(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocShipOrderConfirmReceiptReqBo reqBo, UocShipOrderConfirmReceiptRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo syncEsRunnableBo = new SyncEsRunnableBo();
        syncEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        syncEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncEsRunnableBo.setObjId(reqBo.getSaleOrderId());
        syncEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncEsRunnableBo);
        for (UocConfirmReceiptShipOrderBO bo : rspBo.getUocConfirmReceiptShipOrderBOList()) {
            SyncEsRunnableBo syncBatchShipEsRunnableBo = new SyncEsRunnableBo();
            syncBatchShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            syncBatchShipEsRunnableBo.setOrderId(bo.getOrderId());
            syncBatchShipEsRunnableBo.setObjId(bo.getShipOrderId());
            syncBatchShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            syncEsRunnableBoList.add(syncBatchShipEsRunnableBo);
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

