/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocAllocationItemService;
import com.tydic.dyc.oc.service.saleorder.bo.UocAllocationItemReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocAllocationItemRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocIntelligentZdPriceInfoBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocIntelligentZdPriceInfoDataBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocIntelligentZdPriceInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocIntelligentZdPriceInfoRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.SslClientUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocAllocationItemService"})
public class UocAllocationItemServiceImpl
implements UocAllocationItemService {
    private static final Logger log = LoggerFactory.getLogger(UocAllocationItemServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    private static final String POOL_NAME_SUPERMARKET = "supermarket";
    @Value(value="${uoc.intelligent.queryZdPriceInfo.url:/iio2/046564/tydicApi/queryZdPriceInfo}")
    private String queryZdPriceInfoUrl;

    @PostMapping(value={"dealAllocationItem"})
    public UocAllocationItemRspBO dealAllocationItem(@RequestBody UocAllocationItemReqBO reqBO) {
        UocAllocationItemRspBO rsp = new UocAllocationItemRspBO();
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemListByItemIds(reqBO.getSaleOrderItemIds());
        if (CollectionUtils.isEmpty(saleOrderItemList) || saleOrderItemList.size() != reqBO.getSaleOrderItemIds().size()) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u9519\u8bef\uff01");
        }
        UocIntelligentZdPriceInfoRspBO intelligentZdPriceInfo = this.getIntelligentZdPriceInfo(saleOrderItemList.stream().map(UocSaleOrderItem::getSkuId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)intelligentZdPriceInfo.getResult()) || saleOrderItemList.size() != intelligentZdPriceInfo.getResult().size()) {
            throw new BaseBusinessException("100001", "\u83b7\u53d6\u667a\u80fd\u62a5\u4ef7\u53ca\u540c\u6b3e\u4fe1\u606f\u9519\u8bef\uff01");
        }
        Map intelligentZdPriceMap = intelligentZdPriceInfo.getResult().stream().collect(Collectors.toMap(UocIntelligentZdPriceInfoBO::getSkuId, Function.identity(), (existing, replacement) -> existing));
        for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
            UocIntelligentZdPriceInfoBO uocIntelligentZdPriceInfoBO = (UocIntelligentZdPriceInfoBO)intelligentZdPriceMap.get(saleOrderItem.getSkuId());
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            uocSaleOrderItem.setAllocationFlag(UocConstant.AllocationFlag.ALLOCATIONED);
            uocSaleOrderItem.setAllocationUserId(reqBO.getAllocationUserId());
            uocSaleOrderItem.setAllocationName(reqBO.getAllocationName());
            uocSaleOrderItem.setCheckFlag(UocConstant.CheckFlag.NO_CHECK);
            uocSaleOrderItem.setCheckUserId(reqBO.getCheckUserId());
            uocSaleOrderItem.setCheckName(reqBO.getCheckName());
            uocSaleOrderItem.setGuidePrice(uocIntelligentZdPriceInfoBO.getGuidePrice());
            uocSaleOrderItem.setInternetPrice(uocIntelligentZdPriceInfoBO.getInternetPrice());
            uocSaleOrderItem.setAllocationTime(new Date());
            this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        }
        return rsp;
    }

    private UocIntelligentZdPriceInfoRspBO getIntelligentZdPriceInfo(List<String> skuIdList) {
        UocIntelligentZdPriceInfoRspBO dycIntelligentZdPriceInfoRspBO = new UocIntelligentZdPriceInfoRspBO();
        try {
            UocIntelligentZdPriceInfoDataBO dycIntelligentZdPriceInfoDataBO = new UocIntelligentZdPriceInfoDataBO();
            dycIntelligentZdPriceInfoDataBO.setSkuIdList(skuIdList);
            UocIntelligentZdPriceInfoReqBO dycIntelligentZdPriceInfoReqBO = new UocIntelligentZdPriceInfoReqBO();
            dycIntelligentZdPriceInfoReqBO.setSerialNo(String.valueOf(IdUtil.nextId()));
            dycIntelligentZdPriceInfoReqBO.setPoolName(POOL_NAME_SUPERMARKET);
            dycIntelligentZdPriceInfoReqBO.setData((Object)dycIntelligentZdPriceInfoDataBO);
            log.info("\u8ba2\u5355\u5206\u914d\u63a5\u53e3|\u83b7\u53d6\u667a\u80fd\u62a5\u4ef7\u53ca\u540c\u6b3e\u4fe1\u606f|\u8c03\u7528\u667a\u80fd\u5316\u5e73\u53f0\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)dycIntelligentZdPriceInfoReqBO));
            String httpRspStr = SslClientUtil.doPost(this.queryZdPriceInfoUrl, JSON.toJSONString((Object)dycIntelligentZdPriceInfoReqBO));
            log.info("\u8ba2\u5355\u5206\u914d\u63a5\u53e3|\u83b7\u53d6\u667a\u80fd\u62a5\u4ef7\u53ca\u540c\u6b3e\u4fe1\u606f|\u8c03\u7528\u667a\u80fd\u5316\u5e73\u53f0\u51fa\u53c2: {}", (Object)httpRspStr);
            dycIntelligentZdPriceInfoRspBO = (UocIntelligentZdPriceInfoRspBO)JSON.parseObject((String)httpRspStr, UocIntelligentZdPriceInfoRspBO.class);
            if (!"0000".equals(dycIntelligentZdPriceInfoRspBO.getRespCode())) {
                log.error("\u8ba2\u5355\u5206\u914d\u63a5\u53e3|\u83b7\u53d6\u667a\u80fd\u62a5\u4ef7\u53ca\u540c\u6b3e\u4fe1\u606f|\u8c03\u7528\u667a\u80fd\u5316\u5e73\u53f0\u5931\u8d25: {}", (Object)dycIntelligentZdPriceInfoRspBO.getRspDesc());
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u5206\u914d\u63a5\u53e3|\u83b7\u53d6\u667a\u80fd\u62a5\u4ef7\u53ca\u540c\u6b3e\u4fe1\u606f|\u8c03\u7528\u667a\u80fd\u5316\u5e73\u53f0\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new ZTBusinessException("\u8ba2\u5355\u5206\u914d\u63a5\u53e3|\u83b7\u53d6\u667a\u80fd\u62a5\u4ef7\u53ca\u540c\u6b3e\u4fe1\u606f|\u8c03\u7528\u667a\u80fd\u5316\u5e73\u53f0\u5f02\u5e38: " + e.getMessage());
        }
        return dycIntelligentZdPriceInfoRspBO;
    }
}

