/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.sub.UocProblemSaleItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocCheckMarkItemService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCheckMarkItemReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCheckMarkItemRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocCheckMarkItemService"})
public class UocCheckMarkItemServiceImpl
implements UocCheckMarkItemService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"dealCheckMarkItem"})
    public UocCheckMarkItemRspBO dealCheckMarkItem(@RequestBody UocCheckMarkItemReqBO reqBO) {
        UocCheckMarkItemRspBO rsp = new UocCheckMarkItemRspBO();
        UocProblemSaleItem uocProblemSaleItem = new UocProblemSaleItem();
        uocProblemSaleItem.setProblemSaleItemId(IdUtil.nextId());
        uocProblemSaleItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocProblemSaleItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocProblemSaleItem.setOrderId(reqBO.getOrderId());
        uocProblemSaleItem.setFeedbackId(reqBO.getFeedbackId());
        uocProblemSaleItem.setProblemSaleItemType(reqBO.getProblemSaleItemType());
        uocProblemSaleItem.setCheckUserId(reqBO.getCheckUserId());
        uocProblemSaleItem.setCheckName(reqBO.getCheckName());
        uocProblemSaleItem.setCheckMoblePhone(reqBO.getCheckMoblePhone());
        uocProblemSaleItem.setPriceAbnormalFlag(UocConstant.PriceAbnormalFlag.SUBMIT_FEED);
        uocProblemSaleItem.setGoodCheckPrice(reqBO.getGoodCheckPrice());
        uocProblemSaleItem.setReferPriceUrl(reqBO.getReferPriceUrl());
        uocProblemSaleItem.setProblemDesc(reqBO.getProblemDesc());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            uocProblemSaleItem.setEvidenceAccessory(JSON.toJSONString((Object)reqBO.getAccessoryList()));
        }
        uocProblemSaleItem.setCreateUserId(reqBO.getCheckName());
        uocProblemSaleItem.setCreateUserName(reqBO.getCheckUserId());
        uocProblemSaleItem.setCreateTime(new Date());
        this.iUocSaleOrderModel.insertProblemSaleItem(uocProblemSaleItem);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(result.getSaleOrderItems()) || result.getSaleOrderItems().size() != 1) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
        }
        UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
        uocSaleOrderItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItem.setOrderId(reqBO.getOrderId());
        uocSaleOrderItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderItem.setProblemSaleItemId(uocProblemSaleItem.getProblemSaleItemId());
        uocSaleOrderItem.setFeedbackId(reqBO.getFeedbackId());
        if (null != reqBO.getCheckFlag()) {
            uocSaleOrderItem.setCheckFlag(reqBO.getCheckFlag());
        } else {
            uocSaleOrderItem.setCheckFlag(UocConstant.CheckFlag.PROBLEM_GOODS);
        }
        uocSaleOrderItem.setPriceAbnormalFlag(UocConstant.PriceAbnormalFlag.SUBMIT_FEED);
        if (null != reqBO.getGoodCheckPrice()) {
            uocSaleOrderItem.setGoodCheckPrice(reqBO.getGoodCheckPrice());
            uocSaleOrderItem.setPenaltyCoefficient(reqBO.getPenaltyCoefficient());
            UocSaleOrderItem saleItem = result.getSaleOrderItems().get(0);
            BigDecimal penaltyFee = saleItem.getSalePrice().subtract(reqBO.getGoodCheckPrice()).multiply(saleItem.getPurchaseCount()).multiply(reqBO.getPenaltyCoefficient()).setScale(2, RoundingMode.HALF_UP);
            uocSaleOrderItem.setPenaltyFee(penaltyFee);
        }
        uocSaleOrderItem.setFeedbackNo(reqBO.getFeedbackNo());
        uocSaleOrderItem.setFeedbackStateCode(reqBO.getFeedbackStateCode());
        uocSaleOrderItem.setFeedbackStateName(reqBO.getFeedbackStateName());
        this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        return rsp;
    }
}

