/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocDealBackSapOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderRspBO;
import com.tydic.dyc.oc.transactionservice.UocDealBackSapOrderTransaction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocDealBackSapOrderService"})
public class UocDealBackSapOrderServiceImpl
implements UocDealBackSapOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocDealBackSapOrderServiceImpl.class);
    @Autowired
    private UocDealBackSapOrderTransaction uocDealBackSapOrderTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealBackSapOrder"})
    public UocDealBackSapOrderRspBO dealBackSapOrder(@RequestBody UocDealBackSapOrderReqBO reqBO) {
        UocDealBackSapOrderRspBO rspBo = this.uocDealBackSapOrderTransaction.dealBackSapOrder(reqBO);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBO, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBo) {
        ArrayList<SyncEsRunnableBo> list = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(rspBo.getOrderId());
        saleBo.setObjId(rspBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        if (null != rspBo.getShipOrderId()) {
            SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
            shipBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            shipBo.setOrderId(rspBo.getOrderId());
            shipBo.setObjId(rspBo.getShipOrderId());
            shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(shipBo);
        }
        log.debug("\u9a8c\u6536\u5355es\u540c\u6b65\uff1a" + JSON.toJSONString(list));
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}

