/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.sub.UocProblemSaleItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocGoodsPriceAbnormalBackService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGoodsPriceAbnormalBackReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocGoodsPriceAbnormalBackRspBO;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocGoodsPriceAbnormalBackService"})
public class UocGoodsPriceAbnormalBackServiceImpl
implements UocGoodsPriceAbnormalBackService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"dealGoodsPriceAbnormalBack"})
    public UocGoodsPriceAbnormalBackRspBO dealGoodsPriceAbnormalBack(@RequestBody UocGoodsPriceAbnormalBackReqBO reqBO) {
        this.validateParam(reqBO);
        UocGoodsPriceAbnormalBackRspBO rsp = new UocGoodsPriceAbnormalBackRspBO();
        UocProblemSaleItem uocProblemSaleItem = new UocProblemSaleItem();
        uocProblemSaleItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocProblemSaleItem.setOrderId(reqBO.getOrderId());
        uocProblemSaleItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocProblemSaleItem.setFeedbackId(reqBO.getFeedbackId());
        UocProblemSaleItem result = this.iUocSaleOrderModel.qryProblemSaleItem(uocProblemSaleItem);
        if (null == result) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u95ee\u9898\u5546\u54c1\u8bb0\u5f55\u8868\u4e3a\u7a7a");
        }
        UocProblemSaleItem updateUocProblemSaleItem = new UocProblemSaleItem();
        updateUocProblemSaleItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        updateUocProblemSaleItem.setOrderId(reqBO.getOrderId());
        updateUocProblemSaleItem.setSaleOrderId(reqBO.getSaleOrderId());
        updateUocProblemSaleItem.setFeedbackId(reqBO.getFeedbackId());
        updateUocProblemSaleItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
        updateUocProblemSaleItem.setUpdateTime(new Date());
        this.iUocSaleOrderModel.updateUocProblemSaleItem(updateUocProblemSaleItem);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo nowSaleOrderItem = this.iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(nowSaleOrderItem.getSaleOrderItems()) || nowSaleOrderItem.getSaleOrderItems().size() != 1) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
        }
        UocSaleOrderItem nowSaleItem = nowSaleOrderItem.getSaleOrderItems().get(0);
        UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
        uocSaleOrderItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItem.setOrderId(reqBO.getOrderId());
        uocSaleOrderItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderItem.setFeedbackId(reqBO.getFeedbackId());
        uocSaleOrderItem.setProblemSaleItemId(result.getProblemSaleItemId());
        uocSaleOrderItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
        this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        if (UocConstant.PriceAbnormalFlag.ERROR_GOODS.equals(reqBO.getPriceAbnormalFlag())) {
            Date date = result.getCreateTime();
            ZoneId zoneId = ZoneId.systemDefault();
            Instant instant = date.toInstant();
            LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
            System.out.println("Date: " + date);
            System.out.println("LocalDateTime: " + localDateTime);
            Date createTimeStart = this.getPreviousWorkdayMidnight(localDateTime);
            Date createTimeEnd = this.getAfterdayMidnight();
            UocSaleOrderItemQryBo qryUocSaleOrderItem = new UocSaleOrderItemQryBo();
            qryUocSaleOrderItem.setCreateTimeStart(createTimeStart);
            qryUocSaleOrderItem.setCreateTimeEnd(createTimeEnd);
            qryUocSaleOrderItem.setSkuId(nowSaleItem.getSkuId());
            UocSaleOrderDo saleOrderItem = this.iUocSaleOrderModel.getListSaleOrderItem(qryUocSaleOrderItem);
            if (CollectionUtils.isEmpty(saleOrderItem.getSaleOrderItems())) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a");
            }
            for (UocSaleOrderItem saleItem : saleOrderItem.getSaleOrderItems()) {
                UocSaleOrderItem updateSaleOrderItem;
                if (saleItem.getSaleOrderItemId().equals(reqBO.getSaleOrderItemId()) || UocConstant.CheckFlag.PROBLEM_GOODS.equals(saleItem.getCheckFlag())) continue;
                if (UocConstant.CheckFlag.NO_CHECK.equals(saleItem.getCheckFlag()) || UocConstant.CheckFlag.TIME_OUT_CHECK.equals(saleItem.getCheckFlag())) {
                    updateSaleOrderItem = new UocSaleOrderItem();
                    updateSaleOrderItem.setSaleOrderItemId(saleItem.getSaleOrderItemId());
                    updateSaleOrderItem.setOrderId(saleItem.getOrderId());
                    updateSaleOrderItem.setSaleOrderId(saleItem.getSaleOrderId());
                    updateSaleOrderItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
                    updateSaleOrderItem.setCheckFlag(UocConstant.CheckFlag.SAME_PROBLEM_GOODS);
                    updateSaleOrderItem.setGoodCheckPrice(nowSaleItem.getGoodCheckPrice());
                    updateSaleOrderItem.setPenaltyCoefficient(nowSaleItem.getPenaltyCoefficient());
                    updateSaleOrderItem.setPenaltyFee(nowSaleItem.getPenaltyFee());
                    this.iUocSaleOrderModel.updateSaleOrderItem(updateSaleOrderItem);
                }
                if (null != saleItem.getAllocationFlag()) continue;
                updateSaleOrderItem = new UocSaleOrderItem();
                updateSaleOrderItem.setSaleOrderItemId(saleItem.getSaleOrderItemId());
                updateSaleOrderItem.setOrderId(saleItem.getOrderId());
                updateSaleOrderItem.setSaleOrderId(saleItem.getSaleOrderId());
                updateSaleOrderItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
                updateSaleOrderItem.setAllocationFlag(UocConstant.AllocationFlag.SAME_PROBLEM_GOODS);
                updateSaleOrderItem.setGoodCheckPrice(nowSaleItem.getGoodCheckPrice());
                updateSaleOrderItem.setPenaltyCoefficient(nowSaleItem.getPenaltyCoefficient());
                updateSaleOrderItem.setPenaltyFee(nowSaleItem.getPenaltyFee());
                this.iUocSaleOrderModel.updateSaleOrderItem(updateSaleOrderItem);
            }
        }
        return rsp;
    }

    private Date getAfterdayMidnight() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nextDayMidnight = now.plusDays(1L).with(LocalTime.MIDNIGHT);
        ZonedDateTime zonedDateTime = nextDayMidnight.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public Date getPreviousWorkdayMidnight(LocalDateTime dateTime) {
        LocalDate previousDate = dateTime.toLocalDate();
        while (!this.isWeekend(previousDate = previousDate.minusDays(1L))) {
        }
        LocalDateTime previousWorkdayMidnight = previousDate.atTime(LocalTime.MIDNIGHT);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = previousWorkdayMidnight.atZone(zoneId);
        Date date = Date.from(zonedDateTime.toInstant());
        System.out.println("previousWorkdayMidnight: " + previousWorkdayMidnight);
        System.out.println("Date: " + date);
        return date;
    }

    private boolean isWeekend(LocalDate previousDate) {
        return this.iUocSaleOrderModel.isWeekend(previousDate);
    }

    private void validateParam(UocGoodsPriceAbnormalBackReqBO reqBO) {
        if (null == reqBO.getSaleOrderItemId()) {
            throw new BaseBusinessException("100001", "\u4ef7\u683c\u5f02\u5e38\u5546\u54c1\u786e\u8ba4\u56de\u8c03\u63a5\u53e3\u5165\u53c2\u3010saleOrderItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u4ef7\u683c\u5f02\u5e38\u5546\u54c1\u786e\u8ba4\u56de\u8c03\u63a5\u53e3\u5165\u53c2\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BaseBusinessException("100001", "\u4ef7\u683c\u5f02\u5e38\u5546\u54c1\u786e\u8ba4\u56de\u8c03\u63a5\u53e3\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFeedbackId())) {
            throw new BaseBusinessException("100001", "\u4ef7\u683c\u5f02\u5e38\u5546\u54c1\u786e\u8ba4\u56de\u8c03\u63a5\u53e3\u5165\u53c2\u3010feedbackId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPriceAbnormalFlag()) {
            throw new BaseBusinessException("100001", "\u4ef7\u683c\u5f02\u5e38\u5546\u54c1\u786e\u8ba4\u56de\u8c03\u63a5\u53e3\u5165\u53c2\u3010priceAbnormalFlag\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

