/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.saleorder.UocQrySendEcPlatOrderInfoService;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendEcPlatOrderInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendEcPlatOrderInfoRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSendEcPlatOrderBO;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocQrySendEcPlatOrderInfoService"})
public class UocQrySendEcPlatOrderInfoServiceImpl
implements UocQrySendEcPlatOrderInfoService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"qrySendEcPlatOrderInfo"})
    public UocQrySendEcPlatOrderInfoRspBO qrySendEcPlatOrderInfo(@RequestBody UocQrySendEcPlatOrderInfoReqBO reqBO) {
        UocQrySendEcPlatOrderInfoRspBO rspBO = UocRu.success(UocQrySendEcPlatOrderInfoRspBO.class);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        UocSaleStakeholderQryBo uocSaleStakeholderQryBo = new UocSaleStakeholderQryBo();
        uocSaleStakeholderQryBo.setOrderId(result.getOrderId());
        uocSaleStakeholderQryBo.setStakeholderId(result.getStakeholderId());
        UocSaleStakeholder stock = this.iUocSaleOrderModel.getSaleOrderStakeholder(uocSaleStakeholderQryBo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocOrderTaskInst uocOrderTaskInst = null;
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(result.getOrderSource())) {
            UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
            selectuocApprovalObjQryBo.setObjId(reqBO.getSaleOrderId().toString());
            selectuocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
            List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
            if (!CollectionUtils.isEmpty(uocApprovalObjs)) {
                UocOrderTaskInst qryInst = new UocOrderTaskInst();
                qryInst.setOrderId(reqBO.getOrderId());
                qryInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
                qryInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
                List<UocOrderTaskInst> auditOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(qryInst);
                if (!CollectionUtils.isEmpty(auditOrderTaskInsts)) {
                    uocOrderTaskInst = auditOrderTaskInsts.get(0);
                }
            }
        }
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            ArrayList<UocSendEcPlatOrderBO> sendEcPlatOrderBOList = new ArrayList<UocSendEcPlatOrderBO>();
            for (UocSaleOrderItem bo : saleOrderItemList) {
                UocSendEcPlatOrderBO uocSendEcPlatOrderBO = new UocSendEcPlatOrderBO();
                uocSendEcPlatOrderBO.setSaleOrderId(bo.getSaleOrderId());
                uocSendEcPlatOrderBO.setSaleOrderNo(result.getSaleOrderNo());
                uocSendEcPlatOrderBO.setSaleOrderItemId(bo.getSaleOrderItemId());
                uocSendEcPlatOrderBO.setSapOrderNo(bo.getSapOrderNo());
                uocSendEcPlatOrderBO.setSapOrderItemNo(bo.getSapOrderItemNo());
                uocSendEcPlatOrderBO.setSkuCode(bo.getSkuCode());
                uocSendEcPlatOrderBO.setSkuName(bo.getSkuName());
                uocSendEcPlatOrderBO.setSalePrice(bo.getSalePrice());
                uocSendEcPlatOrderBO.setPurchaseCount(bo.getPurchaseCount());
                uocSendEcPlatOrderBO.setCreateOperId(result.getCreateOperId());
                uocSendEcPlatOrderBO.setCreateOperName(result.getCreateOperName());
                if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(result.getOrderSource())) {
                    SimpleDateFormat sdf;
                    if (null != uocOrderTaskInst) {
                        uocSendEcPlatOrderBO.setCollectId(uocOrderTaskInst.getDealOperId());
                        uocSendEcPlatOrderBO.setCollectName(uocOrderTaskInst.getDealOperName());
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        uocSendEcPlatOrderBO.setOrderAuditTime(sdf.format(uocOrderTaskInst.getFinishTime()));
                    } else {
                        uocSendEcPlatOrderBO.setCollectId(result.getCreateOperId());
                        uocSendEcPlatOrderBO.setCollectName(result.getCreateOperName());
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        uocSendEcPlatOrderBO.setOrderAuditTime(sdf.format(result.getCreateTime()));
                    }
                }
                if (null == result.getSaleOrderState()) {
                    uocSendEcPlatOrderBO.setSaleOrderState("XS_QR_PDQR");
                    uocSendEcPlatOrderBO.setSaleOrderStateStr("\u5f85\u786e\u8ba4");
                } else {
                    uocSendEcPlatOrderBO.setSaleOrderState("XS_FH_DFH");
                    uocSendEcPlatOrderBO.setSaleOrderStateStr("\u5f85\u53d1\u8d27");
                }
                if (UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(stock.getSupId()) || UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(stock.getSupId()) || UocOrderPropertiesUtil.getProperty("SUPPLIER_JDVOP_ID").equals(stock.getSupId())) {
                    uocSendEcPlatOrderBO.setSaleOrderState("XS_FH_FHZ");
                    uocSendEcPlatOrderBO.setSaleOrderStateStr("\u53d1\u8d27\u4e2d");
                }
                uocSendEcPlatOrderBO.setTotalSaleFee(result.getTotalSaleFee());
                uocSendEcPlatOrderBO.setOrderCreateTime(result.getCreateTime());
                uocSendEcPlatOrderBO.setUnitName(bo.getUnitName());
                uocSendEcPlatOrderBO.setSupplierId(stock.getSupId());
                uocSendEcPlatOrderBO.setSupplierName(stock.getSupName());
                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(result.getOrderSource())) {
                    uocSendEcPlatOrderBO.setAreaType("02");
                } else {
                    if (1 == result.getAreaType()) {
                        uocSendEcPlatOrderBO.setAreaType("01");
                    }
                    if (2 == result.getAreaType()) {
                        uocSendEcPlatOrderBO.setAreaType("00");
                    }
                }
                uocSendEcPlatOrderBO.setPurCompanyId(stock.getPurCompanyId());
                uocSendEcPlatOrderBO.setPurCompanyName(stock.getPurCompanyName());
                uocSendEcPlatOrderBO.setPurOrgId(stock.getPurOrgId());
                uocSendEcPlatOrderBO.setPurOrgName(stock.getPurOrgName());
                uocSendEcPlatOrderBO.setPurchaseNo(bo.getPlanItemNo());
                uocSendEcPlatOrderBO.setPurchaseCode(bo.getSkuMaterialCode());
                sendEcPlatOrderBOList.add(uocSendEcPlatOrderBO);
            }
            rspBO.setRows(sendEcPlatOrderBOList);
        }
        return rspBO;
    }
}

