/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPayOrderCallbackReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPayOrderCallbackRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocPayOrderCallbackTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocPayOrderCallbackTransaction.class);
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocPayOrderCallbackRspBo dealPayOrderCallback(UocPayOrderCallbackReqBo reqBo) {
        UocPayOrderCallbackRspBo rspBo = new UocPayOrderCallbackRspBo();
        this.validateParam(reqBo);
        this.updatePayOrderInfo(reqBo);
        this.dealPaySaleOrderInfo(reqBo);
        UocOrderTaskInst uocOrderTaskInst = this.getTaskInstList(reqBo);
        this.submitTask(uocOrderTaskInst);
        UocSaleOrderDo uocSaleOrderDo = this.getUocSaleOrder(reqBo);
        rspBo.setOrderId(uocSaleOrderDo.getSaleOrderId());
        rspBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        rspBo.setTaskId(uocOrderTaskInst.getTaskInstId());
        rspBo.setProcState(uocOrderTaskInst.getProcState());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateParam(UocPayOrderCallbackReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPayResult())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u652f\u4ed8\u7ed3\u679c]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocSaleOrderDo getUocSaleOrder(UocPayOrderCallbackReqBo reqBo) {
        UocSaleOrderQryBo qryUocSaleOrderQryBo = new UocSaleOrderQryBo();
        qryUocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(qryUocSaleOrderQryBo);
    }

    private UocOrderTaskInst getTaskInstList(UocPayOrderCallbackReqBo reqBo) {
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setObjId(reqBo.getSaleOrderId());
        uocOrderTaskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInstList = this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
        if (CollectionUtils.isEmpty(uocOrderTaskInstList)) {
            throw new BaseBusinessException("100001", "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (uocOrderTaskInstList.size() > 1) {
            throw new BaseBusinessException("100001", "\u4efb\u52a1\u6570\u91cf\u5927\u4e8e1");
        }
        return uocOrderTaskInstList.get(0);
    }

    private void updatePayOrderInfo(UocPayOrderCallbackReqBo reqBo) {
        UocSaleOrderDo payOrderUocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        payOrderUocSaleOrderDo.setPayState(UocConstant.PAY_RESULT.SUCCESS.equals(reqBo.getPayResult()) ? UocDicConstant.PAY_STATE.PAYED : UocDicConstant.PAY_STATE.PAY_FAILED);
        this.iUocSaleOrderModel.dealPayOrderCallback(payOrderUocSaleOrderDo);
    }

    private void dealPaySaleOrderInfo(UocPayOrderCallbackReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        this.iUocCommonModel.dealPaySaleOrderInfo(uocSaleOrderDo);
    }

    private void submitTask(UocOrderTaskInst uocOrderTaskInst) {
        if ("E0015".equals(uocOrderTaskInst.getProcState())) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfoList = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>(1);
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskInfo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskInfo.setTaskId(uocOrderTaskInst.getTaskInstId());
            taskInfoList.add(taskInfo);
            uocCommonDo.setCompleteTaskInfos(taskInfoList);
            uocCommonDo.setUserId(1L);
            uocCommonDo.setOrderId(uocOrderTaskInst.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
    }
}

