package com.tydic.dyc.oc.model.common.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.qrybo.*;
import com.tydic.dyc.oc.model.common.sub.*;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.*;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCandidatesBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocFinishTaskInfoBo;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocCommonModelImpl
 * 说明:公共model 实现
 * 时间:2022/4/1 10:22
 * 作者:罗有
 */
@Slf4j
@Service
public class UocCommonModelImpl implements IUocCommonModel {

    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Autowired
    private UocInitConfig uocInitConfig;
    @Autowired
    private UocShipOrderRepository uocShipOrderRepository;

    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;
    @Autowired
    private UocChngOrderRepository uocChngOrderRepository;
    @Autowired
    private UocAuditOrderRepository uocAuditOrderRepository;
    @Autowired
    private UocOrderRepository uocOrderRepository;

    @Autowired
    private UocAfOrderRepository uocAfOrderRepository;

    //@Resource(name = "uocEcOrderTodoProvider")
    private ProxyMessageProducer proxyMessageProducer;

    //@Value("${uoc.ec.todo.done.topic:OS_TEST_DEV_TODODONE_TOPIC}")
    private String uocEcOrderTodoTopic;


    //@Value("${uoc.process.todo.tag:UOC_TODO_TAG}")
    private String uocProcessTodoTag;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    /*
     * @Author lsl
     * @Description //TODO 查询供应商配置
     * @Date 18:18 2022/4/7
     * @Param [goodsSupplierNo]
     * @return com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo
     */
    @Override
    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        return uocCommonRepository.qryConfSupplier(goodsSupplierNo);
    }

    @Override
    public List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO) {
        return uocCommonRepository.qryConfSupplierList(uocConfSupplierDO);
    }

    @Override
    public UocCommonDo uploadFile(UocCommonDo uocCommonDo) {
        if (null == uocCommonDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocCommonDo.getUocFile()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象uocFile不能为空");
        }
        if (null == uocCommonDo.getUocFile().getFilename()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[filename]不能为空");
        }
        if (null == uocCommonDo.getUocFile().getPath()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[path]不能为空");
        }
        if (null == uocCommonDo.getUocFile().getInputStream()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[inputStream]不能为空");
        }
        if (null == uocCommonDo.getUocFile().getFileType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[fileType]不能为空");
        }
        UocFile uocFile = uocCommonRepository.uploadFile(uocCommonDo.getUocFile());
        UocCommonDo commonDo = new UocCommonDo();
        commonDo.setUocFile(uocFile);
        return commonDo;
    }

    @Override
    public int saveOrderQueryIndex(UocOrderQueryIndex index) {
        return uocCommonRepository.saveOrderQueryIndex(index);
    }

    @Override
    public UocCommonDo dealTask(UocCommonDo uocCommonDo) {
        log.info("订单处理任务数据入参：{}", JSON.toJSONString(uocCommonDo));
        List<UocFinishTaskInfoBo> finishTaskInfoBos = new ArrayList<>();
        // 处理已办
        if (!CollectionUtils.isEmpty(uocCommonDo.getCompleteTaskInfos())) {
            uocCommonDo.getCompleteTaskInfos().forEach(completeTaskBo -> {
                //判断当前状态，是否为未办理
                UocOrderTaskInst qryInst = new UocOrderTaskInst();
                qryInst.setOrderId(uocCommonDo.getOrderId());
                qryInst.setTaskInstId(completeTaskBo.getTaskId());
                List<UocOrderTaskInst> uocOrderTaskInsts = uocCommonRepository.qryTaskInstList(qryInst);
                //不存在，报错
                if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + completeTaskBo.getTaskId() + ")不存在");
                }
                if (uocOrderTaskInsts.size() != 1) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + completeTaskBo.getTaskId() + ")存在多条数据");
                }
                //已办，报错
                if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + completeTaskBo.getTaskId() + ")已完结");
                }
                //如果是审批任务，校验下单人和审批人不能是同一个人
                //todo 交行poc验证
                /*if (UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    //查询销售单
                    UocOrderDo uocOrderDo = new UocOrderDo();
                    uocOrderDo.setOrderId(uocCommonDo.getOrderId());
                    UocOrderDo result = this.uocOrderRepository.qryOrderBy(uocOrderDo);
                    if (null != result && null != uocCommonDo.getUserId()) {
                        if (result.getCreateOperId().equals(uocCommonDo.getUserId().toString())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "任务实例id(" + completeTaskBo.getTaskId() + ")处理失败，下单人不能作为审批人！");
                        }
                    }
                }*/
                // 取数据库的业务类型和业务单据ID
                completeTaskBo.setBusiObjType(uocOrderTaskInsts.get(0).getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInsts.get(0).getObjId());

                //设置为已办
                List<UocOrderTaskInst> updateList = new ArrayList<>();
                UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
                updateList.add(uocOrderTaskInst);
                uocOrderTaskInst.setOrderId(uocCommonDo.getOrderId());
                uocOrderTaskInst.setTaskInstId(completeTaskBo.getTaskId());
                uocOrderTaskInst.setDealResult(completeTaskBo.getDealResult());
                uocOrderTaskInst.setDealRemark(completeTaskBo.getDealRemark());
                uocOrderTaskInst.setDealOperId(uocCommonDo.getUserId() + "");
                uocOrderTaskInst.setDealOperName(uocCommonDo.getUsername());
                uocCommonRepository.updateToFinished(updateList);
                // 组装已办信息
                UocFinishTaskInfoBo bo = JSON.parseObject(JSON.toJSONString(completeTaskBo), UocFinishTaskInfoBo.class);
                bo.setDealOperId(uocCommonDo.getUserId() + "");
                bo.setDealOperName(uocCommonDo.getUsername());
                bo.setCenter("UOC");
                finishTaskInfoBos.add(bo);
                /*//发送置为已办消息
                JSONObject param = new JSONObject();
                param.put("taskId", completeTaskBo.getTaskId());
                proxyMessageProducer.send(new ProxyMessage(uocEcOrderTodoTopic, uocProcessTodoTag, JSON.toJSONString(param)));*/
                // 如果审批任务所在的环节编码已完成，则把环节下面未完成的任务移到日志表（实现会签功能）
                if (completeTaskBo.getAuditStepFinish() != null && completeTaskBo.getAuditStepFinish()) {
                    UocOrderTaskInst UocOrderTaskInst = new UocOrderTaskInst();
                    UocOrderTaskInst.setOrderId(uocCommonDo.getOrderId());
                    UocOrderTaskInst.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
                    UocOrderTaskInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                    UocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                    deleteProcTaskInst(UocOrderTaskInst, finishTaskInfoBos);
                }
                //如果当前流程结束，同时是审批流，又是调价审批，则做以下操作
                if (null != completeTaskBo.getFinish() && completeTaskBo.getFinish()) {
                    if (completeTaskBo.getBusiObjType().equals(UocDicConstant.OBJ_TYPE.APPROVE) && completeTaskBo.getDealResult().equals(UocDicConstant.APPROVE_RESULT.APPROVED)) {
                        //查询审批对象相表，判断是否是调价审批
                        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                        selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                        selectuocApprovalObjQryBo.setOrderId(uocCommonDo.getOrderId());
                        List<UocApprovalObj> uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询审批任务对象表为空！");
                        }
//                        if (uocApprovalObjs.size() != 1) {
//                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询审批任务对象表数据不唯一！");
//                        }
                        if (UocConstant.OBJ_BUSI_TYPE.PRICE.equals(uocApprovalObjs.get(0).getObjBusiType())) {

                            //查询变更单对象表，拿到变更单id，做调价完成的金额更新操作。
                            UocChngOrderObjQryBo selectUocChngOrderObjQryBo = new UocChngOrderObjQryBo();
                            selectUocChngOrderObjQryBo.setOrderId(uocCommonDo.getOrderId());
                            selectUocChngOrderObjQryBo.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                            List<UocChngOrderObj> uocChngOrderObjs = this.uocChngOrderRepository.getListChngOrderObjWithOutItem(selectUocChngOrderObjQryBo);
                            if (CollectionUtils.isEmpty(uocChngOrderObjs)) {
                                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询变更单对象表为空！");
                            }
                            /*if (uocChngOrderObjs.size() != 1) {
                                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询变更单对象表数据不唯一！");
                            }*/
                            //如果有多条调价记录，则查最新的调价信息
                            log.debug("变更对象表集合：" + JSON.toJSONString(uocChngOrderObjs));
                            if (uocChngOrderObjs.size() > 1) {
                                uocChngOrderObjs.sort((m1, m2) -> m2.getCreateTime().compareTo(m1.getCreateTime()));
                            }
                            //做调价变更操作
                            UocChngOrderItemObjQryBo selectUocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
                            selectUocChngOrderItemObjQryBo.setChngOrderId(uocChngOrderObjs.get(0).getChngOrderId());
                            List<UocChngOrderItemObj> uocChngOrderItemObjList = this.uocChngOrderRepository.getListChngOrderItemObj(selectUocChngOrderItemObjQryBo);
                            if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
                                throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
                            }
                            // 修改销售单领域销售金额
                            this.updateSaleOrderDomainSalePrice(uocCommonDo.getOrderId(), Long.valueOf(uocApprovalObjs.get(0).getObjId()), uocChngOrderItemObjList);
                            // 修改订单领域销售金额
                            this.updateOrderDomainSalePrice(uocCommonDo.getOrderId(), uocChngOrderItemObjList);
                            if (null != uocChngOrderItemObjList.get(0).getChngPurchaseFee()) {
                                // 修改销售单领域采购金额
                                this.updateSaleOrderDomainPurchasePrice(uocCommonDo.getOrderId(), Long.valueOf(uocApprovalObjs.get(0).getObjId()), uocChngOrderItemObjList);
                                // 修改订单领域采购金额
                                this.updateOrderDomainPurchasePrice(uocCommonDo.getOrderId(), uocChngOrderItemObjList);
                            }
                        }
                        //协议订单审批通过，同时又是跳过发货和到货确认，则直接要生成发货单
                        if (UocConstant.OBJ_BUSI_TYPE.ORDER.equals(uocApprovalObjs.get(0).getObjBusiType())) {
                            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                            uocSaleOrderDo.setOrderId(uocCommonDo.getOrderId());
                            uocSaleOrderDo.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                            UocSaleOrderDo saleOrderDo =  iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
                            if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderDo.getOrderSource()) && 1 == saleOrderDo.getIsAgrIgnoreArrive() && !UocDicConstant.PURCHASE_MODE.PLAN.equals(saleOrderDo.getPurchaseMode())) {
                                this.createShipOrder(saleOrderDo);
                                //更新销售单状态为已到货
                                UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
                                updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_DH_DH);
                                updateSaleOrderDo.setOrderId(uocCommonDo.getOrderId());
                                updateSaleOrderDo.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                                uocSaleOrderRepository.modifySaleOrderMain(updateSaleOrderDo);
                            }
                        }
                    }
                    if (completeTaskBo.getBusiObjType().equals(UocDicConstant.OBJ_TYPE.APPROVE) && completeTaskBo.getDealResult().equals(UocDicConstant.APPROVE_RESULT.REJECT)) {
                        //查询审批对象相表，判断是否是订单审批
                        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                        selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                        selectuocApprovalObjQryBo.setOrderId(uocCommonDo.getOrderId());
                        List<UocApprovalObj> uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询审批任务对象表为空！");
                        }
//                        if (uocApprovalObjs.size() != 1) {
//                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "查询审批任务对象表数据不唯一！");
//                        }
                        if (UocConstant.OBJ_BUSI_TYPE.ORDER.equals(uocApprovalObjs.get(0).getObjBusiType())) {
                            //更新审批驳回原因
                            String dealRemark = completeTaskBo.getDealRemark();
                            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                            uocSaleOrderDo.setCancelReason(dealRemark);
                            uocSaleOrderDo.setCancelTime(new Date());
                            uocSaleOrderDo.setCancelOperName("系统自动");
                            uocSaleOrderDo.setCancelReasonFlag(UocConstant.CancelReasonFlag.APPROVE_CANCEL);
                            uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
                            uocSaleOrderDo.setOrderId(uocCommonDo.getOrderId());
                            uocSaleOrderDo.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                            uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
                        }
                    }
                }
            });
        }
        // 处理待办
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos = uocCommonDo.getNextTaskInfos();
        if (ObjectUtil.isNotEmpty(nextTaskInfos)) {
            List<UocOrderTaskDeal> saveDealList = new ArrayList<>();
            List<UocOrderTaskInst> saveList = new ArrayList<>();
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : nextTaskInfos) {
                //根据流程id查询流程是否存在，不存在创建
                UocOrderProcInst qryInst = new UocOrderProcInst();
                qryInst.setProcInstId(nextTaskInfo.getProcInstId());
                qryInst.setOrderId(uocCommonDo.getOrderId());
                List<UocOrderProcInst> uocOrderProcInsts = uocCommonRepository.qryProcInsList(qryInst);
                if (ObjectUtil.isEmpty(uocOrderProcInsts)) {
                    UocOrderProcInst createSaleProcIns = new UocOrderProcInst();
                    createSaleProcIns.setProcInstId(nextTaskInfo.getProcInstId());
                    createSaleProcIns.setOrderId(uocCommonDo.getOrderId());
                    createSaleProcIns.setProcDefId(nextTaskInfo.getProcDefId());
                    createSaleProcIns.setObjId(nextTaskInfo.getBusiObjId());
                    createSaleProcIns.setObjType(nextTaskInfo.getBusiObjType());
                    createSaleProcIns.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                    createSaleProcIns.setId(IdUtil.nextId());
                    createSaleProcIns.setCreateTime(new Date());
                    uocCommonRepository.createProInst(createSaleProcIns);
                }

                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(uocCommonDo.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskId());
                taskBo.setObjId(nextTaskInfo.getBusiObjId());
                taskBo.setObjType(nextTaskInfo.getBusiObjType());
                taskBo.setProcState(nextTaskInfo.getStepId());
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                taskBo.setFormUrl(nextTaskInfo.getFormUrl());
                taskBo.setProcDefId(nextTaskInfo.getProcDefId());
                taskBo.setProcInstId(nextTaskInfo.getProcInstId());
                taskBo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
                if (taskBo.getTaskSignTag() == null) {
                    // 默认为环节任务
                    taskBo.setTaskSignTag(UocDicConstant.TASK_SING_TAG.TACHE_TASK);
                }
                saveList.add(taskBo);

                String assignee = nextTaskInfo.getAssignee();
                List<UocCandidatesBO> candidates = nextTaskInfo.getCandidates();
                //处理人和候选人
                if (ObjectUtil.isNotEmpty(assignee)) {
                    UocOrderTaskDeal deal = assembleTaskDealObj(uocCommonDo, nextTaskInfo);
                    deal.setDealId(assignee);
                    deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.ASSIGNEE);
                    deal.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty(candidates)) {
                    for (UocCandidatesBO candidate : candidates) {
                        UocOrderTaskDeal deal = assembleTaskDealObj(uocCommonDo, nextTaskInfo);
                        deal.setDealId(candidate.getCandidateId());
                        deal.setDealName(candidate.getCandidateName());
                        //deal.setDealType(candidate.getCandidateType());
                        deal.setDealClass(UocDicConstant.TASK_DEAL_CLASS.CANDIDATE);
                        deal.setDelTag(UocDicConstant.DELETE_TAG.NO_DEL);
                        saveDealList.add(deal);
                    }
                }

                String state = uocInitConfig.getStateByTachecode(nextTaskInfo.getStepId(), nextTaskInfo.getBusiObjType());
                //环节，可能不变更状态，所以需要配置了状态才更新
                updateState(uocCommonDo, nextTaskInfo,state);


                /*//查出该实例下的所有待办环节，
                UocOrderTaskInst taskInst = new UocOrderTaskInst();
                taskInst.setOrderId(uocCommonDo.getOrderId());
                taskInst.setProcInstId(nextTaskInfo.getProcInstId());
                taskInst.setFinishTag(0);
                List<UocOrderTaskInst> taskInsts = uocCommonRepository.qryTaskInstList(taskInst);
                //将该实例下的所有待办置为已办
                uocCommonRepository.updateToFinished(taskInsts);*/
            }
            if (ObjectUtil.isNotEmpty(saveDealList)) {
                uocCommonRepository.saveOrderTaskDealList(saveDealList);
            }
            saveProcTaskInst(saveList);
        }
        // 处理前加签
        if (StringUtils.isNotBlank(uocCommonDo.getPreTaskId())) {
            UocOrderTaskInst UocOrderTaskInst = new UocOrderTaskInst();
            UocOrderTaskInst.setOrderId(uocCommonDo.getOrderId());
            UocOrderTaskInst.setTaskInstId(uocCommonDo.getPreTaskId());
            UocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            deleteProcTaskInst(UocOrderTaskInst, finishTaskInfoBos);
        }
        // 处理回退
        if (StringUtils.isNotBlank(uocCommonDo.getReturnTaskId())) {
            UocOrderTaskInst UocOrderTaskInst = new UocOrderTaskInst();
            UocOrderTaskInst.setOrderId(uocCommonDo.getOrderId());
            UocOrderTaskInst.setTaskInstId(uocCommonDo.getReturnTaskId());
            UocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            deleteProcTaskInst(UocOrderTaskInst, finishTaskInfoBos);
        }
        // 处理转签
        if (uocCommonDo.getUpdateTaskCandidate() != null && ObjectUtil.isNotEmpty(uocCommonDo.getUpdateTaskCandidate().getTaskId())) {
            UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
            UocCandidatesBO uocCandidatesBO = uocCommonDo.getUpdateTaskCandidate().getCandidates().get(0);
            uocOrderTaskDeal.setDealId(uocCandidatesBO.getCandidateId());
            uocOrderTaskDeal.setDealName(uocCandidatesBO.getCandidateName());
            uocOrderTaskDeal.setTaskInstId(uocCommonDo.getUpdateTaskCandidate().getTaskId());
            uocOrderTaskDeal.setOrderId(uocCommonDo.getOrderId());
            uocCommonRepository.updateTaskDeal(uocOrderTaskDeal);
        }
        // 处理撤回（删除掉，让页面查询不到）
        List<UocTaskBO> recallTaskInfos = uocCommonDo.getRecallTaskInfos();
        if (ObjectUtil.isNotEmpty(recallTaskInfos)) {
            log.info("订单处理撤回入参：{}", JSON.toJSONString(recallTaskInfos));
            for (UocTaskBO recallTaskInfo : recallTaskInfos) {
                if(ObjectUtil.isNotEmpty(recallTaskInfo.getTaskId())){
                    UocOrderTaskInst deleteBo = new UocOrderTaskInst();
                    deleteBo.setTaskInstId(recallTaskInfo.getTaskId());
                    uocCommonRepository.deleteTaskInstByTaskId(deleteBo);
                }
            }
        }
        UocCommonDo rsp = new UocCommonDo();
        rsp.setFinishTaskInfoBos(finishTaskInfoBos);
        this.buildSyncInfo(uocCommonDo, rsp);
        return rsp;
    }

    private void createShipOrder(UocSaleOrderDo saleOrderDo) {
        //生成发货单id
        Long shipOrderId = IdUtil.nextId();
        UocShipOrderDo createShipOrderDo = new UocShipOrderDo();
        //设置发货单状态
        createShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YSH);
        //设置发货人id
        createShipOrderDo.setShipOperId(saleOrderDo.getCreateOperId());
        //设置订单id
        createShipOrderDo.setOrderId(saleOrderDo.getOrderId());
        //设置销售单id
        createShipOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        //设置发货单创建人
        createShipOrderDo.setCreateOperId(saleOrderDo.getCreateOperId());
        //设置发货单创建时间
        createShipOrderDo.setCreateTime(new Date());
        //设置发货单id
        createShipOrderDo.setShipOrderId(shipOrderId);
        //设置发货单编号
        createShipOrderDo.setShipOrderNo(this.getShipOrderNo());
        //到货时间
        createShipOrderDo.setArriveTime(new Date());
        createShipOrderDo.setReceiverTime(new Date());
        createShipOrderDo.setShipTime(new Date());
        createShipOrderDo.setEstimateArrivalTime(new Date());
        //查询销售明细用于生成发货单列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(saleOrderDo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(saleOrderDo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        updateSaleOrderDo.setSaleOrderItems(saleOrderItems);
        //设置发货单明细
        List<UocShipOrderItem> shipOrderItemBoList = new ArrayList<>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            //设置发货单id
            uocShipOrderItem.setShipOrderId(shipOrderId);
            //设置订单id
            uocShipOrderItem.setOrderId(saleOrderDo.getOrderId());
            //设置销售单id
            uocShipOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            //设置销售单明细id
            uocShipOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            //设置计量单位
            uocShipOrderItem.setUnitName(saleOrderItem.getUnitName());
            //设置创建人id
            uocShipOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            //设置创建时间
            uocShipOrderItem.setCreateTime(new Date());
            //设置发货单明细id
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
            //发货数量
            uocShipOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            //到货数量
            uocShipOrderItem.setArriveCount(saleOrderItem.getPurchaseCount());
            shipOrderItemBoList.add(uocShipOrderItem);
            saleOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            saleOrderItem.setArriveCount(saleOrderItem.getPurchaseCount());
            //更新到货数量
            this.iUocSaleOrderModel.modifySaleOrderItemAfterServingCount(saleOrderItem);
        }
        //设置发货明细
        createShipOrderDo.setShipOrderItemBoList(shipOrderItemBoList);
        //设置供应商id
        createShipOrderDo.setSupNo(saleOrderItems.get(0).getSupplierId());
        //生产发货单
        this.iUocShipOrderModel.createShipOrder(createShipOrderDo);
        //更新销售明细发货数量
        this.iUocSaleOrderModel.modifyBatchItemSendCount(updateSaleOrderDo);
    }

    private String getShipOrderNo() {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(UocDicConstant.ORDER_SOURCE.AGR_GENERATE);
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        if (null != uocShipOrderDo) {
            return uocShipOrderDo.getShipOrderNo();
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "生成发货单编号失败");
        }
    }

    /**
     * 组装es同步信息
     *
     * @param uocCommonDo
     * @param rsp
     */
    private void buildSyncInfo(UocCommonDo uocCommonDo, UocCommonDo rsp) {
        //同步销售单集合
        List<UocEsSyncBO> syncSaleOrderList = new ArrayList<>();
        //同步变更单集合
        List<UocEsSyncBO> syncChngOrderList = new ArrayList<>();
        //同步发货单集合
        List<UocEsSyncBO> syncShipOrderList = new ArrayList<>();
        //同步验收单集合
        List<UocEsSyncBO> syncInspOrderList = new ArrayList<>();
        //同步售后单集合
        List<UocEsSyncBO> syncAfterOrderList = new ArrayList<>();
        //已完成任务
        if (ObjectUtil.isNotEmpty(uocCommonDo.getCompleteTaskInfos())) {
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo bo : uocCommonDo.getCompleteTaskInfos()) {
                UocOrderTaskInst qryInst = new UocOrderTaskInst();
                //qryInst.setOrderId(uocCommonDo.getOrderId());
                qryInst.setTaskInstId(bo.getTaskId());
                List<UocOrderTaskInst> uocOrderTaskInsts = uocCommonRepository.qryTaskInstList(qryInst);
                if (uocOrderTaskInsts.size() != 1) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "流程任务数据查询错误！");
                }
                if (UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    //查询审批单对象表
                    UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                    selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                    selectuocApprovalObjQryBo.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    List<UocApprovalObj> uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                    UocEsSyncBO saleEsSyncBO = new UocEsSyncBO();
                    saleEsSyncBO.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                    saleEsSyncBO.setOrderId(uocApprovalObjs.get(0).getOrderId());
                    syncSaleOrderList.add(saleEsSyncBO);
                    //查询发货单，兼容协议订单直接跳过发货，到货确认的模式
                    UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                    uocShipOrderQryBo.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                    uocShipOrderQryBo.setOrderId(uocApprovalObjs.get(0).getOrderId());
                    List<UocShipOrderDo> shipOrderDos = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
                    if (!CollectionUtils.isEmpty(shipOrderDos)) {
                        for (UocShipOrderDo shipOrderDo : shipOrderDos) {
                            UocEsSyncBO shipEsSyncBO = new UocEsSyncBO();
                            shipEsSyncBO.setShipOrderId(shipOrderDo.getShipOrderId());
                            shipEsSyncBO.setOrderId(shipOrderDo.getOrderId());
                            syncShipOrderList.add(shipEsSyncBO);
                        }
                    }
                }
            }
        }
        //待办任务
        if (ObjectUtil.isNotEmpty(uocCommonDo.getNextTaskInfos())) {
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo bo : uocCommonDo.getNextTaskInfos()) {
                UocOrderTaskInst qryInst = new UocOrderTaskInst();
                //qryInst.setOrderId(uocCommonDo.getOrderId());
                qryInst.setTaskInstId(bo.getTaskId());
                log.info("待办任务查询参数：" + JSON.toJSONString(qryInst));
                List<UocOrderTaskInst> uocOrderTaskInsts = uocCommonRepository.qryTaskInstList(qryInst);
                log.info("待办任务查询结果：" + JSON.toJSONString(uocOrderTaskInsts));
                if (uocOrderTaskInsts.size() != 1) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "流程任务数据查询错误！");
                }
                if (UocDicConstant.OBJ_TYPE.SALE.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO saleEsSyncBO = new UocEsSyncBO();
                    saleEsSyncBO.setSaleOrderId(uocOrderTaskInsts.get(0).getObjId());
                    saleEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncSaleOrderList.add(saleEsSyncBO);
                }
                if (UocDicConstant.OBJ_TYPE.CHNG.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO chngEsSyncBO = new UocEsSyncBO();
                    chngEsSyncBO.setChngOrderId(uocOrderTaskInsts.get(0).getObjId());
                    chngEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncChngOrderList.add(chngEsSyncBO);
                }
                if (UocDicConstant.OBJ_TYPE.SHIP.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO shipEsSyncBO = new UocEsSyncBO();
                    shipEsSyncBO.setShipOrderId(uocOrderTaskInsts.get(0).getObjId());
                    shipEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncShipOrderList.add(shipEsSyncBO);
                    //查询发货单，更新销售单
                    UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                    uocShipOrderQryBo.setShipOrderId(uocOrderTaskInsts.get(0).getObjId());
                    uocShipOrderQryBo.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    List<UocShipOrderDo> shipOrderDos = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
                    if (!CollectionUtils.isEmpty(shipOrderDos)) {
                        UocEsSyncBO saleEsSyncBO = new UocEsSyncBO();
                        saleEsSyncBO.setSaleOrderId(shipOrderDos.get(0).getSaleOrderId());
                        saleEsSyncBO.setOrderId(shipOrderDos.get(0).getOrderId());
                        syncSaleOrderList.add(saleEsSyncBO);
                    }
                }
                if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO inspEsSyncBO = new UocEsSyncBO();
                    inspEsSyncBO.setInspOrderId(uocOrderTaskInsts.get(0).getObjId());
                    inspEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncInspOrderList.add(inspEsSyncBO);
                }
                if (UocDicConstant.OBJ_TYPE.AFTER.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO afterEsSyncBO = new UocEsSyncBO();
                    afterEsSyncBO.setAfterOrderId(uocOrderTaskInsts.get(0).getObjId());
                    afterEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncAfterOrderList.add(afterEsSyncBO);
                }
                if (UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    //查询审批单对象表
                    UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                    selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                    selectuocApprovalObjQryBo.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    List<UocApprovalObj> uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                    UocEsSyncBO saleEsSyncBO = new UocEsSyncBO();
                    saleEsSyncBO.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                    saleEsSyncBO.setOrderId(uocApprovalObjs.get(0).getOrderId());
                    syncSaleOrderList.add(saleEsSyncBO);
                }
            }
        }
        //转签任务
        if (null != uocCommonDo.getUpdateTaskCandidate() && StringUtils.isNotBlank(uocCommonDo.getUpdateTaskCandidate().getTaskId())) {
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            //qryInst.setOrderId(uocCommonDo.getOrderId());
            qryInst.setTaskInstId(uocCommonDo.getUpdateTaskCandidate().getTaskId());
            List<UocOrderTaskInst> uocOrderTaskInsts = uocCommonRepository.qryTaskInstList(qryInst);
            if (uocOrderTaskInsts.size() != 1) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_TASK_COMMIT_ERROR, "流程任务数据查询错误！");
            }
            if (UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInsts.get(0).getObjType())) {
                //查询审批单对象表
                UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                selectuocApprovalObjQryBo.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                List<UocApprovalObj> uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                UocEsSyncBO saleEsSyncBO = new UocEsSyncBO();
                saleEsSyncBO.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                saleEsSyncBO.setOrderId(uocApprovalObjs.get(0).getOrderId());
                syncSaleOrderList.add(saleEsSyncBO);
            }
        }
        rsp.setSyncSaleOrderList(syncSaleOrderList);
        rsp.setSyncChngOrderList(syncChngOrderList);
        rsp.setSyncShipOrderList(syncShipOrderList);
        rsp.setSyncInspOrderList(syncInspOrderList);
        rsp.setSyncAfterOrderList(syncAfterOrderList);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInst(UocOrderTaskInst uocOrderTaskInst) {
        return uocCommonRepository.qryTaskInstList(uocOrderTaskInst);

    }

    /**
     * 修改订单领域采购金额
     *
     * @param orderId
     * @param uocChngOrderItemObjList
     */
    private void updateOrderDomainPurchasePrice(Long orderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(orderId);
        List<UocOrderItem> orderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocOrderItem uocOrderItem = new UocOrderItem();
                uocOrderItem.setOrderId(orderId);
                uocOrderItem.setOrderItemId(uocChngOrderItemObj.getOrderItemId());
                uocOrderItem.setPurchasePrice(uocChngOrderItemObj.getChngPurchaseFee());
                uocOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderItem.setUpdateTime(updateTime);
                orderItems.add(uocOrderItem);

                uocOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(orderItems)) {
            uocOrderDo.setOrderItems(orderItems);
            // 修改订单单明细采购金额
            uocOrderRepository.modifyBatchItemPurchasePrice(uocOrderDo);
            // 统计订单明细采购价总金额
            UocOrderDo uocOrderDo2 = new UocOrderDo();
            uocOrderDo2.setOrderId(uocOrderDo.getOrderId());
            UocOrderDo uocOrderDo4 = uocOrderRepository.getOrderItemTotalPrice(uocOrderDo2);
            // 更新订单采购金额
            UocOrderDo uocOrderDo3 = new UocOrderDo();
            uocOrderDo3.setOrderId(uocOrderDo.getOrderId());
            uocOrderDo3.setTotalPurchaseFee(uocOrderDo4.getTotalPurchaseFee());
            uocOrderDo3.setUpdateOperId(uocOrderDo.getUpdateOperId());
            uocOrderDo3.setUpdateTime(uocOrderDo.getUpdateTime());
            uocOrderRepository.modifyOrderMain(uocOrderDo3);
        }
    }

    /**
     * 修改销售单领域采购金额
     *
     * @param orderId
     * @param saleOrderId
     * @param uocChngOrderItemObjList
     */
    private void updateSaleOrderDomainPurchasePrice(Long orderId, Long saleOrderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(orderId);
                uocSaleOrderItem.setSaleOrderId(saleOrderId);
                uocSaleOrderItem.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItem.setPurchasePrice(uocChngOrderItemObj.getChngPurchaseFee());
                uocSaleOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderItem.setUpdateTime(updateTime);
                saleOrderItems.add(uocSaleOrderItem);
                uocSaleOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(saleOrderItems)) {
            uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
            // 修改销售单明细采购金额
            uocSaleOrderRepository.modifyBatchItemPurchasePrice(uocSaleOrderDo);
            // 统计销售单明细采购价总金额
            UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
            uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo4 = uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
            // 更新销售单采购金额
            UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
            uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            uocSaleOrderDo3.setTotalPurchaseFee(uocSaleOrderDo4.getTotalPurchaseFee());
            uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
            uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
            uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
            //更新运营方支付配置里面的应付金额
            this.updatePayConfMoney(uocSaleOrderDo4.getTotalPurchaseFee(), uocSaleOrderDo.getOrderId(), uocSaleOrderDo.getSaleOrderId(), UocDicConstant.USE_TYPE.PRO);
        }
    }

    /**
     * 修改订单领域销售金额
     *
     * @param orderId
     * @param uocChngOrderItemObjList
     */
    private void updateOrderDomainSalePrice(Long orderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(orderId);
        List<UocOrderItem> orderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocOrderItem uocOrderItem = new UocOrderItem();
                uocOrderItem.setOrderId(orderId);
                uocOrderItem.setOrderItemId(uocChngOrderItemObj.getOrderItemId());
                uocOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
                uocOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderItem.setUpdateTime(updateTime);
                orderItems.add(uocOrderItem);

                uocOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(orderItems)) {
            uocOrderDo.setOrderItems(orderItems);
            // 修改订单单明细销售金额
            uocOrderRepository.modifyBatchItemSalePrice(uocOrderDo);
            // 统计订单明细销售价总金额
            UocOrderDo uocOrderDo2 = new UocOrderDo();
            uocOrderDo2.setOrderId(uocOrderDo.getOrderId());
            UocOrderDo uocOrderDo4 = uocOrderRepository.getOrderItemTotalPrice(uocOrderDo2);
            // 更新订单销售金额
            UocOrderDo uocOrderDo3 = new UocOrderDo();
            uocOrderDo3.setOrderId(uocOrderDo.getOrderId());
            uocOrderDo3.setTotalSaleFee(uocOrderDo4.getTotalSaleFee());
            uocOrderDo3.setUpdateOperId(uocOrderDo.getUpdateOperId());
            uocOrderDo3.setUpdateTime(uocOrderDo.getUpdateTime());
            uocOrderRepository.modifyOrderMain(uocOrderDo3);
        }
    }

    /**
     * 修改销售单领域销售金额
     *
     * @param orderId
     * @param saleOrderId
     * @param uocChngOrderItemObjList
     */
    private void updateSaleOrderDomainSalePrice(Long orderId, Long saleOrderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(orderId);
                uocSaleOrderItem.setSaleOrderId(saleOrderId);
                uocSaleOrderItem.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
                uocSaleOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderItem.setUpdateTime(updateTime);
                saleOrderItems.add(uocSaleOrderItem);
                uocSaleOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(saleOrderItems)) {
            uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
            // 修改销售单明细销售金额
            uocSaleOrderRepository.modifyBatchItemSalePrice(uocSaleOrderDo);
            // 统计销售单明细销售价总金额
            UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
            uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo4 = uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
            // 更新销售单销售金额
            UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
            uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            uocSaleOrderDo3.setTotalSaleFee(uocSaleOrderDo4.getTotalSaleFee());
            uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
            uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
            uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
            //更新采购方支付配置里面的应付金额
            this.updatePayConfMoney(uocSaleOrderDo4.getTotalSaleFee(), uocSaleOrderDo.getOrderId(), uocSaleOrderDo.getSaleOrderId(), UocDicConstant.USE_TYPE.PUR);
        }
    }

    /**
     * 更新采购方支付配置里面的应付金额
     *
     * @param totalSaleFee
     * @param orderId
     * @param saleOrderId
     */
    private void updatePayConfMoney(BigDecimal totalSaleFee, Long orderId, Long saleOrderId, Integer userType) {
        //查询支付配置
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(orderId);
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderPayConfQryBo.setUserType(userType);
        List<UocSaleOrderPayConf> saleOrderPayConfList = uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (ObjectUtil.isEmpty(saleOrderPayConfList)) {
            //throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "查询销售单支付配置未空！");
            //撮合模式无该记录，撮合模式采购价=销售价
            return;
        }
        if (saleOrderPayConfList.size() != 1) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "查询销售单支付配置有多条！");
        }
        UocSaleOrderPayConf payConf = saleOrderPayConfList.get(0);
        if (UocDicConstant.PAY_NODE_RULE.INVOICE_RECEIPT_BEGIN_CALCULATE.equals(payConf.getPayNodeRule()) || UocDicConstant.PAY_NODE_RULE.INVOICE_RECEIPT_BEGIN_CALCULATE.equals(payConf.getPayRule())) {
            return;
        }
        if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
            //预付款，全给
            payConf.setPrePayFee(totalSaleFee);
        } else if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
            //按协议，根据比例
            if (ObjectUtil.isNotEmpty(payConf.getPrePaySup())) {
                payConf.setPrePayFee(totalSaleFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
            }
            if (ObjectUtil.isNotEmpty(payConf.getVerPaySup())) {
                payConf.setVerPayFee(totalSaleFee.multiply(payConf.getVerPaySup()));
            }
            if (ObjectUtil.isNotEmpty(payConf.getPilPaySup())) {
                payConf.setPilPayFee(totalSaleFee.multiply(payConf.getPilPaySup()));
            }
            if (ObjectUtil.isNotEmpty(payConf.getQuaPaySup())) {
                payConf.setQuaPayFee(totalSaleFee.multiply(payConf.getQuaPaySup()));
            }
        } else {
            //账期，下单时都不付
            //判断账期是到货付款还是验收付款
            if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
                //到货款
                if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                    payConf.setVerPayFee(totalSaleFee);
                    //验收款
                } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                    payConf.setPilPayFee(totalSaleFee);
                }
            } else {
                //到货款
                if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
                    payConf.setVerPayFee(totalSaleFee);
                    //验收款
                } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) {
                    payConf.setPilPayFee(totalSaleFee);
                }
            }
        }
        int isUpdate = this.uocSaleOrderRepository.updateSaleOrderPayConfMoney(payConf);
        if (isUpdate != 1) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "更新支付配置表应付金额失败！");
        }
    }

    /**
     * 移除任务表的未处理任务
     */
    private void deleteProcTaskInst(UocOrderTaskInst UocOrderTaskInst, List<UocFinishTaskInfoBo> finishTaskInfoBos) {
        // 查询未完成的任务
        List<UocOrderTaskInst> taskInsts = uocCommonRepository.qryTaskInstList(UocOrderTaskInst);
        if (!CollectionUtils.isEmpty(taskInsts)) {
            // 保存未完成的任务到任务历史表
            uocCommonRepository.saveProcTaskInstLog(taskInsts);
            List<Long> ids = new ArrayList<>();
            taskInsts.forEach(uocOrderTaskInst -> ids.add(uocOrderTaskInst.getId()));
            // 删除为完成的任务
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setOrderId(UocOrderTaskInst.getOrderId());
            uocOrderTaskInst.setIds(ids);
            uocCommonRepository.deleteProcTaskInstByIds(uocOrderTaskInst);
            // 组装已办信息
            taskInsts.forEach(uocOrderTaskInst1 -> {
                UocFinishTaskInfoBo bo = new UocFinishTaskInfoBo();
                bo.setProcInstId(uocOrderTaskInst1.getProcInstId());
                bo.setTaskId(uocOrderTaskInst1.getTaskInstId());
                bo.setBusiObjId(uocOrderTaskInst1.getObjId());
                bo.setBusiObjType(uocOrderTaskInst1.getObjType());
                bo.setDealResult(uocOrderTaskInst1.getDealResult());
                bo.setDealRemark(uocOrderTaskInst1.getDealRemark());
                bo.setDealOperId(uocOrderTaskInst1.getDealOperId());
                bo.setDealOperName(uocOrderTaskInst1.getDealOperName());
                bo.setCenter("UOC");
                finishTaskInfoBos.add(bo);
            });

        }
    }


    private void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }


    /**
     * 描述:对象创建
     *
     * @param uocCommonDo, nextTaskInfo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal
     * @author tgy
     * @date 2022/3/3 17:31
     */
    private UocOrderTaskDeal assembleTaskDealObj(UocCommonDo uocCommonDo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskId());
        deal.setOrderId(uocCommonDo.getOrderId());
        deal.setObjId(nextTaskInfo.getBusiObjId());
        deal.setObjType(nextTaskInfo.getBusiObjType());
        return deal;
    }


    private void updateState(UocCommonDo uocCommonDo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo, String state) {
        //环节，可能不变更状态，所以需要配置了状态才更新
        if (ObjectUtil.isNotEmpty(state)) {
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(taskBo.getBusiObjType())) {
                //更新销售单状态和环节编码
                UocShipOrderDo updateShipDo = new UocShipOrderDo();
                updateShipDo.setUpdateOperId(Convert.toStr(uocCommonDo.getUserId()));
                updateShipDo.setOrderId(uocCommonDo.getOrderId());
                updateShipDo.setShipOrderId(taskBo.getBusiObjId());
                updateShipDo.setShipOrderState(state);
                if (null != taskBo.getFinish() && taskBo.getFinish()) {
                    updateShipDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
                }
                updateShipStatusAndProCode(updateShipDo);
            }
            if (UocDicConstant.OBJ_TYPE.SALE.equals(taskBo.getBusiObjType())) {
                //更新销售单状态和环节编码
                UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
                updateSaleDo.setUpdateOperId(Convert.toStr(uocCommonDo.getUserId()));
                updateSaleDo.setOrderId(uocCommonDo.getOrderId());
                updateSaleDo.setSaleOrderId(taskBo.getBusiObjId());
                updateSaleDo.setSaleOrderState(state);
                updateSaleStatusAndProCode(updateSaleDo);
            }
            if (UocDicConstant.OBJ_TYPE.CHNG.equals(taskBo.getBusiObjType())) {
                //更新销售单状态和环节编码
                UocChngOrderDo updateChngDo = new UocChngOrderDo();
                updateChngDo.setUpdateOperId(Convert.toStr(uocCommonDo.getUserId()));
                updateChngDo.setOrderId(uocCommonDo.getOrderId());
                updateChngDo.setChngOrderId(taskBo.getBusiObjId());
                updateChngDo.setChngOrderState(state);
                updateShipStatusAndProCode(updateChngDo);
            }
            if (UocDicConstant.OBJ_TYPE.AFTER.equals(taskBo.getBusiObjType())) {
                //更新售后单状态和环节编码
                UocAfOrderDo updateAfOrderDo = new UocAfOrderDo();
                updateAfOrderDo.setAfOrderId(taskBo.getBusiObjId());
                updateAfOrderDo.setServState(Integer.valueOf(state));
                updateAfOrderDo.setOrderId(uocCommonDo.getOrderId());
                updateAfOrderDo.setUpdateOperId(Convert.toStr(uocCommonDo.getUserId()));
                updateAfStatusAndProCode(updateAfOrderDo);
            }
        }
    }

    /**
     * 更新售后单状态和环节编码
     *
     * @param updateAfOrderDo
     */
    private void updateAfStatusAndProCode(UocAfOrderDo updateAfOrderDo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(updateAfOrderDo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(updateAfOrderDo.getOrderId());
        UocAfOrder result = this.uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
        if (ObjectUtil.isEmpty(result)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_UPDATE_STATE_ERROR, "该售后单" + updateAfOrderDo.getAfOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(updateAfOrderDo.getAfOrderId());
        uocOrderStateChgLog.setOrderId(updateAfOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderStateChgLog.setOldState(result.getServState().toString());
        uocOrderStateChgLog.setNewState(updateAfOrderDo.getServState().toString());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(updateAfOrderDo.getUpdateOperId());

        //调用通用repository，创建状态变更日志
        uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        //更新状态
        this.uocAfOrderRepository.modifyAfOrderState(updateAfOrderDo);
    }

    private void updateShipStatusAndProCode(UocChngOrderDo uocChngOrderDo) {
        UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
        qryBo.setOrderId(uocChngOrderDo.getOrderId());
        qryBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        UocChngOrderDo chngOrderDo = uocChngOrderRepository.getChngOrder(qryBo);
        if (ObjectUtil.isEmpty(chngOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_UPDATE_STATE_ERROR, "该变更单" + uocChngOrderDo.getChngOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocChngOrderDo.getChngOrderId());
        uocOrderStateChgLog.setOrderId(uocChngOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
        uocOrderStateChgLog.setOldState(chngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setNewState(uocChngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocChngOrderDo.getUpdateOperId());

        //调用通用repository，创建状态变更日志
        uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        //更新状态
        uocChngOrderRepository.updateChngStatusAndProCode(uocChngOrderDo);
    }


    private UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        validateUpdateSaleOrderArg(reqBo);
        //查询销售单修改前状态
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty(uocSaleOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_UPDATE_STATE_ERROR, "该销售单" + reqBo.getSaleOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());

        //调用通用repository，创建状态变更日志
        uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);

        //更新销售单数据
        return uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocUpdateSaleOrderStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUpdateOperId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【更新人id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单状态】不能为空");
        }
    }

    private UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (null == uocSaleOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    private void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(uocShipOrderDo.getOrderId());
        qryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderDo = getShipOrderById(qryBo);
        if (ObjectUtil.isEmpty(shipOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SHIP_UPDATE_STATE_ERROR, "该发货单" + uocShipOrderDo.getShipOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocShipOrderDo.getShipOrderId());
        uocOrderStateChgLog.setOrderId(uocShipOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        uocOrderStateChgLog.setOldState(shipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setNewState(uocShipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocShipOrderDo.getUpdateOperId());

        //调用通用repository，创建状态变更日志
        uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        //更新状态
        uocShipOrderRepository.updateShipStatusAndProCode(uocShipOrderDo);
    }

    private UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        if (null == uocShipOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocShipOrderQryBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        return uocShipOrderRepository.getShipOrderById(uocShipOrderQryBo);
    }

    @Override
    public int saveTodoInfo(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocTodo.getTodoId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参待办ID不能为空");
        }
        if (null == uocTodo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocTodo.getBusiId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参业务ID不能为空");
        }

        return uocCommonRepository.saveTodoInfo(uocTodo);
    }

    @Override
    public int updateTodoById(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocTodo.getTodoId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参待办ID不能为空");
        }
        return uocCommonRepository.updateTodoById(uocTodo);
    }

    @Override
    public UocTodo getTodoInfo(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocCommonRepository.getTodoInfo(uocTodo);
    }

    @Override
    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        return uocCommonRepository.getTodoListInfo(uocTodo);
    }

    @Override
    public void insertBatchTodo(List<UocTodo> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象列表不能为空");
        }
        for (UocTodo uocTodo : list) {
            if (null == uocTodo.getTodoId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参待办ID不能为空");
            }
            if (null == uocTodo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID不能为空");
            }
            if (null == uocTodo.getBusiId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参业务ID不能为空");
            }
        }
        uocCommonRepository.insertBatchTodo(list);
    }

    @Override
    public UocCfcParamConfigDo qryCfcParamByCode(String paramCode) {
        return uocCommonRepository.qryCfcParamByCode(paramCode);
    }

    @Override
    public UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo) {
        UocCfcParamConfigItemDo updateItemDo = new UocCfcParamConfigItemDo();
        updateItemDo.setItemId(reqDo.getItemId());
        updateItemDo.setItemValue(reqDo.getItemValue());
        updateItemDo.setCreateTime(new Date());
        updateItemDo.setCreateId(reqDo.getCreateId());
        updateItemDo.setCreateName(reqDo.getCreateName());
        uocCommonRepository.updateCfcItemValue(updateItemDo);
        return reqDo;
    }

    @Override
    public UocQryMateriaOrderNoBo qryMateriaBySkuIdAndUserId(UocQryMateriaOrderNoBo qryBo) {
        return uocCommonRepository.qryMateriaBySkuIdAndUserId(qryBo);
    }

    @Override
    public UocQrySaleOrderStageBO qrySaleOrderStageByOrderStateAndprocState(UocQrySaleOrderStageBO qryBo) {
        return uocCommonRepository.qrySaleOrderStageByOrderStateAndprocState(qryBo);
    }


    @Override
    public UocQryStateCalculatorBo qryUocStateCalculatorServerConfig(String callServerClassName) {
        return uocCommonRepository.qryUocStateCalculatorServerConfig(callServerClassName);
    }

    @Override
    public UocQryOrderStateChngLogBo qryUocLastChngStateByObjId(UocQryOrderStateChngLogBo qryBo) {
        return uocCommonRepository.qryUocLastChngStateByObjId(qryBo);
    }


    @Override
    public UocOutLogSaveDo saveOutLog(UocOutLogSaveDo reqDo) {
        return uocCommonRepository.saveOutLog(reqDo);
    }

    @Override
    public UocQryInspItemsServiceRspBo qryInspItems(UocQryInspItemsServiceReqBo reqBo) {
        return uocCommonRepository.qryInspItems(reqBo);
    }

    /**
     * 处理在线支付发货单信息
     */
    @Override
    public void dealPayShipOrderInfo(UocShipOrderDo shipOrderDo) {
        //定义销售单主体查询参数
        UocSaleOrderDo qryUocSaleOrderDo = new UocSaleOrderDo();
        //设置销售单ID
        qryUocSaleOrderDo.setSaleOrderId(shipOrderDo.getSaleOrderId());

        //调用销售单模型层，查询销售单主体
        UocSaleOrderDo saleOrderDo =  this.iUocSaleOrderModel.getSaleOrderMain(qryUocSaleOrderDo);

        //判断下单类型为虚拟订单
        if (UocConstant.PLACE_AN_ORDER_TYPE.VIRTUAL.equals(saleOrderDo.getPlaceAnOrderType())) {
            //调用创建发货单
            this.createShipOrder(saleOrderDo);

            //定义销售单主体更新参数
            UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
            //设置销售单状态为已到货
            updateUocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_DH_DH);
            //设置订单ID
            updateUocSaleOrderDo.setOrderId(saleOrderDo.getOrderId());
            //设置销售单ID
            updateUocSaleOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());

            //调用销售单模型层，更新销售单主体
            this.uocSaleOrderRepository.modifySaleOrderMain(updateUocSaleOrderDo);
        }
    }

    /**
     * 处理在线支付销售单信息
     */
    @Override
    public void dealPaySaleOrderInfo(UocSaleOrderDo uocSaleOrderDo) {
        //定义销售单主体查询参数
        UocSaleOrderDo qryUocSaleOrderDo = new UocSaleOrderDo();
        //设置销售单ID
        qryUocSaleOrderDo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());

        //调用销售单模型层，查询销售单主体
        UocSaleOrderDo saleOrderDo =  this.iUocSaleOrderModel.getSaleOrderMain(qryUocSaleOrderDo);

        //判断下单类型为虚拟订单
        if (UocConstant.PLACE_AN_ORDER_TYPE.VIRTUAL.equals(saleOrderDo.getPlaceAnOrderType())) {
            //定义销售单主体更新参数
            UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
            //设置销售单状态为待发货
            updateUocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_DFH);
            //设置订单ID
            updateUocSaleOrderDo.setOrderId(saleOrderDo.getOrderId());
            //设置销售单ID
            updateUocSaleOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());

            //调用销售单模型层，更新销售单主体
            this.uocSaleOrderRepository.modifySaleOrderMain(updateUocSaleOrderDo);
        }
    }

    @Override
    public UocQueryAlertStatisticsRspBO queryAlertStatistics(UocQueryAlertStatisticsReqBO reqBO) {
        return uocCommonRepository.queryAlertStatistics(reqBO);
    }
}
