package com.tydic.dyc.oc.model.saleorder.sub;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:sap收货消息
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/7/15 下午4:57
 */
@Data
public class SapArrivalInspInfo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * sap收货信息id
	 */
    private Long inspInfoId;
	/**
	 * sap订单编号
	 */
    private String sapOrderNo;
	/**
	 * sap订单明细编号
	 */
    private String sapOrderItemNo;
	/**
	 * 计划验收数量
	 */
    private BigDecimal planInspCount;
	/**
	 * 验收数量
	 */
    private BigDecimal inspCount;
	/**
	 * 验收人名称
	 */
    private String inspOperName;
	/**
	 * 0：未处理 1：已处理
	 */
    private Integer status;
	/**
	 * 物料凭证编号
	 */
    private String sapVoucherNo;
	/**
	 * 物料凭证中的项目
	 */
    private String sapVoucherItemNo;
	/**
	 * 物料编码
	 */
    private String materialCode;
	/**
	 * 验收日期
	 */
    private String inspTime;
	/**
	 * 验收备注
	 */
    private String inspRemark;
	/**
	 * 能力平台能力名
	 */
    private String platformName;
	/**
	 * 能力平台流水号
	 */
    private String platformNo;
	/**
	 * 创建时间
	 */
    private Date createTime;
	/**
	 * 更新时间
	 */
    private Date updateTime;

}