package com.tydic.dyc.oc.model.snaporder.impl;

import com.tydic.dyc.oc.model.snaporder.IUocSnapOrderModel;
import com.tydic.dyc.oc.model.snaporder.UocSnapOrderDo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderItemSameQryListReqBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderItemSameQryListRspBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListReqBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListRspBo;
import com.tydic.dyc.oc.repository.UocSnapOrderRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class IUocSnapOrderModelImpl implements IUocSnapOrderModel {

    /**
     * 快照订基建服务
     */
    @Autowired
    private UocSnapOrderRepository uocSnapOrderRepository;

    /**
     * 创建快照单
     */
    @Override
    public void createSnapOrder(UocSnapOrderDo uocSnapOrderDo) {
        //调用快照订基建服务，创建快照单
        this.uocSnapOrderRepository.createSnapOrder(uocSnapOrderDo);
    }

    /**
     * 订单快照列表分页查询
     */
    @Override
    public UocSnapshotOrderQryListRspBo qryUocSnapshotOrderList(UocSnapshotOrderQryListReqBo reqBo) {
        //调用快照订基建服务，订单快照列表分页查询
        return this.uocSnapOrderRepository.qryUocSnapshotOrderList(reqBo);
    }

    /**
     * 订单快照同款商品列表分页查询
     */
    @Override
    public UocSnapshotOrderItemSameQryListRspBo qryUocSnapshotOrderItemSameList(UocSnapshotOrderItemSameQryListReqBo reqBo) {
        //调用快照订基建服务，订单快照同款商品列表分页查询
        return this.uocSnapOrderRepository.qryUocSnapshotOrderItemSameList(reqBo);
    }
}
