package com.tydic.dyc.oc.model.snaporder.sub;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：快照销售订单明细
 **/
@Data
public class UocSnapSaleOrderItem implements Serializable {

	private static final long serialVersionUID =  -4247840967484370396L;

	/**
	 * 快照明细ID
	 */
	private Long snapshotItemId;

	/**
	 * 快照ID
	 */
	private Long snapshotId;

	/**
	 * 单品ID
	 */
	private Long skuId;

	/**
	 * 单品编码
	 */
	private String skuCode;

	/**
	 * 单品名称
	 */
	private String skuName;

	/**
	 * 单品图片URL
	 */
	private String skuPicUrl;

	/**
	 * 协议价
	 */
	private BigDecimal salePrice;

	/**
	 * 推送价
	 */
	private BigDecimal marketPrice;

	/**
	 * 数量
	 */
	private BigDecimal purchaseCount;

	/**
	 * 商品总金额
	 */
	private BigDecimal commodityTotalFee;

	/**
	 * 商品69码
	 */
	private String upcCode;

	/**
	 * 第三方指导价
	 */
	private BigDecimal tripartitePrice;

	/**
	 * 官网价
	 */
	private BigDecimal officialPrice;

	/**
	 * 供应商ID
	 */
	private String supplierId;

	/**
	 * 供应商名称
	 */
	private String supplierName;

	/**
	 * 店铺ID
	 */
	private String supplierShopId;

	/**
	 * 是否同款最低价 1是 0否
	 */
	private Integer isLowPrice;

	/**
	 * 是否存在同款 1是 0否
	 */
	private Integer isExistSame;

	/**
	 * 最近一次变价时间
	 */
	private Date latestPriceTime;

	/**
	 * 快照销售订单明细同款集合
	 */
	private List<UocSnapSaleOrderItemSame> uocSnapSaleOrderItemSameList;

}
