package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderCreateTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.*;

/**
 * 描述: 〈领域服务-售后申请实现〉
 * @author : yuhao
 * @date : 2022/9/10 13:14
 */
@HTServiceImpl
public class UocAfterOrderCreateServiceImpl implements UocAfterOrderCreateService{
    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    /**
     * 售后申请事务层
     */
    @Autowired
    private UocAfterOrderCreateTransaction uocAfterOrderCreateTransaction;

    @Override
    public UocAfterOrderCreateRspBo createAfterOrder(UocAfterOrderCreateReqBo reqBo) {
        //调用售后申请事务层，售后申请
        UocAfterOrderCreateRspBo rspBo = this.uocAfterOrderCreateTransaction.createAfterOrder(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocAfterOrderCreateReqBo reqBo, UocAfterOrderCreateRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //定义销售单数据同步BO
        SyncEsRunnableBo syncSaleEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        //设置订单ID
        syncSaleEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncSaleEsRunnableBo.setObjId(reqBo.getSaleOrderId());
        //设置操作标识
        syncSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncSaleEsRunnableBo);

        //定义发货单数据同步BO
        SyncEsRunnableBo syncShipEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        //设置订单ID
        syncShipEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncShipEsRunnableBo.setObjId(reqBo.getShipOrderId());
        //设置操作标识
        syncShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncShipEsRunnableBo);

        //定义售后单数据同步BO
        SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        //设置订单ID
        syncAfEsRunnableBo.setOrderId(reqBo.getOrderId());
        //设置对象ID
        syncAfEsRunnableBo.setObjId(rspBo.getAfOrderId());
        //设置操作标识
        syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncAfEsRunnableBo);

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
