package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocApplyDealInvoiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApplyDealInvoiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocApplyDealInvoiceTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：UocApplyDealInvoiceServiceImpl
 * 说明：申请开票接口实现类
 */
@Slf4j
@HTServiceImpl
public class UocApplyDealInvoiceServiceImpl implements UocApplyDealInvoiceService {

    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    /**
     * 申请开票事务层
     */
    @Autowired
    private UocApplyDealInvoiceTransaction uocApplyDealInvoiceTransaction;

    /**
     * 申请开票
     */
    @Override
    public UocApplyDealInvoiceRspBo dealApplyDealInvoice(UocApplyDealInvoiceReqBo reqBo) {
        //调用申请开票事务层，申请开票
        UocApplyDealInvoiceRspBo rspBo = this.uocApplyDealInvoiceTransaction.dealApplyDealInvoice(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //调用同步ES
            this.syncEs(reqBo, rspBo);
        }

        //出参
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocApplyDealInvoiceReqBo reqBo, UocApplyDealInvoiceRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();

        //定义数据同步BO
        SyncEsRunnableBo syncEsRunnableBo = new SyncEsRunnableBo();
        //设置索引名称
        syncEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        //设置订单ID
        syncEsRunnableBo.setOrderId(rspBo.getOrderId());
        //设置对象ID
        syncEsRunnableBo.setObjId(rspBo.getSaleOrderId());
        //设置操作标识
        syncEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //添加到数据同步BO集合
        syncEsRunnableBoList.add(syncEsRunnableBo);

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
