package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapInspResult;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapInspTask;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocArchivistDataQryServiceImpl
 * 说明:TODO
 * 时间:2024/9/13 09:49
 * 作者:罗有
 */

@HTServiceImpl
public class UocArchivistDataQryServiceImpl implements UocArchivistDataQryService {

	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Autowired
	private IUocAfOrderModel iUocAfOrderModel;

	@Autowired
	private IUocCmpOrderModel iUocCmpOrderModel;

	@Autowired
	private IUocInspOrderModel iUocInspOrderModel;

	@Autowired
	private IUocAuditOrderModel iUocAuditOrderModel;

	@Autowired
	private IUocCommonModel iUocCommonModel;

	@Autowired
	private IUocSysDictionaryModel iUocSysDictionaryModel;

	@Autowired
	private IUocOrderModel iUocOrderModel;

	public static final Integer PURCHASE_MODE_SAP = 1;

	@Override
	public UocArchivistDataQryRspBo qryArchivistData(UocArchivistDataQryReqBo reqBo) {

		UocArchivistDataQryRspBo rspBo = new UocArchivistDataQryRspBo();
		rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
		rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
		UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
		uocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
		UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
		if(null != uocSaleOrderDo){
			rspBo.setUocArchivistSaleOrderBo(JUtil.js(uocSaleOrderDo, UocArchivistSaleOrderBo.class));
			rspBo.setUocArchivistSaleStakeholderBo(JUtil.js(uocSaleOrderDo.getStakeholder(), UocArchivistSaleStakeholderBo.class));

			List<String> pCodes = new ArrayList<>();
			pCodes.add("ZONE_TYPE");
			Map<String, Map<String, String>> areaTypeMaps = iUocSysDictionaryModel.getDictionaryMap(pCodes);
			Map<String, String> areaTypeMap = areaTypeMaps.get("ZONE_TYPE");
			if(null != rspBo.getUocArchivistSaleOrderBo().getAreaType()) {
				rspBo.getUocArchivistSaleOrderBo().setAreaTypeStr(areaTypeMap.get(rspBo.getUocArchivistSaleOrderBo().getAreaType().toString()));
			}

			UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
			uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
			List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
			if(!CollectionUtils.isEmpty(saleOrderItemList)) {
				rspBo.getUocArchivistSaleOrderBo().setUocArchivistSaleOrderItemBoList(JUtil.jsl(saleOrderItemList, UocArchivistSaleOrderItemBo.class));
				//sap
				if(PURCHASE_MODE_SAP.equals(rspBo.getUocArchivistSaleOrderBo().getPurchaseMode())) {
					setSapInfo(rspBo, saleOrderItemList);
				}
				if(UocConstant.orderSource.ELC.equals(uocSaleOrderDo.getOrderSource())) {
					//oa附件
					setOaAttach(reqBo, rspBo);
					//比选单
					setCmpOrder(rspBo, saleOrderItemList);
				}
			}

			//验收单
			setInspOrder(reqBo, rspBo);

			//售后单
			setAfOrder(reqBo, rspBo);

			//销售单汇总人
			setTask(rspBo, uocSaleOrderDo);

		}

		return rspBo;
	}

	private void setOaAttach(UocArchivistDataQryReqBo reqBo, UocArchivistDataQryRspBo rspBo) {
		UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
		uocOrderAccessoryQryBo.setObjId(reqBo.getSaleOrderId());
		uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
		uocOrderAccessoryQryBo.setAttachmentType(UocAttachementTypeConstants.OA_APPROVAL_RESULT);
		List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
		if(!CollectionUtils.isEmpty(orderAccessoryList)) {
			rspBo.getUocArchivistSaleOrderBo().setUocArchivistOrderAccessoryBoList(JUtil.jsl(orderAccessoryList, UocArchivistOrderAccessoryBo.class));
		}
	}

	private void setSapInfo(UocArchivistDataQryRspBo rspBo, List<UocSaleOrderItem> saleOrderItemList) {
		List<UocSaleOrderItem> sapSaleOrderItemList = saleOrderItemList.stream().filter(o -> (!StringUtils.isBlank(o.getSapOrderItemNo()) && !StringUtils.isBlank(o.getSapOrderNo()))).collect(Collectors.toList());
		if(!CollectionUtils.isEmpty(sapSaleOrderItemList)) {
			//sap信息
			List<UocSapInspTask> uocSapInspTasks = new ArrayList<>();
			sapSaleOrderItemList.forEach(uocSaleOrderItem -> {
				UocSapInspTask uocSapInspTask = new UocSapInspTask();
				uocSapInspTask.setEbeln(uocSaleOrderItem.getSapOrderNo());
				uocSapInspTask.setEbelp(uocSaleOrderItem.getSapOrderItemNo());
				uocSapInspTasks.add(uocSapInspTask);
			});
			List<UocSapInspTask> uocSapInspTaskList = iUocSaleOrderModel.getSapTaskList(uocSapInspTasks);
			if(!CollectionUtils.isEmpty(uocSapInspTaskList)){
				Map<String, List<UocSapInspResult>> ysbhMap = new HashMap<>();

				List<UocSapInspResult> uocSapInspResults = new ArrayList<>();
				for (UocSapInspTask uocSapInspTask : uocSapInspTaskList) {
					UocSapInspResult uocSapInspResult = new UocSapInspResult();
					uocSapInspResult.setZysbh(uocSapInspTask.getZysbh());
					uocSapInspResult.setZysh(uocSapInspTask.getZysh());
					uocSapInspResults.add(uocSapInspResult);
				}
				List<UocSapInspResult> sapResultList = iUocSaleOrderModel.getSapResultList(uocSapInspResults);
				if (!CollectionUtils.isEmpty(sapResultList)) {
					ysbhMap = sapResultList.stream().collect(Collectors.groupingBy(UocSapInspResult::getYsCodeLine));
				}

				Map<String, UocSapInspTask> sapTaskMap = uocSapInspTaskList.stream().collect(Collectors.toMap(UocSapInspTask::getEbelnp, o -> o, (o1, o2) -> o1));
				for (UocArchivistSaleOrderItemBo uocArchivistSaleOrderItemBo : rspBo.getUocArchivistSaleOrderBo().getUocArchivistSaleOrderItemBoList()) {
					String np = uocArchivistSaleOrderItemBo.getSapOrderNo() + uocArchivistSaleOrderItemBo.getSapOrderItemNo();
					if(sapTaskMap.containsKey(np)) {

						uocArchivistSaleOrderItemBo.setUocArchivistSapInspTaskBo(JUtil.js(sapTaskMap.get(np), UocArchivistSapInspTaskBo.class));

						String ysCodeLine = uocArchivistSaleOrderItemBo.getUocArchivistSapInspTaskBo().getZysbh() + uocArchivistSaleOrderItemBo.getUocArchivistSapInspTaskBo().getZysh();

						if(ysbhMap.containsKey(ysCodeLine)) {
							List<UocSapInspResult> sapInspResultList = ysbhMap.get(ysCodeLine);
							JSONObject sapInspResultJsonObj = new JSONObject();
							for (UocSapInspResult uocSapInspResult : sapInspResultList) {
								sapInspResultJsonObj.put("a" + uocSapInspResult.getZyszb().trim(), uocSapInspResult.getZysjgms());
								sapInspResultJsonObj.put("at" + uocSapInspResult.getZyszb().trim(), uocSapInspResult.getZysjg());
							}
							uocArchivistSaleOrderItemBo.setUocArchivistSapInspResultBo(sapInspResultJsonObj);
						}
					}
				}
			}
		}
	}

	private void setTask(UocArchivistDataQryRspBo rspBo, UocSaleOrderDo uocSaleOrderDo) {
		UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
		uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getSaleOrderId().toString());
		uocApprovalObjQryBo.setObjType(2);
		List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
		if(!CollectionUtils.isEmpty(uocApprovalObjs)){
			UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
			uocOrderTaskInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
			uocOrderTaskInst.setObjType(9);
			List<UocOrderTaskInst> uocOrderTaskInsts = iUocCommonModel.qryTaskInst(uocOrderTaskInst);
			if(!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
				Optional<UocOrderTaskInst> max = uocOrderTaskInsts.stream().filter(o -> null != o.getFinishTime()).max(Comparator.comparing(UocOrderTaskInst::getFinishTime));
				max.ifPresent(taskInst -> rspBo.getUocArchivistSaleOrderBo().setUocArchivistOrderTaskBo(JUtil.js(taskInst, UocArchivistOrderTaskBo.class)));
			}
		}
	}

	private void setCmpOrder(UocArchivistDataQryRspBo rspBo, List<UocSaleOrderItem> saleOrderItemList) {
		List<String> cmpOrderNoList = saleOrderItemList.stream().map(UocSaleOrderItem::getCmpOrderNo).filter(cmpOrderNo -> !StringUtils.isBlank(cmpOrderNo)).distinct().collect(Collectors.toList());
		if(!CollectionUtils.isEmpty(cmpOrderNoList)) {
			UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
			uocCmpOrderQryBo.setCmpOrderNoList(saleOrderItemList.stream().map(UocSaleOrderItem::getCmpOrderNo).distinct().collect(Collectors.toList()));
			List<UocCmpOrderQryBo> uocCmpOrderQryBos = iUocCmpOrderModel.qryCmpOrderList(uocCmpOrderQryBo);
			if (!CollectionUtils.isEmpty(uocCmpOrderQryBos)){
				rspBo.setUocArchivistCmpOrderBoList(JUtil.jsl(uocCmpOrderQryBos, UocArchivistCmpOrderBo.class));
			}
		}
	}

	private void setInspOrder(UocArchivistDataQryReqBo reqBo, UocArchivistDataQryRspBo rspBo) {
		UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
		uocInspOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
		List<UocInspOrderDo> inspOrderDoList = iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
		if(!CollectionUtils.isEmpty(inspOrderDoList)){
			rspBo.setUocArchivistInspOrderBoList(JUtil.jsl(inspOrderDoList, UocArchivistInspOrderBo.class));

			UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
			uocInspOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
			UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getInspOrderItemList(uocInspOrderItemQryBo);
			if(!CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
				ConcurrentMap<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingByConcurrent(UocInspOrderItem::getInspOrderId));
				for (UocArchivistInspOrderBo uocArchivistInspOrderBo : rspBo.getUocArchivistInspOrderBoList()) {
					if(inspOrderMap.containsKey(uocArchivistInspOrderBo.getInspOrderId())){
						List<UocInspOrderItem> uocInspOrderItems = inspOrderMap.get(uocArchivistInspOrderBo.getInspOrderId());
						uocArchivistInspOrderBo.setUocArchivistInspOrderItemBoList(JUtil.jsl(uocInspOrderItems, UocArchivistInspOrderItemBo.class));
					}
				}
			}
		}
	}

	private void setAfOrder(UocArchivistDataQryReqBo reqBo, UocArchivistDataQryRspBo rspBo) {
		UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
		uocAfOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
		uocAfOrderQryBo.setServState(UocDicConstant.SERVICE_STATE.COMPLATE);
		List<UocAfOrder> afOrderList = iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);

		if(!CollectionUtils.isEmpty(afOrderList)) {

			rspBo.setUocArchivistAfOrderBoList(JUtil.jsl(afOrderList, UocArchivistAfOrderBo.class));

			UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
			uocAfOrderItemQryBo.setAfOrderIds(afOrderList.stream().map(UocAfOrder::getAfOrderId).collect(Collectors.toList()));
			uocAfOrderItemQryBo.setOrderBy("create_time");
			List<UocAfOrderItem> afOrderItemList = iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);

			if(!CollectionUtils.isEmpty(afOrderItemList)) {

				ConcurrentMap<Long, List<UocAfOrderItem>> afOrderMap = afOrderItemList.stream().collect(Collectors.groupingByConcurrent(UocAfOrderItem::getAfOrderId));

				for (UocArchivistAfOrderBo uocArchivistAfOrderBo : rspBo.getUocArchivistAfOrderBoList()) {
					if(afOrderMap.containsKey(uocArchivistAfOrderBo.getAfOrderId())) {
						List<UocAfOrderItem> uocAfOrderItems = afOrderMap.get(uocArchivistAfOrderBo.getAfOrderId());
						uocArchivistAfOrderBo.setUocArchivistAfOrderItemBoList(JUtil.jsl(uocAfOrderItems, UocArchivistAfOrderItemBo.class));
					}
				}
				if(!CollectionUtils.isEmpty(rspBo.getUocArchivistSaleOrderBo().getUocArchivistSaleOrderItemBoList())) {
					List<Long> afOrderIds = afOrderList.stream().filter(o -> o.getServType().equals(20)).map(UocAfOrder::getAfOrderId).collect(Collectors.toList());

					ConcurrentMap<Long, BigDecimal> skuReturnCountMap = afOrderItemList.stream().filter(o -> afOrderIds.contains(o.getAfOrderId()))
							.collect(Collectors.groupingByConcurrent(UocAfOrderItem::getSkuId, Collectors.reducing(BigDecimal.ZERO, UocAfOrderItem::getReturnCount, BigDecimal::add)));
					for (UocArchivistSaleOrderItemBo uocArchivistSaleOrderItemBo : rspBo.getUocArchivistSaleOrderBo().getUocArchivistSaleOrderItemBoList()) {
						uocArchivistSaleOrderItemBo.setReplaceCount(skuReturnCountMap.get(Convert.toLong(uocArchivistSaleOrderItemBo.getSkuId())));
					}
				}
			}
			List<String> pCodes = new ArrayList<>();
			pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
			Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodes);
			Map<String, String> stringStringMap = dictionaryMap.get(UocDicConstant.SERVICE_TYPE.P_CODE);

			for (UocArchivistAfOrderBo uocArchivistAfOrderBo : rspBo.getUocArchivistAfOrderBoList()) {
				uocArchivistAfOrderBo.setServTypeDesc(stringStringMap.get(uocArchivistAfOrderBo.getServType().toString()));
			}
		}
	}
}
