package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocCheckSaleOrderArchivistReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCheckSaleOrderArchivistRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题:UocCheckSaleOrderArchivistServiceImpl
 * 说明:TODO
 * 时间:2024/10/12 16:17
 * 作者:罗有
 */

@HTServiceImpl
public class UocCheckSaleOrderArchivistServiceImpl implements UocCheckSaleOrderArchivistService {

	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Override
	public UocCheckSaleOrderArchivistRspBo checkSaleOrderArchivist(UocCheckSaleOrderArchivistReqBo reqBo) {

		UocCheckSaleOrderArchivistRspBo rspBo = new UocCheckSaleOrderArchivistRspBo();
		rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
		rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
		UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
		uocOrderRelQryBo.setSaleOrderIds(reqBo.getSaleOrderIds());
		List<UocOrderRel> archSaleOrderList = iUocSaleOrderModel.getArchSaleOrderList(uocOrderRelQryBo);
		if(!CollectionUtils.isEmpty(archSaleOrderList)) {
			rspBo.setArchivistSaleOrderIds(archSaleOrderList.stream().map(UocOrderRel::getSaleOrderId).collect(Collectors.toList()));
		}
		return rspBo;
	}
}
