package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-售后申请实现〉
 * @author : yuhao
 * @date : 2022/9/10 13:14
 */
@Component
public class UocAfterOrderCreateTransaction {
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @Autowired
    private IUocSaleOrderModel saleOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocAfterOrderCreateRspBo createAfterOrder(UocAfterOrderCreateReqBo reqBo) {
        //参数校验
        this.validateArg(reqBo);

        //返回结果
        UocAfterOrderCreateRspBo rspBo = new UocAfterOrderCreateRspBo();
        //校验可售后数量
        this.checkAfterCount(reqBo,rspBo);
        //创建售后单
        UocAfOrderDo afterOrderApplyInfo = this.createAfterOrderApplyInfo(reqBo);
        //更新销售单明细，发货单明细在途数量
        this.updateAfingCount(reqBo,afterOrderApplyInfo);
        // 如果是电商商品：需保存外部订单id和内部订单关系
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(reqBo.getOrderSource())) {
            this.saveOrderExternalRela(reqBo,afterOrderApplyInfo.getAfOrderId());
        }

        //返回售后单ID
        rspBo.setAfOrderId(afterOrderApplyInfo.getAfOrderId());
        //返回售后单编号
        rspBo.setAfServCode(afterOrderApplyInfo.getAfServCode());
        JSONObject saleOrderExtObj = new JSONObject();
        saleOrderExtObj.put(UocConstant.ES_MAIN_OTHER.AFTERORDERFLAG, UocConstant.SALEORDER_SYN_AFTERORDER.ING);
        //返回同步销售单字段
        rspBo.setSaleOrderExtObj(JSONObject.toJSONString(saleOrderExtObj));
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    /**
     * 保存内部订单和外部订单关系
     * @param reqBo
     * @param afOrderId
     */
    private void saveOrderExternalRela(UocAfterOrderCreateReqBo reqBo,Long afOrderId){
        UocOrderQueryIndex orderQueryIndex = new UocOrderQueryIndex();
        orderQueryIndex.setId(IdUtil.nextId());
        orderQueryIndex.setOrderId(reqBo.getOrderId());
        orderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        orderQueryIndex.setObjId(afOrderId);
        orderQueryIndex.setOutObjId(reqBo.getServiceId());
        this.iUocCommonModel.saveOrderQueryIndex(orderQueryIndex);
    }

    /**
     * 更新销售单，发货单在途数量
     * @param reqBo
     * @param afOrderDo
     */
    private void updateAfingCount(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo afOrderDo) {
        for (UocAfOrderItem uocAfOrderItem : afOrderDo.getAfOrderItemBoList()) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            //更新发货单在途数量
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount);
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            //修改销售单在途数量
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount);
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.saleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
        }
    }

    /**
     * 创建售后单
     * @param reqBo
     */
    private UocAfOrderDo createAfterOrderApplyInfo(UocAfterOrderCreateReqBo reqBo){
        //组装售后单信息
        UocAfOrderDo createAfterOrder = UocRu.js(reqBo, UocAfOrderDo.class);

        //设置服务提出联系人
        createAfterOrder.setSubContactName(reqBo.getName());
        //设置服务提出联系人电话
        createAfterOrder.setSubContactMobile(reqBo.getCellphone());
        //设置创建时间
        createAfterOrder.setCreateTime(new Date());
        //设置创建工号
        createAfterOrder.setCreateOperId(String.valueOf(reqBo.getUserId()));
        //设置服务提出时间
        createAfterOrder.setSubmiteTime(new Date());
        //设置服务提出人id
        createAfterOrder.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        //设置服务提出人名称
        createAfterOrder.setSubmitterOperName(reqBo.getName());
        //设置服务提出部门id
        createAfterOrder.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        //设置服务提出部门名称
        createAfterOrder.setSubDeptName(reqBo.getOrgName());
        //设置服务提出公司id
        createAfterOrder.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        //设置服务提出公司名称
        createAfterOrder.setSubCompName(reqBo.getCompanyName());
        //设置申请页面填写的客户姓名
        createAfterOrder.setExtField2(reqBo.getClientName());
        //设置申请页面填写的客户手机号
        createAfterOrder.setExtField3(reqBo.getClientPhone());
        //设置外部售后单Id
        createAfterOrder.setExtAfId(reqBo.getServiceId());

        //组装售后单明细信息集合
        List<UocAfOrderItem> uocAfOrderItems = new ArrayList<>();
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : reqBo.getShipItemList()) {
            //查询发货单明细信息
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            //设置查询条件：发货单明细id
            uocShipOrderItemQryBo.setShipOrderItemId(uocAfterOrderCreateReqItemBo.getShipOrderItemId());
            //设置查询条件：发货单id
            uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
            UocShipOrderDo shipOrderItemInfo = this.shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            if (ObjectUtil.isNotEmpty(shipOrderItemInfo) && CollectionUtil.isNotEmpty(shipOrderItemInfo.getShipOrderItemBoList())) {
                //组装售后单明细
                UocAfOrderItem createAfOrderItem = new UocAfOrderItem();
                BeanUtils.copyProperties(reqBo, createAfOrderItem);
                BeanUtil.copyProperties(shipOrderItemInfo.getShipOrderItemBoList().get(0), createAfOrderItem);
                //设置创建时间
                createAfOrderItem.setCreateTime(new Date());
                //设置创建工号
                createAfOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
                //设置销售明细id
                createAfOrderItem.setSaleItemId(shipOrderItemInfo.getShipOrderItemBoList().get(0).getSaleOrderItemId());
                //设置发货明细id
                createAfOrderItem.setShipItemId(shipOrderItemInfo.getShipOrderItemBoList().get(0).getShipOrderItemId());

                //查询销售单明细信息
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                //设置查询条件：销售单明细id
                uocSaleOrderItemQryBo.setSaleOrderItemId(shipOrderItemInfo.getShipOrderItemBoList().get(0).getSaleOrderItemId());
                List<UocSaleOrderItem> saleOrderItemInfo = this.saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                if (CollectionUtil.isNotEmpty(saleOrderItemInfo)){
                    BeanUtil.copyProperties(saleOrderItemInfo.get(0), createAfOrderItem);
                    //设置售后服务量
                    createAfOrderItem.setReturnCount(uocAfterOrderCreateReqItemBo.getReturnCount());
                    //设置采购退款金额
                    createAfOrderItem.setRetPurchaseFee(saleOrderItemInfo.get(0).getPurchasePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()).setScale(2, RoundingMode.HALF_UP));
                    //设置销售退款金额
                    createAfOrderItem.setRetSaleFee(saleOrderItemInfo.get(0).getSalePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()).setScale(2, RoundingMode.HALF_UP));
                    uocAfOrderItems.add(createAfOrderItem);
                }else{
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细"+shipOrderItemInfo.getShipOrderItemBoList().get(0).getSaleOrderItemId()+"信息失败");
                }
            }else{
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单明细"+uocAfterOrderCreateReqItemBo.getShipOrderItemId()+"信息失败");
            }
        }
        //设置售后单明细
        createAfterOrder.setAfOrderItemBoList(uocAfOrderItems);
        //设置销售退款总金额
        createAfterOrder.setRetTotalSaleFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        //设置采购退款总金额
        createAfterOrder.setRetTotalPurchaseFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetPurchaseFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));

        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(reqBo.getServType())) {
            //如果售后服务类型为：退货，设置实际退款金额
            createAfterOrder.setRealReturnFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        }

        //组装售后单对象信息
        ArrayList<UocAfOrderObj> afOrderObjList = new ArrayList<>();
        UocAfOrderObj createAfOrderObj = new UocAfOrderObj();
        //设置订单id
        createAfOrderObj.setOrderId(reqBo.getOrderId());
        //设置销售单id
        createAfOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        //设置发货单id
        createAfOrderObj.setShipOrderId(reqBo.getShipOrderId());
        //设置创建工号
        createAfOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
        //设置创建时间
        createAfOrderObj.setCreateTime(new Date());
        afOrderObjList.add(createAfOrderObj);
        //设置售后单对象
        createAfterOrder.setAfOrderObjList(afOrderObjList);

        //组装附件信息
        if (CollectionUtil.isNotEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = new ArrayList<>();
            for(UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo:reqBo.getOrderAccessoryBoList()){
                UocOrderAccessory afterOrderAccessory = JSONObject.parseObject(JSON.toJSONString(uocBaseOrderAccessoryAddBo),UocOrderAccessory.class);
                //设置附件类型 1：其他附件（供应商可见）
                afterOrderAccessory.setAttachmentType(UocDicConstant.ATTACHMENT_TYPE.OTHER_ATTACH_FOR_SUPPLIER);
                //设置创建人
                afterOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
                //设置创建时间
                afterOrderAccessory.setCreateTime(new Date());
                orderAccessoryBoList.add(afterOrderAccessory);
            }
            //设置附件信息
            createAfterOrder.setOrderAccessoryBoList(UocRu.jsl(orderAccessoryBoList, UocOrderAccessory.class));
        }

        //组装取件地址信息
        if (ObjectUtil.isNotEmpty(reqBo.getTakeAddress())) {
            UocOrdLogisticsRela takeAddress = new UocOrdLogisticsRela();
            BeanUtils.copyProperties(reqBo.getTakeAddress(),takeAddress);
            //设置创建人
            takeAddress.setCreateOperId(String.valueOf(reqBo.getUserId()));
            //设置创建时间
            takeAddress.setCreateTime(new Date());
            //设置取件地址
            createAfterOrder.setTakeAddress(takeAddress);
        }

        //组装返件地址信息
        if (ObjectUtil.isNotEmpty(reqBo.getReturnAddress())) {
            UocOrdLogisticsRela returnAddress = new UocOrdLogisticsRela();
            BeanUtils.copyProperties(reqBo.getReturnAddress(),returnAddress);
            //设置创建人
            returnAddress.setCreateOperId(String.valueOf(reqBo.getUserId()));
            //设置创建时间
            returnAddress.setCreateTime(new Date());
            //设置返件地址信息
            createAfterOrder.setReturnAddress(UocRu.js(returnAddress, UocOrdLogisticsRela.class));
        }

        //获取销售单支付信息
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.saleOrderModel.getSaleOrderMain(querySaleOrderDo);

        //设置支付方式
        createAfterOrder.setPayType(saleOrderMain.getPayType());
        if(null != saleOrderMain && UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(reqBo.getServType())){
            //退货才有退款状态
            if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(reqBo.getServType())) {
                if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.toString().equals(saleOrderMain.getPayType())) {
                    createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.UPDATEING);
                } else {
                    createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
                }
            }
            /*if (String.valueOf(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED).equals(saleOrderMain.getPayType())){
                //如果支付方式为：预付款按比例支付，设置服务单支付状态为：退款中
                createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
            } else if (String.valueOf(UocDicConstant.PAY_TYPE.PAY_BY_PERIOD).equals(saleOrderMain.getPayType())){
                //如果支付方式未：按账期支付
                if (UocDicConstant.PAY_STATE.WAIT_PAY.equals(saleOrderMain.getPayState())) {
                    //如果销售单待支付，设置设置服务单支付状态为：更新中
                    createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.UPDATEING);
                } else if (UocDicConstant.PAY_STATE.PAYED.equals(saleOrderMain.getPayState())) {
                    //如果销售单已支付，设置设置服务单支付状态为：退款中
                    createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
                }
            }*/
            //设置支付方式翻译
            createAfterOrder.setPayTypeStr(saleOrderMain.getPayTypeStr());
        }

        //创建售后服务申请
        UocAfOrderDo afterOrderInfo = this.afOrderModel.dealPebTheZoneAfterApplication(createAfterOrder, reqBo.getOrderSource());
        return afterOrderInfo;
    }

    /**
     * 校验可售后数量
     * @param reqBo
     */
    private void checkAfterCount(UocAfterOrderCreateReqBo reqBo,UocAfterOrderCreateRspBo rspBo) {
        UocShipOrderItemQryBo uocShipOrderQryBo = new UocShipOrderItemQryBo();
        //设置查询条件：订单id
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        //设置查询条件：发货单id
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        //查询发货单明细信息
        UocShipOrderDo shipOrderInfo = this.shipOrderModel.getListShipOrderItem(uocShipOrderQryBo);
        //将发货单明细信息转化为map，方便后面运算
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderInfo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        //对入参中的每个发货单明细进行校验
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemMap.get(uocAfterOrderCreateReqItemBo.getShipOrderItemId());
            //计算可售后数量=发货数量-退货数量-在途售后数量
            BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
            if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) > 0) {
                //如果本次售后数量大于可售后数量，抛出异常
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性售后数量不能超过可售后数量");
            }
        }
        rspBo.setSupId(shipOrderInfo.getSupNo());
        //查询销售单编号
        UocSaleOrderDo saleOrderDo = new UocSaleOrderDo();
        saleOrderDo.setOrderId(reqBo.getOrderId());
        saleOrderDo.setSaleOrderId(shipOrderInfo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = saleOrderModel.getSaleOrderMain(saleOrderDo);
        rspBo.setSaleOrderNo(saleOrderMain.getSaleOrderNo());
    }

    private void buildShipItem(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo createDo) {
        List<UocAfOrderItem> uocAfOrderItems = new ArrayList<>();
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
                Long shipOrderItemId = uocAfterOrderCreateReqItemBo.getShipOrderItemId();
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setShipOrderItemId(shipOrderItemId);
                uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
                UocShipOrderDo shipOrderItem = shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (ObjectUtil.isNotEmpty(shipOrderItem) && ObjectUtil.isNotEmpty(shipOrderItem.getShipOrderItemBoList())) {
                    UocAfOrderItem uocAfOrderItem = new UocAfOrderItem();
                    List<UocShipOrderItem> shipOrderItemBoList = shipOrderItem.getShipOrderItemBoList();
                    UocShipOrderItem uocShipOrderItem = shipOrderItemBoList.get(0);
                    BeanUtil.copyProperties(uocShipOrderItem, uocAfOrderItem);
                    Long saleOrderItemId = uocShipOrderItem.getSaleOrderItemId();
                    UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                    uocSaleOrderItemQryBo.setSaleOrderItemId(saleOrderItemId);
                    List<UocSaleOrderItem> saleOrderItemList = saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                    UocSaleOrderItem uocSaleOrderItem = saleOrderItemList.get(0);
                    BeanUtil.copyProperties(uocSaleOrderItem, uocAfOrderItem);
                    uocAfOrderItem.setSaleItemId(uocShipOrderItem.getSaleOrderItemId());
                    uocAfOrderItem.setShipItemId(uocShipOrderItem.getShipOrderItemId());
                    uocAfOrderItem.setReturnCount(uocAfterOrderCreateReqItemBo.getReturnCount());
                    uocAfOrderItem.setRetPurchaseFee(uocSaleOrderItem.getPurchasePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                    uocAfOrderItem.setRetSaleFee(uocSaleOrderItem.getSalePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                    uocAfOrderItems.add(uocAfOrderItem);
                }
            }
        }
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(reqBo.getServType())) {
            createDo.setRealReturnFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        }
        createDo.setAfOrderItemBoList(uocAfOrderItems);
        createDo.setRetTotalSaleFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        createDo.setRetTotalPurchaseFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetPurchaseFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }


    private UocAfOrderDo convertOrderDo(UocAfterOrderCreateReqBo reqBo) {
        UocAfOrderDo uocAfOrderDo = UocRu.js(reqBo, UocAfOrderDo.class);
        UocAfOrderObj uocAfOrderObj = UocRu.js(reqBo, UocAfOrderObj.class);
        ArrayList<UocAfOrderObj> uocAfOrderObjs = new ArrayList<>();
        uocAfOrderObjs.add(uocAfOrderObj);
        uocAfOrderDo.setAfOrderObjList(uocAfOrderObjs);
        uocAfOrderDo.setExtAfId(reqBo.getServiceId());
        List<BaseExtendFieldBo> extFields = reqBo.getExtFields();
        if (CollectionUtil.isNotEmpty(extFields)) {
            BeanUtils.copyProperties(reqBo, uocAfOrderDo);
            uocAfOrderDo.setExtParallelBoList(UocRu.jsl(extFields, UocAfOrderMap.class));
            uocAfOrderDo.setCreateTime(new Date());
            uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        List<UocAfterOrderCreateReqItemBo> shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty(shipItemList)) {
            uocAfOrderDo.setAfOrderItemBoList(UocRu.jsl(shipItemList, UocAfOrderItem.class));
            for (UocAfOrderItem uocAfOrderItem : uocAfOrderDo.getAfOrderItemBoList()) {
                BeanUtils.copyProperties(reqBo, uocAfOrderItem);
                uocAfOrderItem.setCreateTime(new Date());
                uocAfOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList = reqBo.getOrderAccessoryBoList();
        if (CollectionUtil.isNotEmpty(orderAccessoryBoList)) {
            uocAfOrderDo.setOrderAccessoryBoList(UocRu.jsl(orderAccessoryBoList, UocOrderAccessory.class));
            for (UocOrderAccessory uocOrderAccessory : uocAfOrderDo.getOrderAccessoryBoList()) {
                BeanUtils.copyProperties(reqBo, uocOrderAccessory);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        UocAfterOrderCreateReqAddressBo takeAddress = reqBo.getTakeAddress();
        UocAfterOrderCreateReqAddressBo returnAddress = reqBo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            uocAfOrderDo.setTakeAddress(UocRu.js(takeAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getTakeAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            uocAfOrderDo.setReturnAddress(UocRu.js(returnAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getReturnAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        uocAfOrderDo.setSubContactName(reqBo.getName());
        uocAfOrderDo.setSubContactMobile(reqBo.getCellphone());
        uocAfOrderDo.setCreateTime(new Date());
        uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmiteTime(new Date());
        uocAfOrderDo.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmitterOperName(reqBo.getName());
        uocAfOrderDo.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        uocAfOrderDo.setSubDeptName(reqBo.getOrgName());
        uocAfOrderDo.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        uocAfOrderDo.setSubCompName(reqBo.getCompanyName());
        //申请页面填写的客户姓名，手机号，extField1电商1003消息已使用
        uocAfOrderDo.setExtField2(reqBo.getClientName());
        uocAfOrderDo.setExtField3(reqBo.getClientPhone());

        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = saleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        uocAfOrderDo.setPayType(saleOrderMain.getPayType());
        String payType = uocAfOrderDo.getPayType();
        Integer payState = saleOrderMain.getPayState();
        if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.toString().equals(payType)) {
            uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
        } else if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.toString().equals(payType)) {
            if (UocDicConstant.PAY_STATE.WAIT_PAY.equals(payState)) {
                uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.UPDATEING);
            } else if (UocDicConstant.PAY_STATE.PAYED.equals(payState)) {
                uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
            }
        }
        uocAfOrderDo.setPayTypeStr(saleOrderMain.getPayTypeStr());
        return uocAfOrderDo;
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void validateArg(UocAfterOrderCreateReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCreateReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getShipOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单ID]不能为空");
        }

        if (ObjectUtil.isEmpty(reqBo.getServType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[服务类型]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfsReason())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后原因]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPickwareType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取货服务类型]不能为空");
        }

        if (UocConstant.AFTERORDER_PICKWARETYPE.UPDOORPICK.equals(reqBo.getPickwareType())) {
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取件地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactProvinceId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactProvinceName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCityId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCityName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactCountyId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
            }
            //if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactEmail())) {
            //    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
            //}
            //if (ObjectUtil.isEmpty(reqBo.getTakeAddress().getContactMobile())) {
            //    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
            //}
        }

        if (UocConstant.AFTERORDER_SERVTYPE.CHANGE.equals(reqBo.getServType())) {
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[返件地址]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactProvinceId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactProvinceName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCityId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCityName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactCountyId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
            }
            if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactAddress())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
            }
            //if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactEmail())) {
            //    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
            //}
            //if (ObjectUtil.isEmpty(reqBo.getReturnAddress().getContactMobile())) {
            //    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
            //}
        }
        if (ObjectUtil.isEmpty(reqBo.getShipItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后明细]不能为空");
        }
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : reqBo.getShipItemList()) {
            if (ObjectUtil.isEmpty(uocAfterOrderCreateReqItemBo.getShipOrderItemId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发货明细ID]不能为空");
            }
            if (ObjectUtil.isEmpty(uocAfterOrderCreateReqItemBo.getReturnCount())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后数量]不能为空");
            }
        }
    }

}
