package com.tydic.dyc.oc.transactionservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.service.order.bo.UocEarlyWarnECNotConfirmListRspBo;
import com.tydic.dyc.oc.service.order.bo.UocEarlyWarnECNotConfirmReqBo;
import com.tydic.dyc.oc.service.order.bo.UocEarlyWarnECNotConfirmRspBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderCancelServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/6 16:11
 * 作者 @author 尹栋梁
 */
@Component
@Slf4j
public class UocEarlyWarnECNotConfirmTransaction {

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    /**
     * 索引配置
     */
    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 统一线程池
     */
    @Autowired
    private UocThreadPool uocThreadPool;

    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocEarlyWarnECNotConfirmListRspBo earlyWarnECNotConfirm(UocEarlyWarnECNotConfirmReqBo reqBo) {
        UocEarlyWarnECNotConfirmListRspBo rspBo = iUocAfOrderModel.earlyWarnECNotConfirm(reqBo);
        log.info("售后预警出参为:{}", JSON.toJSONString(rspBo));
        if (rspBo.getUacEarlyWarnECNotConfirmList().size() > 0) {
            //调用同步ES
            this.syncEs(rspBo);
        }
        return rspBo;
    }

    /**
     * 同步ES
     */
    private void syncEs(UocEarlyWarnECNotConfirmListRspBo rspBo) {
        //定义数据同步BO集合
        List<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<>();


        for (UocEarlyWarnECNotConfirmRspBo uocEarlyWarnECNotConfirmRspBo : rspBo.getUacEarlyWarnECNotConfirmList()) {
            //定义售后单数据同步BO
            SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
            //设置索引名称
            syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
            //设置订单ID
            syncAfEsRunnableBo.setOrderId(uocEarlyWarnECNotConfirmRspBo.getOrderId());
            //设置对象ID
            syncAfEsRunnableBo.setObjId(uocEarlyWarnECNotConfirmRspBo.getAfOrderId());
            //设置操作标识
            syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

            //添加到数据同步BO集合
            syncEsRunnableBoList.add(syncAfEsRunnableBo);
        }

        //调用统一线程池
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}
