package com.tydic.dyc.oc.model.order.sub;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 标题:UocOrderQueryIndex
 * 说明:外部系统单号关联表，主要用于关联电商的外部单号，提升查询效率
 * 时间:2022-04-06 16:03
 * 作者:tkl
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocOrderQueryIndex implements Serializable {
	private static final long serialVersionUID = -1334051643269897262L;

	//id")
	private Long id;

	//单据id")
	private Long objId;

	//单据类型 1订单  2.销售单 3 发货单 4.收货单  5.售后服务单  6.支付单 99.其他")
	private Integer objType;

	//订单id")
	private Long orderId;

	//外部单号")
	private String outObjId;

	//订单来源系统")
	private String orderSystem;

	//排序")
	private String orderBy;
}
