package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfInspection;
import com.tydic.dyc.oc.model.order.sub.UocConfInspectionUse;
import com.tydic.dyc.oc.service.order.bo.UocInspectionConfigSaveReqBo;
import com.tydic.dyc.oc.service.order.bo.UocInspectionConfigSaveRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspectionConfigSaveServiceImpl
 * 说明:TODO
 * 时间:2022/4/11 14:34
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocInspectionConfigSaveServiceImpl implements UocInspectionConfigSaveService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Override
    public UocInspectionConfigSaveRspBo saveInspectionConfig(UocInspectionConfigSaveReqBo reqBo) {
        //先更新在用的超验类型
        UocConfInspectionUse uocConfInspectionUse = new UocConfInspectionUse();
        uocConfInspectionUse.setBusiType(reqBo.getBusiType());
        uocConfInspectionUse.setInspectionType(reqBo.getInspectionType());
        uocConfInspectionUse.setOperId(reqBo.getUserId().toString());
        uocConfInspectionUse.setOperName(reqBo.getName());
        uocConfInspectionUse.setOperTime(new Date());
        iUocOrderModel.updateInspectionConfigUse(uocConfInspectionUse);
        // 删除就数据
        UocConfInspection uocConfInspection = new UocConfInspection() ;
        uocConfInspection.setBusiType(reqBo.getBusiType());
        uocConfInspection.setInspectionType(reqBo.getInspectionType());
        iUocOrderModel.deleteInspectionConfig(uocConfInspection);
        //写入新数据
        List<UocConfInspection> uocConfInspections = new ArrayList<>();
        if (UocConstant.INSPECTION_TYPE_ALL.equals(reqBo.getInspectionType())) {
            UocConfInspection uocConfInspection1 = new UocConfInspection();
            uocConfInspection1.setConfigId(IdUtil.nextId());
            uocConfInspection1.setInspectionType(reqBo.getInspectionType());
            uocConfInspection1.setBusiType(reqBo.getBusiType());
            uocConfInspection1.setConfigId(IdUtil.nextId());
            uocConfInspection1.setExcessPercent(reqBo.getAllExcessPercent());
            uocConfInspection1.setOperId(reqBo.getUserId().toString());
            uocConfInspection1.setOperName(reqBo.getUsername());
            uocConfInspection1.setOperTime(new Date());
            uocConfInspections.add(uocConfInspection1);
        }else {
            reqBo.getCommodityDatas().forEach(bo -> {
                UocConfInspection uocConfInspection2 = new UocConfInspection();
                uocConfInspection2.setBusiType(reqBo.getBusiType());
                uocConfInspection2.setInspectionType(reqBo.getInspectionType());
                uocConfInspection2.setConfigId(IdUtil.nextId());
                uocConfInspection2.setOperId(reqBo.getUserId().toString());
                uocConfInspection2.setOperName(reqBo.getName());
                uocConfInspection2.setOperTime(new Date());
                uocConfInspection2.setCommodityType(bo.getCommodityType());
                uocConfInspection2.setCommodityName(bo.getCommodityName());
                uocConfInspection2.setExcessPercent(bo.getExcessPercent());
                uocConfInspections.add(uocConfInspection2);
            });
        }
        iUocOrderModel.insertInspectionConfigByBatch(uocConfInspections);
        return UocRu.success(UocInspectionConfigSaveRspBo.class);
    }
}
