package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:变更销售单计划实现
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/27 16:37
 */
@HTServiceImpl
public class UocSaleOrderUpdatePlanStateServiceImpl implements UocSaleOrderUpdatePlanStateService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Override
    public UocSaleOrderUpdatePlanStateRspBo updateSaleOrderPlanState(UocSaleOrderUpdatePlanStateReqBo reqBo) {
        //参数校验
        this.validateArg(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setIsReducedPlan(reqBo.getIsReducedPlan());
        uocSaleOrderDo.setPurchaseMode(reqBo.getPurchaseMode());
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);

        syncEs(reqBo);
        return UocRu.success(UocSaleOrderUpdatePlanStateRspBo.class);
    }
    private void syncEs(UocSaleOrderUpdatePlanStateReqBo reqBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo orderBo = new SyncEsRunnableBo();
        orderBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        orderBo.setOrderId(reqBo.getOrderId());
        orderBo.setObjId(reqBo.getSaleOrderId());
        orderBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(orderBo);
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
    /**
     * 参数校验
     * @param reqBo
     */
    private void validateArg(UocSaleOrderUpdatePlanStateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
    }



}
