/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocArrvalAcceptanceTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocArrvalAcceptanceTransaction.class);
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";
    private static final String EC_IMPORT = "2";
    private static final String SUP_NO = "0";

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocArrvalAcceptanceRspBo dealArrvalAcceptance(UocArrvalAcceptanceReqBo reqBo) {
        this.verifyParam(reqBo);
        this.validateAfOrderUnfinished(reqBo);
        List<UocShipOrderItem> shipOrderItemInfos = this.getShipOrderItemInfos(reqBo);
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(reqBo, shipOrderItemInfos.stream().map(UocShipOrderItem::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        Map<Long, Boolean> shipOrderInspStateMap = this.updateShipOrderInfo(reqBo, shipOrderItemInfos, saleOrderItemInfos);
        this.updateSaleOrderInfo(reqBo, shipOrderItemInfos);
        Long inspOrderId = this.createInspOrder(reqBo, shipOrderItemInfos, saleOrderItemInfos);
        this.createOrderSettleRelInfo(reqBo, inspOrderId);
        this.submitShipOrderTask(reqBo, shipOrderInspStateMap);
        Boolean inspFinish = this.judgeSaleOrderFinishFlag(reqBo);
        if (inspFinish.booleanValue()) {
            this.updateSaleOrderState(reqBo);
            this.submitSaleOrderTask(reqBo);
        }
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        UocArrvalAcceptanceRspBo rspBo = UocRu.success(UocArrvalAcceptanceRspBo.class);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setFinish(inspFinish);
        rspBo.setOpFlag(inspFinish != false ? OP_FLAG_YES : "0");
        rspBo.setInspOrderId(inspOrderId);
        rspBo.setShipOrderInspStateMap(shipOrderInspStateMap);
        rspBo.setIsAgrIgnoreArrive(uocSaleOrderDo.getIsAgrIgnoreArrive());
        return rspBo;
    }

    private void submitSaleOrderTask(UocArrvalAcceptanceReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBo.setStepId(reqBo.getStepId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void submitShipOrderTask(UocArrvalAcceptanceReqBo reqBo, Map<Long, Boolean> shipOrderInspStateMap) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        for (UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo : reqBo.getShipOrderList()) {
            if (!shipOrderInspStateMap.containsKey(uocCreateInspOrderReqShipBo.getShipOrderId()) || !shipOrderInspStateMap.get(uocCreateInspOrderReqShipBo.getShipOrderId()).booleanValue()) continue;
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocCreateInspOrderReqShipBo.getTaskId());
            taskBo.setStepId(uocCreateInspOrderReqShipBo.getStepId());
            taskBos.add(taskBo);
        }
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private Long createInspOrder(UocArrvalAcceptanceReqBo reqBo, List<UocShipOrderItem> shipOrderItemInfos, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemInfos.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocInspOrderDo createInspOrderDo = new UocInspOrderDo();
        Long inspOrderId = IdUtil.nextId();
        createInspOrderDo.setOrderId(reqBo.getOrderId());
        createInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        createInspOrderDo.setInspOrderId(inspOrderId);
        createInspOrderDo.setRemark(reqBo.getRemark());
        createInspOrderDo.setOtherRemark(reqBo.getOtherRemark());
        createInspOrderDo.setInspOrderNo(this.getInspOrderNo(reqBo));
        createInspOrderDo.setInspOrderState("YS_YS_YS");
        createInspOrderDo.setInspOper(reqBo.getName());
        createInspOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createInspOrderDo.setCreateTime(new Date());
        createInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        createInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        createInspOrderDo.setTenantId(reqBo.getTenantId());
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            UocShipInspRel createShipInspRel = new UocShipInspRel();
            createShipInspRel.setId(IdUtil.nextId());
            createShipInspRel.setShipOrderId(uocCreateInspOrderReqShipBo.getShipOrderId());
            createShipInspRel.setInspOrderId(createInspOrderDo.getInspOrderId());
            createShipInspRel.setOrderId(reqBo.getOrderId());
            createShipInspRel.setSaleOrderId(reqBo.getSaleOrderId());
            createShipInspRel.setCreateOperId(String.valueOf(reqBo.getUserId()));
            createShipInspRel.setCreateTime(new Date());
            uocShipInspRelList.add(createShipInspRel);
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
                UocInspOrderItem createInspOrderItem = new UocInspOrderItem();
                createInspOrderItem.setOrderId(reqBo.getOrderId());
                createInspOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                createInspOrderItem.setInspOrderId(createInspOrderDo.getInspOrderId());
                createInspOrderItem.setInspOrderItemId(IdUtil.nextId());
                createInspOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                createInspOrderItem.setRemainInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                createInspOrderItem.setInitInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                createInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                createInspOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                createInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
                createInspOrderItem.setCreateTime(new Date());
                createInspOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
                createInspOrderItem.setChngingCount(BigDecimal.ZERO);
                uocInspOrderItemList.add(createInspOrderItem);
            });
        });
        createInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        createInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        createInspOrderDo.setAllowChngTime(this.getInspAllowChngTime(reqBo));
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            reqBo.getOrderAccessoryBoList().forEach(obj -> {
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                uocOrderAccessory.setObjId(inspOrderId);
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE);
                uocOrderAccessory.setAccessoryUrl(obj.getAccessoryUrl());
                uocOrderAccessory.setAccessoryName(obj.getAccessoryName());
                uocOrderAccessoryList.add(uocOrderAccessory);
            });
        }
        createInspOrderDo.setUocOrderAccessoryList(uocOrderAccessoryList);
        BigDecimal inspSaleMoney = BigDecimal.ZERO;
        BigDecimal inspPurchaseMoney = BigDecimal.ZERO;
        for (UocInspOrderItem uocInspOrderItem : uocInspOrderItemList) {
            UocSaleOrderItem saleOrderItem = uocSaleOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
            if (null != saleOrderItem.getSalePrice() && null != saleOrderItem.getPurchaseCount()) {
                BigDecimal inspSalFee = saleOrderItem.getSalePrice().multiply(uocInspOrderItem.getInspCount());
                inspSaleMoney = inspSaleMoney.add(inspSalFee);
            }
            if (null == saleOrderItem.getPurchasePrice() || null == saleOrderItem.getPurchaseCount()) continue;
            BigDecimal purSalFee = saleOrderItem.getPurchasePrice().multiply(uocInspOrderItem.getInspCount());
            inspPurchaseMoney = inspPurchaseMoney.add(purSalFee);
        }
        createInspOrderDo.setTotalSaleFee(inspSaleMoney);
        createInspOrderDo.setTotalPurchaseFee(inspPurchaseMoney);
        this.iUocInspOrderModel.createInspOrder(createInspOrderDo);
        return inspOrderId;
    }

    private void updateSaleOrderInfo(UocArrvalAcceptanceReqBo reqBo, List<UocShipOrderItem> shipOrderItemInfos) {
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemInfos.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        updateSaleOrderDo.setUpdateTime(new Date());
        HashMap saleItemIdMap = new HashMap();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
            UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)((Object)((Object)((Object)saleItemIdMap.get(uocShipOrderItem.getSaleOrderItemId()))));
            if (null != uocSaleOrderItem) {
                uocSaleOrderItem.setAcceptanceCount(uocSaleOrderItem.getAcceptanceCount().add(uocCreateInspOrderReqShipItemBo.getInspCount()));
                uocSaleOrderItem.setInspSuperCount(uocSaleOrderItem.getInspSuperCount().add(uocShipOrderItem.getInspSuperCount()));
            } else {
                uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocSaleOrderItem.setAcceptanceCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocSaleOrderItem.setInspSuperCount(uocShipOrderItem.getInspSuperCount());
            }
            saleItemIdMap.put(uocSaleOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        }));
        updateSaleOrderDo.setSaleOrderItems(new ArrayList<UocSaleOrderItem>(saleItemIdMap.values()));
        this.iUocSaleOrderModel.modifyBatchItemInspCount(updateSaleOrderDo);
        this.iUocSaleOrderModel.modifyInspSuper(updateSaleOrderDo);
        if (reqBo.getClosePennyDiff() != null && reqBo.getClosePennyDiff().booleanValue()) {
            updateSaleOrderDo.setClosePennyDiff(UocConstant.CLOSE_PENNY_DIFF.YES);
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        }
    }

    private void updateSaleOrderState(UocArrvalAcceptanceReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> uocShipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            Set shipOrderStateSet = uocShipOrderDoList.stream().map(UocShipOrderDo::getShipOrderState).collect(Collectors.toSet());
            if (shipOrderStateSet.size() == 1 && shipOrderStateSet.contains("FH_FH_JS")) {
                updateSaleOrderDo.setSaleOrderState("XS_DH_JS");
            } else if (shipOrderStateSet.size() == 1 && shipOrderStateSet.contains("FH_FH_YS")) {
                updateSaleOrderDo.setSaleOrderState("XS_YS_YS");
            } else if (shipOrderStateSet.contains("FH_FH_YS")) {
                updateSaleOrderDo.setSaleOrderState("XS_YS_BFYS");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)updateSaleOrderDo.getSaleOrderState())) {
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
        }
    }

    private Boolean judgeSaleOrderFinishFlag(UocArrvalAcceptanceReqBo reqBo) {
        if (reqBo.getClosePennyDiff() == null || !reqBo.getClosePennyDiff().booleanValue()) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            UocSaleOrderDo collectCountImplOrderItem = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
            UocSaleOrderItem uocSaleOrderItem = collectCountImplOrderItem.getSaleOrderItems().get(0);
            if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount()) != 0) {
                return false;
            }
        }
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderDos = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        for (UocShipOrderDo uocShipOrderDo : shipOrderDos) {
            if (!uocShipOrderDo.getFinishFlag().equals(UocConstant.SHIP_ORDER_FINISH_FLAG.NOT_FINISH)) continue;
            return false;
        }
        return true;
    }

    private Map<Long, Boolean> updateShipOrderInfo(UocArrvalAcceptanceReqBo reqBo, List<UocShipOrderItem> shipOrderItemInfos, List<UocSaleOrderItem> saleOrderItemInfos) {
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemInfos.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        HashMap<Long, Boolean> shipOrderInspStateMap = new HashMap<Long, Boolean>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            shipOrderInspStateMap.put(uocCreateInspOrderReqShipBo.getShipOrderId(), true);
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                BigDecimal currentInspSuperCount;
                UocShipOrderItem shipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
                UocSaleOrderItem saleOrderItem = (UocSaleOrderItem)((Object)((Object)((Object)uocSaleOrderItemMap.get(shipOrderItem.getSaleOrderItemId()))));
                BigDecimal inspectionExcessPercent = this.getInspectionExcessPercent(saleOrderItem.getInspectionExcessPercent());
                BigDecimal canInspCount = shipOrderItem.getSendCount().add(saleOrderItem.getPurchaseCount().multiply(inspectionExcessPercent).subtract(saleOrderItem.getInspSuperCount()));
                BigDecimal currentInspCount = uocCreateInspOrderReqShipItemBo.getInspCount().add(shipOrderItem.getInspCount()).add(shipOrderItem.getReturnCount());
                if (currentInspCount.compareTo(canInspCount) > 0) {
                    // empty if block
                }
                if (!(reqBo.getInspFinish() != null && reqBo.getInspFinish().booleanValue() || currentInspCount.compareTo(shipOrderItem.getSendCount()) >= 0)) {
                    shipOrderInspStateMap.put(shipOrderItem.getShipOrderId(), false);
                }
                if (reqBo.getInspFinish().booleanValue()) {
                    shipOrderInspStateMap.put(shipOrderItem.getShipOrderId(), true);
                }
                if ((currentInspSuperCount = currentInspCount.subtract(shipOrderItem.getSendCount())).compareTo(BigDecimal.ZERO) > 0) {
                    shipOrderItem.setInspSuperCount(currentInspSuperCount);
                } else {
                    shipOrderItem.setInspSuperCount(BigDecimal.ZERO);
                }
            });
        });
        ArrayList<Long> shipOrderIdList = new ArrayList<Long>();
        ArrayList<UocShipOrderItem> shipOrderItemList = new ArrayList<UocShipOrderItem>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            if (((Boolean)shipOrderInspStateMap.get(uocCreateInspOrderReqShipBo.getShipOrderId())).booleanValue()) {
                shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                uocShipOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocShipOrderItem.setOrderId(reqBo.getOrderId());
                uocShipOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                shipOrderItemList.add(uocShipOrderItem);
            });
        });
        UocShipOrderDo updateShipOrderDo = new UocShipOrderDo();
        updateShipOrderDo.setOrderId(reqBo.getOrderId());
        updateShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateShipOrderDo.setUpdateTime(new Date());
        updateShipOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateShipOrderDo.setShipOrderItemBoList(shipOrderItemList);
        if (!CollectionUtils.isEmpty(shipOrderIdList)) {
            updateShipOrderDo.setShipOrderIdList(shipOrderIdList);
            updateShipOrderDo.setInspTime(new Date());
            updateShipOrderDo.setShipOrderState("FH_FH_YS");
            updateShipOrderDo.setInspOperId(String.valueOf(reqBo.getUserId()));
            updateShipOrderDo.setInspOperPhone(reqBo.getCellphone());
            updateShipOrderDo.setInspOperName(reqBo.getName());
            updateShipOrderDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
            this.iUocShipOrderModel.modifyShipOrderMain(updateShipOrderDo);
        }
        this.iUocShipOrderModel.modifyShipOrderItemInspCount(updateShipOrderDo);
        return shipOrderInspStateMap;
    }

    private BigDecimal getInspectionExcessPercent(Integer supInspScale) {
        BigDecimal inspectionExcessPercent = BigDecimal.ZERO;
        if (null != supInspScale) {
            inspectionExcessPercent = new BigDecimal(supInspScale).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        }
        return inspectionExcessPercent;
    }

    private Date getInspAllowChngTime(UocArrvalAcceptanceReqBo reqBo) {
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode("5");
        List rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;
        if (ObjectUtil.isNotEmpty((Object)rows)) {
            Map confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getSupplierNo(), Function.identity()));
            if (null != saleOrderMain) {
                String key = null;
                key = null != saleOrderMain.getStakeholder() ? saleOrderMain.getOrderSource() + saleOrderMain.getStakeholder().getSupId() : String.valueOf(saleOrderMain.getOrderSource()) + reqBo.getSupId();
                allowChngTime = ObjectUtil.isNotNull(confEffectiveMap.get(key)) ? new Date(((UocConfEffective)confEffectiveMap.get(key)).getAging()) : new Date(((UocConfEffective)confEffectiveMap.get(saleOrderMain.getOrderSource() + "0")).getAging());
            } else {
                allowChngTime = new Date(((UocConfEffective)confEffectiveMap.get("20")).getAging());
            }
        }
        return allowChngTime;
    }

    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocArrvalAcceptanceReqBo reqBo, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            return uocSaleOrderDo.getSaleOrderItems();
        }
        throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
    }

    private List<UocShipOrderItem> getShipOrderItemInfos(UocArrvalAcceptanceReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        ArrayList<Long> shipOrderItemIdList = new ArrayList<Long>();
        ArrayList<Long> shipOrderIdList = new ArrayList<Long>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> shipOrderItemIdList.add(uocCreateInspOrderReqShipItemBo.getShipItemId()));
        });
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIdList);
        uocShipOrderItemQryBo.setShipOrderIdList(shipOrderIdList);
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        Integer shipOrderItemSize = shipOrderItemIdList.size();
        if (null != uocShipOrderDo && !CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList()) && shipOrderItemSize.equals(uocShipOrderDo.getShipOrderItemBoList().size())) {
            return uocShipOrderDo.getShipOrderItemBoList();
        }
        throw new BaseBusinessException("101004", "\u52fe\u9009\u7684\u53d1\u8d27\u660e\u7ec6\u4e0e\u67e5\u8be2\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9a8c\u6536\u7684\u5546\u54c1\u4fe1\u606f");
    }

    private String getInspOrderNo(UocArrvalAcceptanceReqBo reqBo) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null != saleOrderMain) {
            UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
            uocInspOrderDo.setOrderSource(saleOrderMain.getOrderSource());
            UocInspOrderDo inspOrderNo = this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo);
            if (null != inspOrderNo) {
                return inspOrderNo.getInspOrderNo();
            }
            throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25");
        }
        throw new BaseBusinessException("101004", "\u751f\u6210\u9a8c\u6536\u5355\u7f16\u53f7\u5931\u8d25\uff0c\u67e5\u8be2\u9500\u552e\u5355\u6570\u636e\u4e3a\u7a7a");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createOrderSettleRelInfo(UocArrvalAcceptanceReqBo reqBo, Long inspOrderId) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null == saleOrderMain) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u5355\u5355\u4e3a\u7a7a");
        this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
            return;
        } else {
            if (!UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u9519\u8bef\u7684\u7ed3\u7b97\u6a21\u5f0f");
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
        }
    }

    private void createRelInfo(UocArrvalAcceptanceReqBo reqBo, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        createOrderRel.setId(IdUtil.nextId());
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        createOrderRel.setRelType(relType);
        createOrderRel.setOrderId(reqBo.getOrderId());
        createOrderRel.setObjId(inspOrderId);
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }

    private void validateAfOrderUnfinished(UocArrvalAcceptanceReqBo reqBo) {
        List shipBoList = reqBo.getShipOrderList();
        ArrayList<UocAfOrder> afOrderList = new ArrayList<UocAfOrder>();
        for (UocCreateInspOrderReqShipBo shipBo : shipBoList) {
            UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
            uocShipOrderDo.setOrderId(reqBo.getOrderId());
            uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
            uocShipOrderDo.setShipOrderId(shipBo.getShipOrderId());
            afOrderList.addAll(this.getAfOrderList(uocShipOrderDo));
        }
        if (CollectionUtils.isEmpty(afOrderList)) {
            return;
        }
        afOrderList.forEach(afOrder -> {
            if (!(Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.COMPLATE) || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.CANCEL) || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS))) {
                throw new BaseBusinessException("100001", "\u8be5\u53d1\u8d27\u5355\u4e2d\u8fd8\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u552e\u540e\u670d\u52a1\u5355\uff0c\u65e0\u6cd5\u8fdb\u884c\u9a8c\u6536\u64cd\u4f5c\uff0c\u8bf7\u5728\u552e\u540e\u5b8c\u7ed3\u540e\u518d\u7ee7\u7eed");
            }
        });
    }

    private List<UocAfOrder> getAfOrderList(UocShipOrderDo uocShipOrderDo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocAfOrderObjQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocAfOrderObjQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        List<UocAfOrderObj> afOrderObjList = this.iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
        List<UocAfOrder> afOrderList = new ArrayList<UocAfOrder>();
        if (!CollectionUtils.isEmpty(afOrderObjList)) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
            uocAfOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
            uocAfOrderQryBo.setAfOrderIds(afOrderObjList.stream().map(obj -> obj.getAfOrderId()).collect(Collectors.toList()));
            afOrderList = this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        }
        return afOrderList;
    }

    private void verifyParam(UocArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getInspFinish()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5b8c\u7ed3\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getClosePennyDiff()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5173\u95ed\u5c3e\u5dee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShipOrderList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            if (null == uocCreateInspOrderReqShipBo.getShipOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocCreateInspOrderReqShipBo.getTaskId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocCreateInspOrderReqShipBo.getStepId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u73af\u8282\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)uocCreateInspOrderReqShipBo.getShipItemList())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                if (null == uocCreateInspOrderReqShipItemBo.getInspCount()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == uocCreateInspOrderReqShipItemBo.getShipItemId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        });
    }
}

