package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendSapOrderInfoReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocQrySendSapOrderInfoRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSendSapOrderBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

/**
 * @description sap订单推送信息查询接口
 * @author Luokan
 * @date 2024/07/04
 **/
@HTServiceImpl
public class UocQrySendSapOrderInfoServiceImpl implements UocQrySendSapOrderInfoService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocQrySendSapOrderInfoRspBO qrySendSalOrderInfo(UocQrySendSapOrderInfoReqBO reqBO) {
        UocQrySendSapOrderInfoRspBO rspBO = UocRu.success(UocQrySendSapOrderInfoRspBO.class);
        //查询销售单，查询销售明细
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            List<UocSendSapOrderBO> sendSapOrderBOList = new ArrayList<>();
            for (UocSaleOrderItem bo : saleOrderItemList) {
                UocSendSapOrderBO uocSendSapOrderBO = new UocSendSapOrderBO();
                uocSendSapOrderBO.setSupplierId(bo.getSupplierId());
                //采购凭证日期	下单创建时间	是
                uocSendSapOrderBO.setBedat(result.getCreateTime().toString());
                //京能e购订单编号	销售单编号	是
                uocSendSapOrderBO.setZddh(result.getSaleOrderNo());
                //京能e购订单明细id	销售明细id	是
                uocSendSapOrderBO.setZddi(bo.getSaleOrderItemId().toString());
                //SAP计划编号	计划编号	是
                uocSendSapOrderBO.setBanfn(bo.getPlanNo());
                //SAP计划明细编号	计划明细编号	是
                uocSendSapOrderBO.setBnfpo(bo.getPlanItemNo());
                //采购订单数量	计划明细扣减数量（转换后的）	是
                uocSendSapOrderBO.setMenge(bo.getPurchaseCount().multiply(bo.getPlanConversionRate()).toString());
                //采购凭证中的净价	"未含税销售单价 含税单价/（1+0.13）保留4位，四舍五入"	是
                BigDecimal tax = bo.getTax().divide(new BigDecimal(100));
                BigDecimal devideNum = BigDecimal.ONE.add(tax);
                BigDecimal untaxSalePrice = bo.getSalePrice().divide(devideNum, 4, RoundingMode.HALF_UP);
                uocSendSapOrderBO.setNetpr(untaxSalePrice.toString());
                //京能e购商品编码	商品编码	是
                uocSendSapOrderBO.setExtSkuId(bo.getSkuCode());
                //京能e购商品名称	商品名称	是
                uocSendSapOrderBO.setSkuName(bo.getSkuName());
                //商品含税单价(元)	销售单价	是
                uocSendSapOrderBO.setSalePrice(bo.getSalePrice().toString());
                //销售单位明细数量	下单数量	是
                uocSendSapOrderBO.setPurchaseCount(bo.getPurchaseCount().toString());
                //物料编码	物料编码	是
                uocSendSapOrderBO.setMaterialCode(bo.getSkuMaterialCode());
                //物料名称	物料名称	是
                uocSendSapOrderBO.setMaterialName(bo.getSkuMaterialName());
                //申购人	下单人中文名	是
                uocSendSapOrderBO.setCreateName(result.getCreateOperName());
                //销售计量单位	单位中文名	是
                uocSendSapOrderBO.setUnitName(bo.getUnitName());
                //单位转换比例	计划转换比例	是
                uocSendSapOrderBO.setConversionRatio(bo.getPlanConversionRate().toString());
                //订单含税金额(元)	销售总金额	是
                uocSendSapOrderBO.setSaleFee(bo.getSaleFee().toString());
                //订单不含税金额(元)	销售总金额（不含税）	是
                BigDecimal totalNoTaxSaleFee = untaxSalePrice.multiply(bo.getPurchaseCount());
                uocSendSapOrderBO.setNoSaleFee(totalNoTaxSaleFee.toString());
                sendSapOrderBOList.add(uocSendSapOrderBO);
            }
            rspBO.setSendSapOrderBOList(sendSapOrderBOList);
        }
        return rspBO;
    }
}
