package com.tydic.dyc.oc.model.order;

import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrder
 * 说明:订单领域对象
 * 时间:2022-02-21 12:29
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderDo extends BaseUmcReqBo {
    private static final long serialVersionUID = -6770269812694625326L;

    //订单id")
    private Long orderId;

    //父订单id")
    private Long upperOrderId;

    //订单编码")
    private String orderNo;

    //外部订单编码")
    private String orderNoExt;

    //订单名称")
    private String orderName;

    //下单系统")
    private String orderSystem;

    //订单级别             1 个人订单             2 企业订单")
    private Integer orderLevel;

    //订单类型 :1.采购电商")
    private Integer orderType;

    //支付类型")
    private Integer payMod;

    //支付方式")
    private String payType;

    //支付状态")
    private String payState;

    //需要开票标识 0不开票 1需要开票")
    private Integer needInvoiceTag;

    //订单状态")
    private String orderState;

    //流转状态")
    private String procState;

    //订单说明")
    private String orderDesc;

    //销售金额")
    private BigDecimal totalSaleFee;

    //采购金额")
    private BigDecimal totalPurchaseFee;

    //优惠金额")
    private BigDecimal totalActShareFee;

    //收货地址ID")
    private Long contactId;

    //运费")
    private BigDecimal totalTransFee;

    //实付金额")
    private BigDecimal usedFee;

    //实付积分")
    private BigDecimal usedIntegral;

    //竣工标志       0 在途         1 竣工          ")
    private Integer finishFlag;

    //租户ID")
    private String tenantId;

    //送货时间")
    private Date sendTime;

    //创建时间")
    private Date createTime;

    //创建工号")
    private String createOperId;

    //创建人名称")
    private String createOperName;

    //更新时间")
    private Date updateTime;

    //更新工号")
    private String updateOperId;

    //更新时间")
    private String updateOperName;

    //撤单时间")
    private Date cancelTime;

    //撤单工号")
    private String cancelOperId;

    //撤单原因")
    private String cancelReason;

    //撤单标志:1 已撤单             0 未撤单")
    private Integer cancelFlag;

    //备注")
    private String remark;

    //竣工时间")
    private Date finishTime;

    //逾期时间")
    private Date expTime;

    //采购方账套id")
    private String purAccount;

    //采购方账套名称")
    private String purAccountName;

    //采购方联系人")
    private String purContactName;

    //采购方联系人电话")
    private String purMobile;

    //需方联系人名称")
    private String purNeedName;

    //需方联系电话")
    private String purNeedMobile;

    //运营机构信息")
    private UocOrderOperating operating;

    //订单扩展")
    private List<UocOrderMap> orderExt;
    
    //销售单扩展")
    private List<UocSaleOrderMap> saleOrderMapList;
    
    
    //发票信息")
    private UocOrdInvoice uocOrdInvoice;

    //订单明细")
    private List<UocOrderItem> orderItems;

    //收货人地址信息")
    private UocOrdLogisticsRela receiverAddress;

    //发票地址信息")
    private UocOrdLogisticsRela invoiceAddress;

    //订单附件信息")
    private List<UocOrderAccessory> accessoryList;
    //删除标志1已删除")
    private Integer delTag;

    /**
     * 供应商信息
     */
    private List<UocSupplierInfoBo> supplierBos;
    /**
     * 用户类型：1 外部个人 2 外部企业 3内部个人 4 内部企业
     */
    private String userType;
    private String dataAchiveTabSuffix;
    
    //议价单id
    private Long bargainingId;
    
    //议价单编号
    private String bargainingNo;


    //京能新增参数开始
    /**
     * 是否需要保存 oa 审批结果  0不需要 1 需要
     */
    private Integer saveOaApprovalResult = 0;

    /**
     * 是否需要补充计划 0不需要 1 需要
     */
    private Integer requireSupplementalPlan = 0;
    /**
     * 费用承担单位id
     */
    private Long costBearingOrgId;
    /**
     * 费用承担单位公司id
     */
    private Long costBearingCompanyId;
    /**
     * 费用承担单位名称
     */
    private String costBearingOrgName;
    /**
     * 费用承担单位机构树路径
     */
    private String costBearingOrgPath;
    /**
     * 成本扣减单位 id
     */
    private Long reduceOrgId;
    /**
     * 专区类型 1-工业品；2-办公用品
     */
    private Integer areaType;

    /**
     * 是否校验额度 0否 1是
     */
    private Integer isReduceQuota = 1;
    //京能新增参数结束
    /**
     * 是否跳过发货和到货确认
     */
    private Integer isAgrIgnoreArrive;
    /**
     * 是否物料下单
     */
    private Integer isMatOrder;
}
